/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdse;
import com.google.android.gms.internal.zzdta;
import com.google.android.gms.internal.zzdtb;
import com.google.android.gms.internal.zzdtd;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public abstract class zzdsa
implements zzdtb {
    private static final byte[] zzlup = new byte[16];
    static final int[] zzluq = zzdsa.zza(ByteBuffer.wrap(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107}));
    final zzdta zzlur;

    zzdsa(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("The key length in bytes must be 32.");
        }
        this.zzlur = zzdta.zzak(byArray);
    }

    static zzdsa zzah(byte[] byArray) {
        return new zzdsc(byArray, null);
    }

    static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    static int[] zza(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }

    final int[] zzf(int[] nArray) {
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        this.zzg(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray2[n] = nArray2[n] + nArray[i];
        }
        return nArray2;
    }

    abstract void zzg(int[] var1);

    abstract int[] zzd(byte[] var1, int var2);

    abstract void zzh(int[] var1);

    abstract int zzbos();

    abstract zzdse zzai(byte[] var1);

    private static void zza(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, zzdse zzdse2) {
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer2.hasRemaining()) {
            int n = byteBuffer2.remaining() < 64 ? byteBuffer2.remaining() : 64;
            byteBuffer3.asIntBuffer().put(zzdse2.zzbot());
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)(byteBuffer2.get() ^ byteBuffer3.get(i)));
            }
        }
    }

    @Override
    public final byte[] zzaf(byte[] byArray) throws GeneralSecurityException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12 + byArray.length);
        this.zza(byteBuffer, byArray);
        return byteBuffer.array();
    }

    final void zza(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byArray.length > 0x7FFFFFF3) {
            throw new GeneralSecurityException("plaintext too long");
        }
        if (byteBuffer.remaining() < byArray.length + 12) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] byArray2 = zzdtd.zzgc(12);
        byteBuffer.put(byArray2);
        zzdsa.zza(byteBuffer, ByteBuffer.wrap(byArray), this.zzai(byArray2));
    }
}

