/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaek;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzagw;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zznp;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoy;
import com.google.android.gms.internal.zzoz;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzzb;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
public class zzoe
implements zzoa {
    private final Object mLock = new Object();
    private final zzob zzbsv;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbsy;
    @Nullable
    private final zzyg zzaqq;
    @Nullable
    private final zzoc zzbsz;
    private final zzcs zzbta;
    @Nullable
    private final zzaiy zzaov;
    boolean zzbtb;
    @Nullable
    private String zzaqr;
    @Nullable
    private zzaek zzapk;
    private WeakReference<View> zzbtc = null;

    public zzoe(Context context, zzob zzob2, @Nullable zzyg zzyg2, zzcs zzcs2, @Nullable JSONObject jSONObject, @Nullable zzoc zzoc2, @Nullable zzaiy zzaiy2, @Nullable String string2) {
        this.mContext = context;
        this.zzbsv = zzob2;
        this.zzaqq = zzyg2;
        this.zzbta = zzcs2;
        this.zzbsy = jSONObject;
        this.zzbsz = zzoc2;
        this.zzaov = zzaiy2;
        this.zzaqr = string2;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zznp zznp2 = this.zzbsz.zzjp();
        if (zznp2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zznp2.zzjj()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zznq zznq2 = new zznq(this.mContext, zznp2, layoutParams);
        zznq2.setOnClickListener(onClickListener);
        zzmg<String> zzmg2 = zzmq.zzbnb;
        zznq2.setContentDescription(zzbs.zzep().zzd(zzmg2));
        return zznq2;
    }

    @Override
    public boolean zzjw() {
        zznp zznp2 = this.zzbsz.zzjp();
        return zznp2 != null && zznp2.zzjk();
    }

    @Override
    public boolean zzjx() {
        return this.zzbsy != null && this.zzbsy.optBoolean("allow_pub_owned_ad_view", false);
    }

    private final boolean zzaq(String string2) {
        JSONObject jSONObject = this.zzbsy == null ? null : this.zzbsy.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, String string2, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzi(view2);
        JSONObject jSONObject3 = zzoe.zzj(view2);
        JSONObject jSONObject4 = this.zzk(view2);
        JSONObject jSONObject5 = null;
        try {
            JSONObject jSONObject6 = zzbs.zzec().zza(bundle, null);
            jSONObject5 = new JSONObject();
            jSONObject5.put("click_point", (Object)jSONObject6);
            jSONObject5.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbq.zzga((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), bundle, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzbsz.zzjo())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzbsz.zzjo())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzafj.zzbw((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzaq("click_reporting")) {
            zzafj.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string2 = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbs.zzec().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, String string2, JSONObject jSONObject5, JSONObject jSONObject6) {
        zzbq.zzga((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzbsy);
            if (jSONObject2 != null) {
                jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject7.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject5 != null) {
                jSONObject7.put("click_signal", (Object)jSONObject5);
            }
            if (jSONObject3 != null) {
                jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            }
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", (Object)this.zzbsz.zzjo());
            zzbs.zzee();
            jSONObject8.put("is_privileged_process", zzagw.zzqd());
            jSONObject8.put("has_custom_click_handler", this.zzbsv.zzr(this.zzbsz.getCustomTemplateId()) != null);
            jSONObject7.put("has_custom_click_handler", this.zzbsv.zzr(this.zzbsz.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject9 = this.zzbsy.optJSONObject("tracking_urls_and_actions");
                if (jSONObject9 == null) {
                    jSONObject9 = new JSONObject();
                }
                String string3 = jSONObject9.optString("click_string");
                String string4 = this.zzbta.zzad().zza(this.mContext, string3, view);
                jSONObject8.put("click_signals", (Object)string4);
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject7.put("click", (Object)jSONObject8);
            if (jSONObject6 != null) {
                jSONObject7.put("provided_signals", (Object)jSONObject6);
            }
            jSONObject7.put("ads_id", (Object)this.zzaqr);
            zzaje.zza(this.zzaqq.zzj(jSONObject7), "NativeAdEngineImpl.performClick");
            return;
        }
        catch (JSONException jSONException) {
            zzafj.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzbta.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzafj.zzbw((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzaq("touch_reporting")) {
            zzafj.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbta.zzad().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbtb) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zza(view, map);
            return;
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzi(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzoe.zzj(view);
        JSONObject jSONObject4 = this.zzk(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, jSONObject4, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzaq("impression_reporting")) {
            zzafj.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbs.zzec().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbq.zzga((String)"recordImpression must be called on the main UI thread.");
        if (this.zzbtb) {
            return true;
        }
        this.zzbtb = true;
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbsy);
            jSONObject6.put("ads_id", (Object)this.zzaqr);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            }
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            zzaje.zza(this.zzaqq.zzk(jSONObject6), "NativeAdEngineImpl.recordImpression");
        }
        catch (JSONException jSONException) {
            zzafj.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbsv.zza(this);
        this.zzbsv.zzbw();
        return true;
    }

    @Override
    public final View zzkd() {
        if (this.zzbtc != null) {
            return (View)this.zzbtc.get();
        }
        return null;
    }

    @Override
    public final void zzg(View view) {
        this.zzbtc = new WeakReference<View>(view);
    }

    public void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        zzmg<Boolean> zzmg2 = zzmq.zzbmz;
        if (!zzbs.zzep().zzd(zzmg2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map != null) {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
                view2.setClickable(true);
                view2.setOnClickListener(onClickListener);
            }
        }
        if (map2 != null) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
            }
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzmg<Boolean> zzmg2 = zzmq.zzbmy;
        if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzama zzka() throws zzamm {
        if (this.zzbsy == null || this.zzbsy.optJSONObject("overlay") == null) {
            return null;
        }
        zzoe zzoe2 = this;
        zzaiy zzaiy2 = zzoe2.zzaov;
        zzcs zzcs2 = zzoe2.zzbta;
        zziw zziw2 = zziw.zzg((Context)zzoe2.mContext);
        Context context = zzoe2.mContext;
        zzama zzama2 = zzbs.zzed().zza(context, zzanp.zzc(zziw2), zziw2.zzbda, false, false, zzcs2, zzaiy2, null, null, null, zzib.zzhi());
        if (zzama2 != null) {
            zzama zzama3 = zzama2;
            if (zzama3 == null) {
                throw null;
            }
            ((View)zzama3).setVisibility(8);
            new zzog(zzama2).zza(this.zzaqq);
        }
        return zzama2;
    }

    public final void zzg(Map<String, WeakReference<View>> map) {
        if (this.zzbsz.zzjq() != null) {
            if ("2".equals(this.zzbsz.zzjo())) {
                zzbs.zzeg().zzb(this.mContext, this.zzbsv.getAdUnitId(), this.zzbsz.zzjo(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzbsz.zzjo())) {
                zzbs.zzeg().zzb(this.mContext, this.zzbsv.getAdUnitId(), this.zzbsz.zzjo(), map.containsKey("1009"));
            }
        }
    }

    public final boolean zzb(View view, zzny zzny2) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzbsz.zzjq();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbsv.zza(zzny2);
            return true;
        }
        return false;
    }

    @Override
    public final void zza(View view, zzny zzny2) {
        Object object;
        zzoy zzoy2;
        if (this.zzb(view, zzny2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzbsz instanceof zzod)) {
            return;
        }
        zzod zzod2 = (zzod)this.zzbsz;
        if (zzod2.getImages() != null && zzod2.getImages().size() > 0 && (zzoy2 = (object = zzod2.getImages().get(0)) instanceof IBinder ? zzoz.zzk((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzoy2.zzjl();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzx((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzoe)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzafj.zzco((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zzkc() {
        this.zzbsv.zzcp();
    }

    @Override
    public void zzkb() {
        this.zzaqq.zzlm();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzh(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzt(int n) {
        zzjk.zzhx();
        return zzais.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzt(rect.right - rect.left));
        jSONObject.put("height", this.zzt(rect.bottom - rect.top));
        jSONObject.put("x", this.zzt(rect.left));
        jSONObject.put("y", this.zzt(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzi(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzoe.zzh(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzt(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzt(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzt(nArray[0]));
            jSONObject3.put("y", this.zzt(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzt(nArray[0]));
                jSONObject2.put("y", this.zzt(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzafj.zzco((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzj(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzec();
            int n = zzagr.zzr(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzk(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbs.zzec();
            jSONObject.put("can_show_on_lock_screen", zzagr.zzq(view));
            zzbs.zzec();
            jSONObject.put("is_keyguard_locked", zzagr.zzas(this.mContext));
        }
        catch (JSONException jSONException) {
            zzafj.zzco((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzoe.zzh(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzoe.zzh(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzt(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzt(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzt(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzt(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzt(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzt(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzafj.zzco((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzaek zzke() {
        if (zzbs.zzfa().zzt(this.mContext)) {
            if (this.zzapk == null) {
                this.zzapk = new zzaek(this.mContext, this.zzbsv.getAdUnitId());
            }
            return this.zzapk;
        }
        return null;
    }
}

