/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzzb;
import java.util.Map;

@zzzb
public final class zzvt
extends zzwg {
    private final Map<String, String> zzbqw;
    private final Context mContext;
    private String zzcep;
    private long zzceq;
    private long zzcer;
    private String zzces;
    private String zzcet;

    public zzvt(zzama zzama2, Map<String, String> map) {
        super(zzama2, "createCalendarEvent");
        this.zzbqw = map;
        this.mContext = zzama2.zzrz();
        zzvt zzvt2 = this;
        zzvt2.zzcep = zzvt2.zzbj("description");
        zzvt2.zzces = zzvt2.zzbj("summary");
        zzvt2.zzceq = zzvt2.zzbk("start_ticks");
        zzvt2.zzcer = zzvt2.zzbk("end_ticks");
        zzvt2.zzcet = zzvt2.zzbj("location");
    }

    private final String zzbj(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbqw.get(string2))) {
            return "";
        }
        return this.zzbqw.get(string2);
    }

    private final long zzbk(String string2) {
        String string3 = this.zzbqw.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbl("Activity context is not available.");
            return;
        }
        zzbs.zzec();
        if (!zzagr.zzak(this.mContext).zzio()) {
            this.zzbl("This feature is not available on the device.");
            return;
        }
        zzbs.zzec();
        AlertDialog.Builder builder = zzagr.zzaj(this.mContext);
        Resources resources = zzbs.zzeg().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzvu(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzvv(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzcep);
        intent.putExtra("eventLocation", this.zzcet);
        intent.putExtra("description", this.zzces);
        if (this.zzceq > -1L) {
            intent.putExtra("beginTime", this.zzceq);
        }
        if (this.zzcer > -1L) {
            intent.putExtra("endTime", this.zzcer);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzvt zzvt2) {
        return zzvt2.mContext;
    }
}

