/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzaaq;
import com.google.android.gms.internal.zzaar;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzzb;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzzb
public final class zzaap
extends zzbej {
    public static final Parcelable.Creator<zzaap> CREATOR = new zzaar();
    private ParcelFileDescriptor zzcoi;
    private Parcelable zzcoj;
    private boolean zzcok;

    public zzaap(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcoi = parcelFileDescriptor;
        this.zzcoj = null;
        this.zzcok = true;
    }

    public zzaap(zzben zzben2) {
        this.zzcoi = null;
        this.zzcoj = zzben2;
        this.zzcok = false;
    }

    public final <T extends zzben> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcok) {
            byte[] byArray;
            if (this.zzcoi == null) {
                zzafj.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcoi));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzafj.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                zzn.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcoj = (zzben)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcok = false;
        }
        return (T)((zzben)this.zzcoj);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zznh();
        Parcel parcel2 = parcel;
        zzaap zzaap2 = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Parcelable)zzaap2.zzcoi, (int)n, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zznh() {
        if (this.zzcoi == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzcoj.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzcoi = this.zze(byArray);
        }
        return this.zzcoi;
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzaaq zzaaq2 = new zzaaq(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzaaq2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzafj.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbs.zzeg().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzn.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

