/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzb;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzzb
@TargetApi(value=14)
public final class zzfy
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzawk;
    private final Context mApplicationContext;
    private Application zzawl;
    private final WindowManager zzavc;
    private final PowerManager zzavd;
    private final KeyguardManager zzave;
    @Nullable
    private BroadcastReceiver zzavm;
    private WeakReference<ViewTreeObserver> zzawm;
    private WeakReference<View> zzawn;
    private zzgd zzawo;
    private zzail zzaui = new zzail(zzawk);
    private boolean zzavl = false;
    private int zzawp = -1;
    private HashSet<zzgc> zzawq = new HashSet();
    private DisplayMetrics zzawr;

    public zzfy(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzavc = (WindowManager)context.getSystemService("window");
        this.zzavd = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzave = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzawl = (Application)this.mApplicationContext;
            this.zzawo = new zzgd((Application)this.mApplicationContext, this);
        }
        this.zzawr = context.getResources().getDisplayMetrics();
        View view2 = view;
        zzfy zzfy2 = this;
        View view3 = zzfy2.zzawn != null ? (View)zzfy2.zzawn.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfy2);
            zzfy2.zze(view3);
        }
        zzfy2.zzawn = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbs.zzee().isAttachedToWindow(view2)) {
                zzfy2.zzd(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfy2);
        }
    }

    public final void zza(zzgc zzgc2) {
        this.zzawq.add(zzgc2);
        this.zzm(3);
    }

    public final void zzb(zzgc zzgc2) {
        this.zzawq.remove(zzgc2);
    }

    private final void zzge() {
        zzbs.zzec();
        zzagr.zzczc.post((Runnable)new zzfz(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzawp = -1;
        this.zzd(view);
        this.zzm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzawp = -1;
        this.zzm(3);
        this.zzge();
        this.zze(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzawn == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzawn.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzawp = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzge();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzge();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzge();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzm(3);
        this.zzge();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzm(3);
        this.zzge();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzm(3);
        this.zzge();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzm(3);
        this.zzge();
    }

    public final void onGlobalLayout() {
        this.zzm(2);
        this.zzge();
    }

    public final void onScrollChanged() {
        this.zzm(1);
    }

    public final void zzgf() {
        this.zzm(4);
    }

    private final void zzm(int n) {
        boolean bl;
        if (this.zzawq.size() == 0) {
            return;
        }
        if (this.zzawn == null) {
            return;
        }
        View view = (View)this.zzawn.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        new Rect().right = this.zzavc.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzavc.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzawp != -1 ? this.zzawp : n2;
        boolean bl6 = bl = !bl3 && zzbs.zzec().zza(view, this.zzavd, this.zzave) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzaui.tryAcquire() && bl == this.zzavl) {
            return;
        }
        if (!bl && !this.zzavl && n == 1) {
            return;
        }
        zzgb zzgb2 = new zzgb(zzbs.zzei().elapsedRealtime(), this.zzavd.isScreenOn(), view != null ? zzbs.zzee().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzawr.density, bl);
        Iterator<zzgc> iterator = this.zzawq.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgb2);
        }
        this.zzavl = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzn(rect.left), this.zzn(rect.top), this.zzn(rect.right), this.zzn(rect.bottom));
    }

    private final int zzn(int n) {
        float f = this.zzawr.density;
        return (int)((float)n / f);
    }

    private final void zzd(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzawm = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzfy zzfy2 = this;
        if (zzfy2.zzavm == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzfy2.zzavm = new zzga(zzfy2);
            zzfy2.mApplicationContext.registerReceiver(zzfy2.zzavm, intentFilter);
        }
        if (this.zzawl != null) {
            try {
                this.zzawl.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzawo);
                return;
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzawm != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzawm.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzawm = null;
            }
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzfy zzfy2 = this;
        if (zzfy2.zzavm != null) {
            try {
                zzfy2.mApplicationContext.unregisterReceiver(zzfy2.zzavm);
            }
            catch (IllegalStateException illegalStateException) {
                zzafj.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbs.zzeg().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzfy2.zzavm = null;
        }
        if (this.zzawl != null) {
            try {
                this.zzawl.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzawo);
                return;
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzfy zzfy2, int n) {
        zzfy2.zzm(3);
    }

    static {
        zzmg<Long> zzmg2 = zzmq.zzbkz;
        zzawk = zzbs.zzep().zzd(zzmg2);
    }
}

