/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zza;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzagw;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzwk;
import com.google.android.gms.internal.zzzb;
import java.util.Collections;

@zzzb
public final class zzd
extends zzwk
implements zzt {
    private static int zzcgi = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzcgj;
    private zzama zzbwq;
    private zzi zzcgk;
    private zzo zzcgl;
    private boolean zzcgm = false;
    private FrameLayout zzcgn;
    private WebChromeClient.CustomViewCallback zzcgo;
    private boolean zzcgp = false;
    private boolean zzcgq = false;
    private zzh zzcgr;
    private boolean zzcgs = false;
    private int zzcgt = 0;
    private final Object zzcgu = new Object();
    private Runnable zzcgv;
    private boolean zzcgw;
    private boolean zzcgx;
    private boolean zzcgy = false;
    private boolean zzcgz = false;
    private boolean zzcha = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzcgt = 2;
        this.mActivity.finish();
    }

    public final void zzmm() {
        if (this.zzcgj != null && this.zzcgm) {
            this.setRequestedOrientation(this.zzcgj.orientation);
        }
        if (this.zzcgn != null) {
            this.mActivity.setContentView((View)this.zzcgr);
            this.zzcgx = true;
            this.zzcgn.removeAllViews();
            this.zzcgn = null;
        }
        if (this.zzcgo != null) {
            this.zzcgo.onCustomViewHidden();
            this.zzcgo = null;
        }
        this.zzcgm = false;
    }

    @Override
    public final void zzmn() {
        this.zzcgt = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzcgt = 0;
    }

    public final boolean zzmo() {
        this.zzcgt = 0;
        if (this.zzbwq == null) {
            return true;
        }
        boolean bl = this.zzbwq.zzsv();
        if (!bl) {
            this.zzbwq.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public final void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcgp = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcgj = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzcgj == null) {
                throw new zzg("Could not get info for ad overlay.");
            }
            if (this.zzcgj.zzatd.zzdca > 7500000) {
                this.zzcgt = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcha = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcgq = this.zzcgj.zzchr != null ? this.zzcgj.zzchr.zzapr : false;
            zzmg<Boolean> zzmg2 = zzmq.zzbmk;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && this.zzcgq && this.zzcgj.zzchr.zzapw != -1) {
                new zzj(this, null).zzps();
            }
            if (bundle == null) {
                if (this.zzcgj.zzchi != null && this.zzcha) {
                    this.zzcgj.zzchi.zzcb();
                }
                if (this.zzcgj.zzchp != 1 && this.zzcgj.zzchh != null) {
                    this.zzcgj.zzchh.onAdClicked();
                }
            }
            this.zzcgr = new zzh((Context)this.mActivity, this.zzcgj.zzchq, this.zzcgj.zzatd.zzcp);
            this.zzcgr.setId(1000);
            switch (this.zzcgj.zzchp) {
                case 1: {
                    this.zzs(false);
                    return;
                }
                case 2: {
                    this.zzcgk = new zzi(this.zzcgj.zzchj);
                    this.zzs(false);
                    return;
                }
                case 3: {
                    this.zzs(true);
                    return;
                }
                case 4: {
                    if (this.zzcgp) {
                        this.zzcgt = 3;
                        this.mActivity.finish();
                        return;
                    }
                    zzbs.zzdz();
                    if (zza.zza((Context)this.mActivity, this.zzcgj.zzchg, this.zzcgj.zzcho)) break;
                    this.zzcgt = 3;
                    this.mActivity.finish();
                    return;
                }
                default: {
                    throw new zzg("Could not determine ad overlay type.");
                }
            }
            return;
        }
        catch (zzg zzg2) {
            zzafj.zzco((String)zzg2.getMessage());
            this.zzcgt = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzmg<Boolean> zzmg2 = zzmq.zzbpi;
        if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
            if (this.zzbwq != null && !this.zzbwq.isDestroyed()) {
                zzbs.zzee();
                zzagw.zzi(this.zzbwq);
                return;
            }
            zzafj.zzco((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzcgj != null && this.zzcgj.zzchp == 4) {
            if (this.zzcgp) {
                this.zzcgt = 3;
                this.mActivity.finish();
            } else {
                this.zzcgp = true;
            }
        }
        if (this.zzcgj.zzchi != null) {
            this.zzcgj.zzchi.onResume();
        }
        zzmg<Boolean> zzmg2 = zzmq.zzbpi;
        if (!zzbs.zzep().zzd(zzmg2).booleanValue()) {
            if (this.zzbwq != null && !this.zzbwq.isDestroyed()) {
                zzbs.zzee();
                zzagw.zzi(this.zzbwq);
                return;
            }
            zzafj.zzco((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzmm();
        if (this.zzcgj.zzchi != null) {
            this.zzcgj.zzchi.onPause();
        }
        zzmg<Boolean> zzmg2 = zzmq.zzbpi;
        if (!(zzbs.zzep().zzd(zzmg2).booleanValue() || this.zzbwq == null || this.mActivity.isFinishing() && this.zzcgk != null)) {
            zzbs.zzee();
            zzagw.zzh(this.zzbwq);
        }
        this.zzmq();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzk(IObjectWrapper iObjectWrapper) {
        zzmg<Boolean> zzmg2 = zzmq.zzbph;
        if (zzbs.zzep().zzd(zzmg2).booleanValue() && zzq.isAtLeastN()) {
            Configuration configuration = (Configuration)zzn.zzx((IObjectWrapper)iObjectWrapper);
            zzbs.zzec();
            if (zzagr.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcgp);
    }

    public final void onStop() {
        zzmg<Boolean> zzmg2 = zzmq.zzbpi;
        if (zzbs.zzep().zzd(zzmg2).booleanValue() && this.zzbwq != null && (!this.mActivity.isFinishing() || this.zzcgk == null)) {
            zzbs.zzee();
            zzagw.zzh(this.zzbwq);
        }
        this.zzmq();
    }

    public final void onDestroy() {
        if (this.zzbwq != null) {
            zzama zzama2 = this.zzbwq;
            if (zzama2 == null) {
                throw null;
            }
            this.zzcgr.removeView((View)zzama2);
        }
        this.zzmq();
    }

    private final void zzr(boolean bl) {
        zzmg<Integer> zzmg2 = zzmq.zzbpj;
        int n = zzbs.zzep().zzd(zzmg2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        this.zzcgl = new zzo((Context)this.mActivity, zzp2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzcgj.zzchm);
        this.zzcgr.addView((View)this.zzcgl, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzba() {
        this.zzcgx = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzmg<Boolean> zzmg2 = zzmq.zzbkb;
        boolean bl4 = bl3 = zzbs.zzep().zzd(zzmg2) != false && this.zzcgj != null && this.zzcgj.zzchr != null && this.zzcgj.zzchr.zzapy;
        if (bl && bl2 && bl3) {
            new zzwg(this.zzbwq, "useCustomClose").zzbl("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzcgl != null) {
            this.zzcgl.zza(bl, bl2 && !bl3);
        }
    }

    public final void zzmp() {
        this.zzcgr.removeView((View)this.zzcgl);
        this.zzr(true);
    }

    public final void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcgn = new FrameLayout((Context)this.mActivity);
        this.zzcgn.setBackgroundColor(-16777216);
        this.zzcgn.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcgn);
        this.zzcgx = true;
        this.zzcgo = customViewCallback;
        this.zzcgm = true;
    }

    private final void zzs(boolean bl) throws zzg {
        boolean bl2;
        zzmg<Boolean> zzmg2;
        Window window;
        if (!this.zzcgx) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzg("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (zzq.isAtLeastN()) {
            zzmg2 = zzmq.zzbph;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                zzbs.zzec();
                bl3 = zzagr.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzcgj.zzchr != null && this.zzcgj.zzchr.zzaps;
        if ((!this.zzcgq || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzmg2 = zzmq.zzbka;
            if (zzbs.zzep().zzd(zzmg2).booleanValue() && zzq.zzalz() && this.zzcgj.zzchr != null && this.zzcgj.zzchr.zzapx) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        zzamb zzamb2 = this.zzcgj.zzchj != null ? this.zzcgj.zzchj.zzsq() : null;
        boolean bl5 = zzamb2 != null ? zzamb2.zzfr() : false;
        this.zzcgs = false;
        if (bl5) {
            if (this.zzcgj.orientation == zzbs.zzee().zzpz()) {
                this.zzcgs = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcgj.orientation == zzbs.zzee().zzqa()) {
                this.zzcgs = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcgs;
        zzafj.zzbw((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcgj.orientation);
        if (zzbs.zzee().zza(window)) {
            zzafj.zzbw((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcgq) {
            this.zzcgr.setBackgroundColor(-16777216);
        } else {
            this.zzcgr.setBackgroundColor(zzcgi);
        }
        this.mActivity.setContentView((View)this.zzcgr);
        this.zzcgx = true;
        if (bl) {
            try {
                this.zzbwq = zzbs.zzed().zza((Context)this.mActivity, this.zzcgj.zzchj != null ? this.zzcgj.zzchj.zzso() : null, this.zzcgj.zzchj != null ? this.zzcgj.zzchj.zzsp() : null, true, bl5, null, this.zzcgj.zzatd, null, null, this.zzcgj.zzchj != null ? this.zzcgj.zzchj.zzbk() : null, zzib.zzhi());
            }
            catch (Exception exception) {
                zzafj.zzb((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzg("Could not obtain webview for the overlay.");
            }
            this.zzbwq.zzsq().zza(null, null, this.zzcgj.zzchk, this.zzcgj.zzcho, true, null, this.zzcgj.zzchj != null ? this.zzcgj.zzchj.zzsq().zztd() : null, null, null);
            this.zzbwq.zzsq().zza(new zze(this));
            if (this.zzcgj.url != null) {
                this.zzbwq.loadUrl(this.zzcgj.url);
            } else if (this.zzcgj.zzchn != null) {
                this.zzbwq.loadDataWithBaseURL(this.zzcgj.zzchl, this.zzcgj.zzchn, "text/html", "UTF-8", null);
            } else {
                throw new zzg("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcgj.zzchj != null) {
                this.zzcgj.zzchj.zzc(this);
            }
        } else {
            this.zzbwq = this.zzcgj.zzchj;
            this.zzbwq.setContext((Context)this.mActivity);
        }
        this.zzbwq.zzb(this);
        ViewParent viewParent = this.zzbwq.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            zzama zzama2 = this.zzbwq;
            if (zzama2 == null) {
                throw null;
            }
            ((ViewGroup)viewParent).removeView((View)zzama2);
        }
        if (this.zzcgq) {
            this.zzbwq.zztb();
        }
        zzama zzama3 = this.zzbwq;
        if (zzama3 == null) {
            throw null;
        }
        this.zzcgr.addView((View)zzama3, -1, -1);
        if (!bl && !this.zzcgs) {
            this.zzmt();
        }
        this.zzr(bl5);
        if (this.zzbwq.zzsr()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzmq() {
        if (!this.mActivity.isFinishing() || this.zzcgy) {
            return;
        }
        this.zzcgy = true;
        if (this.zzbwq != null) {
            int n = this.zzcgt;
            this.zzbwq.zzag(n);
            Object object = this.zzcgu;
            synchronized (object) {
                if (!this.zzcgw && this.zzbwq.zzsx()) {
                    this.zzcgv = new zzf(this);
                    zzmg<Long> zzmg2 = zzmq.zzbjz;
                    zzagr.zzczc.postDelayed(this.zzcgv, zzbs.zzep().zzd(zzmg2).longValue());
                    return;
                }
            }
        }
        this.zzmr();
    }

    final void zzmr() {
        if (this.zzcgz) {
            return;
        }
        this.zzcgz = true;
        if (this.zzbwq != null) {
            zzama zzama2 = this.zzbwq;
            if (zzama2 == null) {
                throw null;
            }
            this.zzcgr.removeView((View)zzama2);
            if (this.zzcgk != null) {
                this.zzbwq.setContext(this.zzcgk.zzaif);
                this.zzbwq.zzac(false);
                zzama zzama3 = this.zzbwq;
                if (zzama3 == null) {
                    throw null;
                }
                this.zzcgk.parent.addView((View)zzama3, this.zzcgk.index, this.zzcgk.zzchd);
                this.zzcgk = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbwq.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbwq = null;
        }
        if (this.zzcgj != null && this.zzcgj.zzchi != null) {
            this.zzcgj.zzchi.zzca();
        }
    }

    public final void zzms() {
        if (this.zzcgs) {
            this.zzcgs = false;
            this.zzmt();
        }
    }

    private final void zzmt() {
        this.zzbwq.zzmt();
    }

    public final void zzmu() {
        this.zzcgr.zzchc = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmv() {
        Object object = this.zzcgu;
        synchronized (object) {
            this.zzcgw = true;
            if (this.zzcgv != null) {
                zzagr.zzczc.removeCallbacks(this.zzcgv);
                zzagr.zzczc.post(this.zzcgv);
            }
            return;
        }
    }

    static /* synthetic */ Activity zza(zzd zzd2) {
        return zzd2.mActivity;
    }
}

