/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.gmsg.HttpClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.gmsg.zzy;
import com.google.android.gms.ads.internal.js.zzab;
import com.google.android.gms.ads.internal.js.zzc;
import com.google.android.gms.ads.internal.js.zzo;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzaaa;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaba;
import com.google.android.gms.internal.zzabb;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabf;
import com.google.android.gms.internal.zzabm;
import com.google.android.gms.internal.zzabu;
import com.google.android.gms.internal.zzaev;
import com.google.android.gms.internal.zzafh;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzb;
import com.google.android.gms.internal.zzzd;
import com.google.android.gms.internal.zzzz;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
public final class zzaau
extends zzafh {
    private static long zzcoq = TimeUnit.SECONDS.toMillis(10L);
    private static final Object sLock = new Object();
    private static boolean zzcor = false;
    private static zzo zzcke = null;
    private static HttpClient zzcos = null;
    private static zzy zzcot = null;
    private static zzt<Object> zzcou = null;
    private final zzzd zzckx;
    private final zzaaa zzcky;
    private final Object zzchy = new Object();
    private final Context mContext;
    private zzab zzcov;
    private zzig zzcla;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzaau(Context context, zzaaa zzaaa2, zzzd zzzd2, zzig zzig2) {
        super(true);
        this.zzckx = zzzd2;
        this.mContext = context;
        this.zzcky = zzaaa2;
        this.zzcla = zzig2;
        Object object = sLock;
        synchronized (object) {
            if (!zzcor) {
                zzcot = new zzy();
                zzcos = new HttpClient(context.getApplicationContext(), zzaaa2.zzatd);
                zzcou = new zzabc();
                zzmg<String> zzmg2 = zzmq.zzbfy;
                zzcke = new zzo(this.mContext.getApplicationContext(), this.zzcky.zzatd, zzbs.zzep().zzd(zzmg2), new zzabb(), new zzaba());
                zzcor = true;
            }
            return;
        }
    }

    protected static void zzb(zzc zzc2) {
        zzc2.zza("/loadAd", zzcot);
        zzc2.zza("/fetchHttpRequest", zzcos);
        zzc2.zza("/invalidRequest", zzcou);
    }

    protected static void zzc(zzc zzc2) {
        zzc2.zzb("/loadAd", zzcot);
        zzc2.zzb("/fetchHttpRequest", zzcos);
        zzc2.zzb("/invalidRequest", zzcou);
    }

    @Override
    public final void zzdg() {
        zzafj.zzbw((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzbs.zzfa().zzz(this.mContext);
        zzzz zzzz2 = new zzzz(this.zzcky, -1L, zzbs.zzfa().zzx(this.mContext), zzbs.zzfa().zzy(this.mContext), string2);
        zzbs.zzfa().zzg(this.mContext, string2);
        zzaad zzaad2 = this.zzc(zzzz2);
        long l = zzbs.zzei().elapsedRealtime();
        zzaev zzaev2 = new zzaev(zzzz2, zzaad2, null, null, zzaad2.errorCode, l, zzaad2.zzcnk, null, this.zzcla);
        zzais.zzdbs.post((Runnable)new zzaav(this, zzaev2));
    }

    private final zzaad zzc(zzzz zzzz2) {
        JSONObject jSONObject;
        zzbs.zzec();
        String string2 = zzagr.zzpv();
        JSONObject jSONObject2 = this.zza(zzzz2, string2);
        if (jSONObject2 == null) {
            return new zzaad(0);
        }
        long l = zzbs.zzei().elapsedRealtime();
        Future<JSONObject> future = zzcot.zzar(string2);
        zzais.zzdbs.post((Runnable)new zzaaw(this, jSONObject2, string2));
        long l2 = zzcoq - (zzbs.zzei().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzaad(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzaad(2);
        }
        catch (ExecutionException executionException) {
            return new zzaad(0);
        }
        if (jSONObject == null) {
            return new zzaad(-1);
        }
        zzaad zzaad2 = zzabm.zza(this.mContext, zzzz2, jSONObject.toString());
        if (zzaad2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzaad2.body)) {
            return new zzaad(3);
        }
        return zzaad2;
    }

    private final JSONObject zza(zzzz zzzz2, String string2) {
        Bundle bundle = zzzz2.zzclo.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzabu zzabu2 = null;
        try {
            zzabu2 = zzbs.zzem().zzp(this.mContext).get();
        }
        catch (Exception exception) {
            zzafj.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        Object object = zzzz2;
        zzabf zzabf2 = new zzabf();
        new zzabf().zzcpe = object;
        object = zzabu2;
        v0.zzcpf = object;
        JSONObject jSONObject = zzabm.zza(this.mContext, zzabf2);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzafj.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzbs.zzec().zzp(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzchy;
        synchronized (object) {
            zzais.zzdbs.post((Runnable)new zzaaz(this));
            return;
        }
    }

    static /* synthetic */ zzy zzni() {
        return zzcot;
    }

    static /* synthetic */ zzzd zza(zzaau zzaau2) {
        return zzaau2.zzckx;
    }

    static /* synthetic */ zzab zzb(zzaau zzaau2) {
        return zzaau2.zzcov;
    }

    static /* synthetic */ zzab zza(zzaau zzaau2, zzab zzab2) {
        zzaau2.zzcov = zzab2;
        return zzaau2.zzcov;
    }

    static /* synthetic */ zzo zznj() {
        return zzcke;
    }
}

