/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Range;
import com.google.android.gms.internal.zzzb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzb
public final class zzaiq {
    private static Map<String, List<Map<String, Object>>> zzdbk = new HashMap<String, List<Map<String, Object>>>();
    private static List<MediaCodecInfo> zzdbl;
    private static final Object zzdbm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static List<Map<String, Object>> zzck(String string2) {
        Object object = zzdbm;
        synchronized (object) {
            if (zzdbk.containsKey(string2)) {
                return zzdbk.get(string2);
            }
            try {
                Object object2 = zzdbm;
                synchronized (object2) {
                    if (zzdbl != null) {
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        zzdbl = Arrays.asList(new MediaCodecList(0).getCodecInfos());
                    } else if (Build.VERSION.SDK_INT >= 16) {
                        int n = MediaCodecList.getCodecCount();
                        zzdbl = new ArrayList<MediaCodecInfo>(n);
                        for (int i = 0; i < n; ++i) {
                            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                            zzdbl.add(mediaCodecInfo);
                        }
                    } else {
                        zzdbl = Collections.emptyList();
                    }
                }
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (MediaCodecInfo mediaCodecInfo : zzdbl) {
                    if (mediaCodecInfo.isEncoder() || !Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string2)) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("codecName", mediaCodecInfo.getName());
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string2);
                    ArrayList<Integer[]> arrayList2 = new ArrayList<Integer[]>();
                    for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecCapabilities.profileLevels) {
                        arrayList2.add(new Integer[]{codecProfileLevel.profile, codecProfileLevel.level});
                    }
                    hashMap.put("profileLevels", arrayList2);
                    if (Build.VERSION.SDK_INT >= 21) {
                        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                        hashMap.put("bitRatesBps", zzaiq.zza((Range<Integer>)videoCapabilities.getBitrateRange()));
                        hashMap.put("widthAlignment", videoCapabilities.getWidthAlignment());
                        hashMap.put("heightAlignment", videoCapabilities.getHeightAlignment());
                        hashMap.put("frameRates", zzaiq.zza((Range<Integer>)videoCapabilities.getSupportedFrameRates()));
                        hashMap.put("widths", zzaiq.zza((Range<Integer>)videoCapabilities.getSupportedWidths()));
                        hashMap.put("heights", zzaiq.zza((Range<Integer>)videoCapabilities.getSupportedHeights()));
                    }
                    if (Build.VERSION.SDK_INT >= 23) {
                        hashMap.put("instancesLimit", codecCapabilities.getMaxSupportedInstances());
                    }
                    arrayList.add(hashMap);
                }
                zzdbk.put(string2, arrayList);
                return arrayList;
            }
            catch (LinkageError | RuntimeException throwable) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("error", throwable.getClass().getSimpleName());
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                arrayList.add(hashMap);
                zzdbk.put(string2, arrayList);
                return arrayList;
            }
        }
    }

    @TargetApi(value=21)
    private static Integer[] zza(Range<Integer> range) {
        return new Integer[]{(Integer)range.getLower(), (Integer)range.getUpper()};
    }

    static {
        zzdbm = new Object();
    }
}

