/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzajp;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzzb;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzb
public class zzajy<T>
implements zzajp<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdcz;
    private boolean zzdda;
    private boolean zzcdm;
    private final zzajq zzddb = new zzajq();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzddb.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcdm) {
                return;
            }
            if (this.zzqx()) {
                zzbs.zzeg().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdda = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzddb.zzqw();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcdm) {
                return;
            }
            if (this.zzqx()) {
                zzbs.zzeg().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdcz = throwable;
            this.mLock.notifyAll();
            this.zzddb.zzqw();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzqx()) {
                this.mLock.wait();
            }
            if (this.zzdcz != null) {
                throw new ExecutionException(this.zzdcz);
            }
            if (this.zzcdm) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzqx()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdcz != null) {
                throw new ExecutionException(this.zzdcz);
            }
            if (!this.zzdda) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzcdm) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzqx()) {
                return false;
            }
            this.zzcdm = true;
            this.zzdda = true;
            this.mLock.notifyAll();
            this.zzddb.zzqw();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcdm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzqx();
        }
    }

    private final boolean zzqx() {
        return this.zzdcz != null || this.zzdda;
    }
}

