/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzakr;
import com.google.android.gms.internal.zzaks;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzalg;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzzb;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzb
@TargetApi(value=14)
public final class zzakk
extends zzaku
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzddi = new HashMap<Integer, String>();
    private final zzalj zzddj;
    private final boolean zzddk;
    private int zzddl = 0;
    private int zzddm = 0;
    private MediaPlayer zzddn;
    private Uri zzddo;
    private int zzddp;
    private int zzddq;
    private int zzddr;
    private int zzdds;
    private int zzddt;
    private zzalg zzddu;
    private boolean zzddv;
    private int zzddw;
    private zzakt zzddx;

    public zzakk(Context context, boolean bl, boolean bl2, zzalh zzalh2, zzalj zzalj2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzddj = zzalj2;
        this.zzddv = bl;
        this.zzddk = bl2;
        this.zzddj.zza(this);
    }

    @Override
    public final String zzqz() {
        String string2 = String.valueOf(this.zzddv ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzakt zzakt2) {
        this.zzddx = zzakt2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzakk zzakk2 = this;
        zzhu zzhu2 = zzhu.zzd(uri);
        zzakk2.zzddo = zzhu2 == null ? uri : Uri.parse((String)zzhu2.url);
        zzakk2.zzddw = 0;
        zzakk2.zzra();
        zzakk2.requestLayout();
        zzakk2.invalidate();
    }

    @Override
    public final void stop() {
        zzafj.v("AdMediaPlayerView stop");
        if (this.zzddn != null) {
            this.zzddn.stop();
            this.zzddn.release();
            this.zzddn = null;
            this.zzaf(0);
            this.zzddm = 0;
        }
        this.zzddj.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzafj.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzddp = mediaPlayer.getVideoWidth();
        this.zzddq = mediaPlayer.getVideoHeight();
        if (this.zzddp != 0 && this.zzddq != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzafj.v("AdMediaPlayerView prepared");
        this.zzaf(2);
        this.zzddj.zzrf();
        zzagr.zzczc.post((Runnable)new zzakl(this));
        this.zzddp = mediaPlayer.getVideoWidth();
        this.zzddq = mediaPlayer.getVideoHeight();
        if (this.zzddw != 0) {
            ((zzaku)this).seekTo(this.zzddw);
        }
        this.zzrb();
        int n = this.zzddp;
        int n2 = this.zzddq;
        zzafj.zzcn((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzddm == 3) {
            ((zzaku)this).play();
        }
        ((zzaku)this).zzrd();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzafj.v("AdMediaPlayerView completion");
        this.zzaf(5);
        this.zzddm = 5;
        zzagr.zzczc.post((Runnable)new zzakm(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzddi.get(n);
        String string3 = zzddi.get(n2);
        zzafj.v(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzddi.get(n);
        String string3 = zzddi.get(n2);
        zzafj.zzco((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzaf(-1);
        this.zzddm = -1;
        zzagr.zzczc.post((Runnable)new zzakn(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzddr = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzafj.v("AdMediaPlayerView surface created");
        this.zzra();
        zzagr.zzczc.post((Runnable)new zzako(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzafj.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzddm == 3;
        boolean bl3 = bl = this.zzddp == n && this.zzddq == n2;
        if (this.zzddn != null && bl2 && bl) {
            if (this.zzddw != 0) {
                ((zzaku)this).seekTo(this.zzddw);
            }
            ((zzaku)this).play();
        }
        if (this.zzddu != null) {
            this.zzddu.zzh(n, n2);
        }
        zzagr.zzczc.post((Runnable)new zzakp(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzafj.v("AdMediaPlayerView surface destroyed");
        if (this.zzddn != null && this.zzddw == 0) {
            this.zzddw = this.zzddn.getCurrentPosition();
        }
        if (this.zzddu != null) {
            this.zzddu.zzrs();
        }
        zzagr.zzczc.post((Runnable)new zzakq(this));
        this.zzaa(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzddj.zzb(this);
        this.zzded.zza(surfaceTexture, this.zzddx);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzakk.getDefaultSize((int)this.zzddp, (int)n);
        int n4 = zzakk.getDefaultSize((int)this.zzddq, (int)n2);
        if (this.zzddp > 0 && this.zzddq > 0 && this.zzddu == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzddp * n4 < n3 * this.zzddq) {
                    n3 = n4 * this.zzddp / this.zzddq;
                } else if (this.zzddp * n4 > n3 * this.zzddq) {
                    n4 = n3 * this.zzddq / this.zzddp;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzddq / this.zzddp;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzddp / this.zzddq;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzddp;
                n4 = this.zzddq;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzddp / this.zzddq;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzddq / this.zzddp;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzddu != null) {
            this.zzddu.zzh(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdds > 0 && this.zzdds != n3 || this.zzddt > 0 && this.zzddt != n4) {
                this.zzrb();
            }
            this.zzdds = n3;
            this.zzddt = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzra() {
        zzafj.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzddo == null || surfaceTexture == null) {
            return;
        }
        this.zzaa(false);
        try {
            Surface surface;
            zzbs.zzeu();
            this.zzddn = new MediaPlayer();
            this.zzddn.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzddn.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzddn.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzddn.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzddn.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzddn.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzddr = 0;
            if (this.zzddv) {
                this.zzddu = new zzalg(this.getContext());
                this.zzddu.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzddu.start();
                surface = this.zzddu.zzrt();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzddu.zzrs();
                    this.zzddu = null;
                }
            }
            this.zzddn.setDataSource(this.getContext(), this.zzddo);
            zzbs.zzev();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzddn.setSurface(surface);
            this.zzddn.setAudioStreamType(3);
            this.zzddn.setScreenOnWhilePlaying(true);
            this.zzddn.prepareAsync();
            this.zzaf(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzddo);
            zzafj.zzc((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzddn, 1, 0);
            return;
        }
    }

    private final void zzrb() {
        if (!this.zzddk) {
            return;
        }
        if (this.zzrc() && this.zzddn.getCurrentPosition() > 0 && this.zzddm != 3) {
            zzafj.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzddn.start();
            int n = this.zzddn.getCurrentPosition();
            long l = zzbs.zzei().currentTimeMillis();
            while (this.zzrc() && this.zzddn.getCurrentPosition() == n && zzbs.zzei().currentTimeMillis() - l <= 250L) {
            }
            this.zzddn.pause();
            ((zzaku)this).zzrd();
        }
    }

    private final void zzaa(boolean bl) {
        zzafj.v("AdMediaPlayerView release");
        if (this.zzddu != null) {
            this.zzddu.zzrs();
            this.zzddu = null;
        }
        if (this.zzddn != null) {
            this.zzddn.reset();
            this.zzddn.release();
            this.zzddn = null;
            this.zzaf(0);
            if (bl) {
                this.zzddm = 0;
                this.zzddm = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzafj.v("AdMediaPlayerView play");
        if (this.zzrc()) {
            this.zzddn.start();
            this.zzaf(3);
            this.zzded.zzrg();
            zzagr.zzczc.post((Runnable)new zzakr(this));
        }
        this.zzddm = 3;
    }

    @Override
    public final void pause() {
        zzafj.v("AdMediaPlayerView pause");
        if (this.zzrc() && this.zzddn.isPlaying()) {
            this.zzddn.pause();
            this.zzaf(4);
            zzagr.zzczc.post((Runnable)new zzaks(this));
        }
        this.zzddm = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzrc()) {
            return this.zzddn.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzrc()) {
            return this.zzddn.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzafj.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzrc()) {
            this.zzddn.seekTo(n);
            this.zzddw = 0;
            return;
        }
        this.zzddw = n;
    }

    private final boolean zzrc() {
        return this.zzddn != null && this.zzddl != -1 && this.zzddl != 0 && this.zzddl != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzddu != null) {
            this.zzddu.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzddn != null) {
            return this.zzddn.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzddn != null) {
            return this.zzddn.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzrd() {
        this.zza(this.zzdee.getVolume());
    }

    private final void zza(float f) {
        if (this.zzddn != null) {
            try {
                this.zzddn.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzafj.zzco((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzaf(int n) {
        if (n == 3) {
            this.zzddj.zzse();
            this.zzdee.zzse();
        } else if (this.zzddl == 3) {
            this.zzddj.zzsf();
            this.zzdee.zzsf();
        }
        this.zzddl = n;
    }

    static /* synthetic */ zzakt zza(zzakk zzakk2) {
        return zzakk2.zzddx;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzddi.put(-1004, "MEDIA_ERROR_IO");
            zzddi.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzddi.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzddi.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzddi.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzddi.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzddi.put(1, "MEDIA_ERROR_UNKNOWN");
        zzddi.put(1, "MEDIA_INFO_UNKNOWN");
        zzddi.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzddi.put(701, "MEDIA_INFO_BUFFERING_START");
        zzddi.put(702, "MEDIA_INFO_BUFFERING_END");
        zzddi.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzddi.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzddi.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzddi.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzddi.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

