/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzale;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzzb;

@zzzb
final class zzald
implements SensorEventListener {
    private final SensorManager zzdfd;
    private final Object zzdfe;
    private final Display zzdff;
    private final float[] zzdfg;
    private final float[] zzdfh;
    private float[] zzdfi;
    private Handler zzdfj;
    private zzalf zzdfk;

    zzald(Context context) {
        this.zzdfd = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzdff = windowManager.getDefaultDisplay();
        this.zzdfg = new float[9];
        this.zzdfh = new float[9];
        this.zzdfe = new Object();
    }

    final void start() {
        if (this.zzdfj != null) {
            return;
        }
        Sensor sensor = this.zzdfd.getDefaultSensor(11);
        if (sensor == null) {
            zzafj.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzdfj = new Handler(handlerThread.getLooper());
        if (!this.zzdfd.registerListener((SensorEventListener)this, sensor, 0, this.zzdfj)) {
            zzafj.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzdfj == null) {
            return;
        }
        this.zzdfd.unregisterListener((SensorEventListener)this);
        this.zzdfj.post((Runnable)new zzale(this));
        this.zzdfj = null;
    }

    final void zza(zzalf zzalf2) {
        this.zzdfk = zzalf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzald zzald2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzald2.zzdfe;
            synchronized (object) {
                if (zzald2.zzdfi == null) {
                    zzald2.zzdfi = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzald2.zzdfg, (float[])fArray);
            switch (zzald2.zzdff.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzald2.zzdfg, (int)2, (int)129, (float[])zzald2.zzdfh);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzald2.zzdfg, (int)129, (int)130, (float[])zzald2.zzdfh);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzald2.zzdfg, (int)130, (int)1, (float[])zzald2.zzdfh);
                    break;
                }
                default: {
                    System.arraycopy(zzald2.zzdfg, 0, zzald2.zzdfh, 0, 9);
                }
            }
            zzald2.zzg(1, 3);
            zzald2.zzg(2, 6);
            zzald2.zzg(5, 7);
            Object object2 = zzald2.zzdfe;
            synchronized (object2) {
                System.arraycopy(zzald2.zzdfh, 0, zzald2.zzdfi, 0, 9);
            }
            if (zzald2.zzdfk != null) {
                zzald2.zzdfk.zzms();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzdfe;
        synchronized (object) {
            if (this.zzdfi == null) {
                return false;
            }
            System.arraycopy(this.zzdfi, 0, fArray, 0, this.zzdfi.length);
            return true;
        }
    }

    private final void zzg(int n, int n2) {
        float f = this.zzdfh[n];
        this.zzdfh[n] = this.zzdfh[n2];
        this.zzdfh[n2] = f;
    }
}

