/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdos;
import com.google.android.gms.internal.zzdou;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdre;
import com.google.android.gms.internal.zzdrg;
import com.google.android.gms.internal.zzdri;
import com.google.android.gms.internal.zzdrk;
import com.google.android.gms.internal.zzdtc;
import com.google.android.gms.internal.zzdtd;
import com.google.android.gms.internal.zzdte;
import com.google.android.gms.internal.zzfdh;
import com.google.android.gms.internal.zzfew;
import com.google.android.gms.internal.zzffi;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

public final class zzdpn
implements zzdos<zzdou> {
    zzdpn() {
    }

    private final zzdou zzg(zzfdh zzfdh2) throws GeneralSecurityException {
        try {
            zzdtc zzdtc2;
            zzdre zzdre2;
            zzdre zzdre3;
            zzdre zzdre4 = zzdre3 = zzdre.zzw(zzfdh2);
            zzdre zzdre5 = zzdre3;
            if (!(zzdre3 instanceof zzdre)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdre zzdre6 = zzdre2 = zzdre5;
            zzdte.zzt(zzdre2.getVersion(), 0);
            if (zzdre6.zzblt().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdpn.zza(zzdre6.zzbni());
            zzdrc zzdrc2 = zzdre2.zzbni().zzbno();
            byte[] byArray = zzdre2.zzblt().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzdre2.zzbni().zzbnp();
            switch (zzdrc2) {
                case zzlsc: {
                    zzdtc2 = new zzdtc("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzlse: {
                    zzdtc2 = new zzdtc("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzlsf: {
                    zzdtc2 = new zzdtc("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdtc2;
        }
        catch (zzfew zzfew2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzfew2);
        }
    }

    @Override
    public final zzffi zzb(zzfdh zzfdh2) throws GeneralSecurityException {
        try {
            zzdrg zzdrg2 = zzdrg.zzy(zzfdh2);
            return this.zzb((zzffi)zzdrg2);
        }
        catch (zzfew zzfew2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzfew2);
        }
    }

    @Override
    public final zzffi zzb(zzffi zzffi2) throws GeneralSecurityException {
        zzdrg zzdrg2;
        if (!(zzffi2 instanceof zzdrg)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdrg zzdrg3 = zzdrg2 = (zzdrg)zzffi2;
        if (zzdrg2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdpn.zza(zzdrg3.zzbni());
        return zzdre.zzbnj().zzfq(0).zzc(zzdrg2.zzbni()).zzx(zzfdh.zzay((byte[])zzdtd.zzgb(zzdrg2.getKeySize()))).zzcvk();
    }

    @Override
    public final zzdrk zzc(zzfdh zzfdh2) throws GeneralSecurityException {
        zzdre zzdre2 = (zzdre)this.zzb(zzfdh2);
        return (zzdrk)zzdrk.zzbnv().zzoa("type.googleapis.com/google.crypto.tink.HmacKey").zzaa(zzdre2.toByteString()).zzb(zzdrk.zzb.zzlst).zzcvk();
    }

    @Override
    public final String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacKey";
    }

    private static void zza(zzdri zzdri2) throws GeneralSecurityException {
        if (zzdri2.zzbnp() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzdri2.zzbno()) {
            case zzlsc: {
                if (zzdri2.zzbnp() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlse: {
                if (zzdri2.zzbnp() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlsf: {
                if (zzdri2.zzbnp() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzffi zzffi2) throws GeneralSecurityException {
        zzdre zzdre2;
        zzffi zzffi3 = zzffi2;
        if (!(zzffi3 instanceof zzdre)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdre zzdre3 = zzdre2 = (zzdre)zzffi3;
        zzdte.zzt(zzdre2.getVersion(), 0);
        if (zzdre3.zzblt().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdpn.zza(zzdre3.zzbni());
        zzdrc zzdrc2 = zzdre2.zzbni().zzbno();
        byte[] byArray = zzdre2.zzblt().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzdre2.zzbni().zzbnp();
        switch (zzdrc2) {
            case zzlsc: {
                return new zzdtc("HMACSHA1", secretKeySpec, n);
            }
            case zzlse: {
                return new zzdtc("HMACSHA256", secretKeySpec, n);
            }
            case zzlsf: {
                return new zzdtc("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzfdh zzfdh2) throws GeneralSecurityException {
        return this.zzg(zzfdh2);
    }
}

