/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaeu;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzzb;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
public final class zzfc
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzaeu> zzauy;
    private WeakReference<ViewTreeObserver> zzauz;
    private final zzgm zzava;
    protected final zzfa zzavb;
    private final Context mApplicationContext;
    private final WindowManager zzavc;
    private final PowerManager zzavd;
    private final KeyguardManager zzave;
    private final DisplayMetrics zzavf;
    @Nullable
    private zzfj zzavg;
    private boolean zzavh;
    private boolean zzarc = false;
    private boolean zzavi = false;
    private boolean zzavj;
    private boolean zzavk;
    private boolean zzavl;
    @Nullable
    private BroadcastReceiver zzavm;
    private final HashSet<Object> zzavn = new HashSet();
    private zzail zzaui;
    private final HashSet<zzfx> zzavo = new HashSet();
    private final Rect zzavp = new Rect();
    private final zzff zzavq;
    private float zzavr;

    public zzfc(Context context, zziw zziw2, zzaeu zzaeu2, zzaiy zzaiy2, zzgm zzgm2) {
        this.zzauy = new WeakReference<zzaeu>(zzaeu2);
        this.zzava = zzgm2;
        this.zzauz = new WeakReference<Object>(null);
        this.zzavj = true;
        this.zzavl = false;
        this.zzaui = new zzail(200L);
        this.zzavb = new zzfa(UUID.randomUUID().toString(), zzaiy2, zziw2.zzbda, zzaeu2.zzcvq, zzaeu2.zzfr(), zziw2.zzbdd);
        this.zzavc = (WindowManager)context.getSystemService("window");
        this.zzavd = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzave = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzavq = new zzff(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzavq);
        this.zzavf = context.getResources().getDisplayMetrics();
        Display display = this.zzavc.getDefaultDisplay();
        this.zzavp.right = display.getWidth();
        this.zzavp.bottom = display.getHeight();
        this.zzft();
    }

    public final void zzft() {
        zzbs.zzec();
        this.zzavr = zzagr.zzap(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfu() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzavj) {
                this.zzavk = true;
                try {
                    JSONObject jSONObject = this.zzfy();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafj.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafj.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzavb.zzfq());
                zzafj.zzbw((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzl(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzfx> iterator = this.zzavo.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzgc()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzavj) {
                return;
            }
            View view = this.zzava.zzfz();
            boolean bl3 = view != null && zzbs.zzec().zza(view, this.zzavd, this.zzave);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzava.zzga()) {
                this.zzfu();
                return;
            }
            if (n == 1 && !this.zzaui.tryAcquire() && bl == this.zzavl) {
                return;
            }
            if (!bl && !this.zzavl && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzavl = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafj.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfc zzfc2 = this;
            View view2 = zzfc2.zzava.zzgb().zzfz();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfc2.zzauz.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfc2.zzfx();
                    if (!zzfc2.zzavh || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfc2.zzavh = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfc2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfc2);
                    }
                    zzfc2.zzauz = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzfv();
            return;
        }
    }

    private final void zzfv() {
        if (this.zzavg != null) {
            this.zzavg.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzfw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzavj;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzd(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzavb.zzfq());
    }

    final void zze(Map<String, String> map) {
        this.zzl(3);
    }

    final void zza(zzfx zzfx2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzavb.zzfq());
        zzafj.zzbw((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzfx2);
    }

    final void zzf(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzavn.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzfx() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzauz.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzfy() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzavb.zzfo()).put("activeViewJSON", (Object)this.zzavb.zzfp()).put("timestamp", zzbs.zzei().elapsedRealtime()).put("adFormat", (Object)this.zzavb.zzfn()).put("hashCode", (Object)this.zzavb.zzfq()).put("isMraid", this.zzavb.zzfr()).put("isStopped", this.zzavi).put("isPaused", this.zzarc).put("isNative", this.zzavb.zzfs()).put("isScreenOn", this.isScreenOn());
        zzbs.zzec();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzagr.zzdi());
        zzbs.zzec();
        jSONObject3.put("appVolume", (double)zzagr.zzdh()).put("deviceVolume", (double)this.zzavr);
        return jSONObject;
    }

    private static JSONObject zzb(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfc.zzb(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfc zzfc2 = this;
            ArrayList<zzfx> arrayList = new ArrayList<zzfx>(zzfc2.zzavo);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzfx zzfx2 = arrayList.get(i);
                zzfx2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafj.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfx zzfx2) {
        if (this.zzavo.isEmpty()) {
            zzfc zzfc2 = this;
            Object object = zzfc2.mLock;
            synchronized (object) {
                if (zzfc2.zzavm != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfc2.zzavm = new zzfd(zzfc2);
                    zzfc2.mApplicationContext.registerReceiver(zzfc2.zzavm, intentFilter);
                }
            }
            this.zzl(3);
        }
        this.zzavo.add(zzfx2);
        try {
            JSONObject jSONObject = zzfc.zzb(this.zza(this.zzava.zzfz(), null));
            zzfx2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafj.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzfx zzfx2) {
        this.zzavo.remove(zzfx2);
        zzfx2.zzgd();
        if (this.zzavo.isEmpty()) {
            zzfc zzfc2 = this;
            Object object = zzfc2.mLock;
            synchronized (object) {
                zzfc2.zzfx();
                zzfc zzfc3 = zzfc2;
                Object object2 = zzfc3.mLock;
                synchronized (object2) {
                    if (zzfc3.zzavm != null) {
                        try {
                            zzfc3.mApplicationContext.unregisterReceiver(zzfc3.zzavm);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafj.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbs.zzeg().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfc3.zzavm = null;
                    }
                }
                zzfc2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfc2.zzavq);
                zzfc2.zzavj = false;
                zzfc2.zzfv();
                zzfc3 = zzfc2;
                ArrayList<zzfx> arrayList = new ArrayList<zzfx>(zzfc3.zzavo);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzfx zzfx3 = arrayList.get(i);
                    zzfx zzfx4 = zzfx3;
                    zzfc3.zzb(zzfx4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfc zzfc2 = this;
            return zzfc2.zzfy().put("isAttachedToWindow", false).put("isScreenOn", zzfc2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbs.zzee().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzfy();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfc.zza(this.zzavp.top, this.zzavf)).put("bottom", zzfc.zza(this.zzavp.bottom, this.zzavf)).put("left", zzfc.zza(this.zzavp.left, this.zzavf)).put("right", zzfc.zza(this.zzavp.right, this.zzavf))).put("adBox", (Object)new JSONObject().put("top", zzfc.zza(rect.top, this.zzavf)).put("bottom", zzfc.zza(rect.bottom, this.zzavf)).put("left", zzfc.zza(rect.left, this.zzavf)).put("right", zzfc.zza(rect.right, this.zzavf))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfc.zza(rect2.top, this.zzavf)).put("bottom", zzfc.zza(rect2.bottom, this.zzavf)).put("left", zzfc.zza(rect2.left, this.zzavf)).put("right", zzfc.zza(rect2.right, this.zzavf))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfc.zza(rect3.top, this.zzavf)).put("bottom", zzfc.zza(rect3.bottom, this.zzavf)).put("left", zzfc.zza(rect3.left, this.zzavf)).put("right", zzfc.zza(rect3.right, this.zzavf))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfc.zza(rect4.top, this.zzavf)).put("bottom", zzfc.zza(rect4.bottom, this.zzavf)).put("left", zzfc.zza(rect4.left, this.zzavf)).put("right", zzfc.zza(rect4.right, this.zzavf))).put("screenDensity", (double)this.zzavf.density);
        if (bl == null) {
            bl = zzbs.zzec().zza(view, this.zzavd, this.zzave);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzavd.isInteractive();
        }
        return this.zzavd.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzl(1);
    }

    public final void onGlobalLayout() {
        this.zzl(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfj zzfj2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavg = zzfj2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavi = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarc = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarc = false;
            this.zzl(3);
            return;
        }
    }
}

