/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzsm;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzso;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.internal.zzsr;
import com.google.android.gms.internal.zzzb;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzzb
public final class zzsl {
    private final Map<zzsm, zzsn> zzbxw = new HashMap<zzsm, zzsn>();
    private final LinkedList<zzsm> zzbxx = new LinkedList();
    @Nullable
    private zzri zzbxy;

    final void zza(zzri zzri2) {
        if (this.zzbxy == null) {
            this.zzbxy = zzri2.zzko();
            zzsl zzsl2 = this;
            if (zzsl2.zzbxy != null) {
                SharedPreferences sharedPreferences = zzsl2.zzbxy.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zzsl zzsl3 = zzsl2;
                while (zzsl3.zzbxx.size() > 0) {
                    zzsm zzsm2 = zzsl3.zzbxx.remove();
                    zzsn zzsn2 = zzsl3.zzbxw.get(zzsm2);
                    zzsl.zza("Flushing interstitial queue for %s.", zzsm2);
                    while (zzsn2.size() > 0) {
                        zzsn2.zzm(null).zzbyd.zzde();
                    }
                    zzsl3.zzbxw.remove(zzsm2);
                }
                try {
                    zzsm zzsm2;
                    HashMap<String, zzsm> hashMap = new HashMap<String, zzsm>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzsr zzsr2 = zzsr.zzaz((String)stringArray.getValue());
                        zzsm2 = new zzsm(zzsr2.zzara, zzsr2.zzaou, zzsr2.zzbyb);
                        if (zzsl2.zzbxw.containsKey(zzsm2)) continue;
                        zzsn zzsn2 = new zzsn(zzsr2.zzara, zzsr2.zzaou, zzsr2.zzbyb);
                        zzsl2.zzbxw.put(zzsm2, zzsn2);
                        hashMap.put(zzsm2.toString(), zzsm2);
                        zzsl.zza("Restored interstitial queue for %s.", zzsm2);
                    }
                    for (String string2 : zzsl.zzaw(sharedPreferences.getString("PoolKeys", ""))) {
                        zzsm2 = (zzsm)hashMap.get(string2);
                        if (!zzsl2.zzbxw.containsKey(zzsm2)) continue;
                        zzsl2.zzbxx.add(zzsm2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbs.zzeg().zza(exception, "InterstitialAdPool.restore");
                    zzafj.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zzsl2.zzbxw.clear();
                    zzsl2.zzbxx.clear();
                }
            }
        }
    }

    @Nullable
    final zzso zza(zzis zzis2, String string2) {
        Object object;
        Object object2;
        zzmg<Integer> zzmg2;
        String string3;
        if (zzsl.zzax(string2)) {
            return null;
        }
        Context context = this.zzbxy.getApplicationContext();
        int n = new zzabv((Context)context).zzns().zzcsg;
        zzis zzis3 = zzsl.zzk(zzis2);
        zzsm zzsm2 = new zzsm(zzis3, string3 = zzsl.zzay(string2), n);
        zzsn zzsn2 = this.zzbxw.get(zzsm2);
        if (zzsn2 == null) {
            zzsl.zza("Interstitial pool created at %s.", zzsm2);
            zzsn2 = new zzsn(zzis3, string3, n);
            this.zzbxw.put(zzsm2, zzsn2);
        }
        this.zzbxx.remove(zzsm2);
        this.zzbxx.add(zzsm2);
        zzsn2.zzku();
        while (true) {
            zzmg2 = zzmq.zzbkk;
            if (this.zzbxx.size() <= zzbs.zzep().zzd(zzmg2)) break;
            object2 = this.zzbxx.remove();
            object = this.zzbxw.get(object2);
            zzsl.zza("Evicting interstitial queue for %s.", (zzsm)object2);
            while (((zzsn)object).size() > 0) {
                zzso zzso2 = ((zzsn)object).zzm(null);
                if (zzso2.zzbyh) {
                    zzsp.zzkw().zzky();
                }
                zzso2.zzbyd.zzde();
            }
            this.zzbxw.remove(object2);
        }
        while (zzsn2.size() > 0) {
            object2 = zzsn2.zzm(zzis3);
            if (((zzso)object2).zzbyh) {
                zzmg2 = zzmq.zzbkm;
                if (zzbs.zzei().currentTimeMillis() - ((zzso)object2).zzbyg > 1000L * (long)zzbs.zzep().zzd(zzmg2).intValue()) {
                    zzsl.zza("Expired interstitial at %s.", zzsm2);
                    zzsp.zzkw().zzkx();
                    continue;
                }
            }
            object = ((zzso)object2).zzbye != null ? " (inline) " : " ";
            zzsl.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zzsm2);
            return object2;
        }
        return null;
    }

    final void zzb(zzis zzis2, String string2) {
        String string3;
        if (this.zzbxy == null) {
            return;
        }
        Context context = this.zzbxy.getApplicationContext();
        int n = new zzabv((Context)context).zzns().zzcsg;
        zzis zzis3 = zzsl.zzk(zzis2);
        zzsm zzsm2 = new zzsm(zzis3, string3 = zzsl.zzay(string2), n);
        zzsn zzsn2 = this.zzbxw.get(zzsm2);
        if (zzsn2 == null) {
            zzsl.zza("Interstitial pool created at %s.", zzsm2);
            zzsn2 = new zzsn(zzis3, string3, n);
            this.zzbxw.put(zzsm2, zzsn2);
        }
        zzsn2.zza(this.zzbxy, zzis2);
        zzsn2.zzku();
        zzsl.zza("Inline entry added to the queue at %s.", zzsm2);
    }

    final void zzkp() {
        Object object;
        if (this.zzbxy == null) {
            return;
        }
        for (Map.Entry<zzsm, zzsn> entry : this.zzbxw.entrySet()) {
            int n;
            zzsm zzsm2 = entry.getKey();
            zzsn zzsn2 = entry.getValue();
            if (zzafj.zzae((int)2)) {
                n = zzsn2.size();
                int n2 = zzsn2.zzks();
                if (n2 < n) {
                    zzafj.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzsm2));
                }
            }
            n = 0 + zzsn2.zzkt();
            while (true) {
                object = zzmq.zzbkl;
                if (zzsn2.size() >= (Integer)zzbs.zzep().zzd(object)) break;
                zzsl.zza("Pooling and loading one new interstitial for %s.", zzsm2);
                if (!zzsn2.zzb(this.zzbxy)) continue;
                ++n;
            }
            zzsp.zzkw().zzu(n);
        }
        object = this;
        if (((zzsl)object).zzbxy != null) {
            SharedPreferences.Editor editor = ((zzsl)object).zzbxy.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zzsm, zzsn> entry : ((zzsl)object).zzbxw.entrySet()) {
                zzsm zzsm3 = entry.getKey();
                zzsn zzsn3 = entry.getValue();
                if (!zzsn3.zzkv()) continue;
                String string2 = new zzsr(zzsn3).zzlf();
                String string3 = zzsm3.toString();
                editor.putString(string3, string2);
                zzsl.zza("Saved interstitial queue for %s.", zzsm3);
            }
            editor.putString("PoolKeys", super.zzkq());
            editor.apply();
        }
    }

    private final String zzkq() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbxx.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzsm)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzaw(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzax(String string2) {
        try {
            zzmg<String> zzmg2 = zzmq.zzbkn;
            return Pattern.matches(zzbs.zzep().zzd(zzmg2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbs.zzeg().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzi(zzis zzis2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzis2.extras.keySet());
        Bundle bundle = zzis2.zzbcf.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzis zzj(zzis zzis2) {
        zzis zzis3 = zzsl.zzl(zzis2);
        String string2 = "_skipMediation";
        zzis zzis4 = zzis3;
        Bundle bundle = zzis3.zzbcf.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzis4.extras.putBoolean(string2, true);
        return zzis3;
    }

    private static zzis zzk(zzis zzis2) {
        zzis zzis3 = zzsl.zzl(zzis2);
        zzmg<String> zzmg2 = zzmq.zzbkj;
        for (String string2 : zzbs.zzep().zzd(zzmg2).split(",")) {
            zzsl.zzc(zzis3.zzbcf, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zzsl.zzc(zzis3.extras, string4);
        }
        return zzis3;
    }

    private static String zzay(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzis zzl(zzis zzis2) {
        Parcel parcel = Parcel.obtain();
        zzis2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzis zzis3 = (zzis)zzis.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzmg<Boolean> zzmg2 = zzmq.zzbjy;
        if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
            zzis.zzh((zzis)zzis3);
        }
        return zzis3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zzsm zzsm2) {
        if (zzafj.zzae((int)2)) {
            zzafj.v(String.format(string2, zzsm2));
        }
    }
}

