/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzwa;
import com.google.android.gms.internal.zzwb;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzzb;
import java.util.Map;

@zzzb
public final class zzvz
extends zzwg {
    private final Map<String, String> zzbqw;
    private final Context mContext;

    public zzvz(zzama zzama2, Map<String, String> map) {
        super(zzama2, "storePicture");
        this.zzbqw = map;
        this.mContext = zzama2.zzrz();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbl("Activity context is not available");
            return;
        }
        zzbs.zzec();
        if (!zzagr.zzak(this.mContext).zzin()) {
            this.zzbl("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbqw.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbl("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbl(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbs.zzec();
        if (!zzagr.zzce(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbl(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbs.zzeg().getResources();
        zzbs.zzec();
        AlertDialog.Builder builder = zzagr.zzaj(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwa(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwb(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzvz zzvz2) {
        return zzvz2.mContext;
    }
}

