/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.gmsg;

import android.content.Context;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzajv;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzzv;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
@Keep
@KeepName
public class HttpClient
implements zzt<com.google.android.gms.ads.internal.js.zza> {
    private final Context mContext;
    private final zzakd zzapr;

    public HttpClient(Context context, zzakd zzakd2) {
        this.mContext = context;
        this.zzapr = zzakd2;
    }

    private static zzb zzd(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzagf.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzkn());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzks()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzagf.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzc zza(zzb zzb2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            httpURLConnection = (HttpURLConnection)zzb2.zzko().openConnection();
            zzbs.zzei().zza(this.mContext, this.zzapr.zzcv, false, httpURLConnection);
            ArrayList<zza> arrayList = zzb2.zzkp();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zza zza2 = arrayList.get(i);
                object2 = zza2;
                httpURLConnection.addRequestProperty(((zza)object2).getKey(), ((zza)object2).getValue());
            }
            byte[] byArray = null;
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzkq())) {
                httpURLConnection.setDoOutput(true);
                byArray = zzb2.zzkq().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                object2 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object2).write(byArray);
                ((FilterOutputStream)object2).close();
            }
            object2 = new zzajv();
            object2.zza(httpURLConnection, byArray);
            ArrayList<zza> arrayList2 = new ArrayList<zza>();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> object3 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : object3.getValue()) {
                        arrayList2.add(new zza(object3.getKey(), string2));
                    }
                }
            }
            String string3 = zzb2.zzkn();
            int n2 = httpURLConnection.getResponseCode();
            zzbs.zzei();
            zzd zzd2 = new zzd(string3, n2, arrayList2, zzahn.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            object2.zza(httpURLConnection, zzd2.getResponseCode());
            object2.zzcr(zzd2.getBody());
            zzc zzc2 = new zzc(this, true, zzd2, null);
            return zzc2;
        }
        catch (Exception exception) {
            zzc zzc2 = new zzc(this, false, null, exception.toString());
            return zzc2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Keep
    @KeepName
    public JSONObject send(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = new JSONObject();
        String string2 = "";
        try {
            string2 = jSONObject2.optString("http_request_id");
            zzb zzb2 = HttpClient.zzd(jSONObject2);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject4 = HttpClient.zza(zzc2.zzkr());
                jSONObject3.put("response", (Object)jSONObject4);
                jSONObject3.put("success", true);
            } else {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Error executing http request.", (Throwable)exception);
            try {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                zzagf.zzb((String)"Error executing http request.", (Throwable)jSONException);
            }
        }
        return jSONObject3;
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Map map2 = map;
        com.google.android.gms.ads.internal.js.zza zza2 = (com.google.android.gms.ads.internal.js.zza)object;
        HttpClient httpClient = this;
        zzahh.zza(new zzu(httpClient, map2, zza2));
    }

    @zzzv
    final class zzc {
        private final zzd zzbxy;
        private final boolean zzbxz;
        private final String zzbya;

        public zzc(HttpClient httpClient, boolean bl, zzd zzd2, String string2) {
            this.zzbxz = bl;
            this.zzbxy = zzd2;
            this.zzbya = string2;
        }

        public final String getReason() {
            return this.zzbya;
        }

        public final zzd zzkr() {
            return this.zzbxy;
        }

        public final boolean isSuccess() {
            return this.zzbxz;
        }
    }

    @zzzv
    static final class zzd {
        private final String zzbxu;
        private final int zzbyb;
        private final List<zza> zzce;
        private final String zzbtu;

        zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbxu = string2;
            this.zzbyb = n;
            this.zzce = list;
            this.zzbtu = string3;
        }

        public final String zzkn() {
            return this.zzbxu;
        }

        public final int getResponseCode() {
            return this.zzbyb;
        }

        public final Iterable<zza> zzks() {
            return this.zzce;
        }

        public final String getBody() {
            return this.zzbtu;
        }
    }

    @zzzv
    static final class zzb {
        private final String zzbxu;
        private final URL zzbxv;
        private final ArrayList<zza> zzbxw;
        private final String zzbxx;

        zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbxu = string2;
            this.zzbxv = uRL;
            this.zzbxw = arrayList;
            this.zzbxx = string3;
        }

        public final String zzkn() {
            return this.zzbxu;
        }

        public final URL zzko() {
            return this.zzbxv;
        }

        public final ArrayList<zza> zzkp() {
            return this.zzbxw;
        }

        public final String zzkq() {
            return this.zzbxx;
        }
    }

    @zzzv
    static final class zza {
        private final String zzbhb;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzbhb = string2;
            this.mValue = string3;
        }

        public final String getKey() {
            return this.zzbhb;
        }

        public final String getValue() {
            return this.mValue;
        }
    }
}

