/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaco;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzoe;
import java.util.Locale;

public final class zzacp {
    private int zzctl;
    private boolean zzcts;
    private boolean zzctt;
    private int zzctx;
    private int zzcub;
    private int zzcuc;
    private String zzcto;
    private int zzcty;
    private int zzctz;
    private int zzcua;
    private boolean zzcuf;
    private int zzcug;
    private double zzcud;
    private boolean zzcue;
    private String zzcuh;
    private String zzcui;
    private boolean zzctm;
    private boolean zzctn;
    private String zzctp;
    private boolean zzctq;
    private boolean zzctr;
    private String zzctu;
    private String zzctv;
    private float zzaxx;
    private int zzcnm;
    private int zzcnn;
    private String zzctw;
    private boolean zzcuj;

    public zzacp(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Locale locale = Locale.getDefault();
        this.zzctm = zzacp.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzctn = zzacp.zza(packageManager, "http://www.google.com") != null;
        this.zzctp = locale.getCountry();
        zzkb.zzia();
        this.zzctq = zzajr.zzqy();
        this.zzctr = zzi.zzcu((Context)context);
        this.zzctu = locale.getLanguage();
        this.zzctv = zzacp.zzb(context, packageManager);
        this.zzctw = zzacp.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzaxx = displayMetrics.density;
        this.zzcnm = displayMetrics.widthPixels;
        this.zzcnn = displayMetrics.heightPixels;
    }

    public zzacp(Context context, zzaco zzaco2) {
        context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Context context2 = context;
        zzacp zzacp2 = this;
        this.zzcuh = Build.FINGERPRINT;
        zzacp2.zzcui = Build.DEVICE;
        zzacp2.zzcuj = zzq.zzamh() && zzoe.zzh(context2);
        this.zzctm = zzaco2.zzctm;
        this.zzctn = zzaco2.zzctn;
        this.zzctp = zzaco2.zzctp;
        this.zzctq = zzaco2.zzctq;
        this.zzctr = zzaco2.zzctr;
        this.zzctu = zzaco2.zzctu;
        this.zzctv = zzaco2.zzctv;
        this.zzctw = zzaco2.zzctw;
        this.zzaxx = zzaco2.zzaxx;
        this.zzcnm = zzaco2.zzcnm;
        this.zzcnn = zzaco2.zzcnn;
    }

    private final void zzl(Context context) {
        zzbs.zzei();
        AudioManager audioManager = zzahn.zzap(context);
        if (audioManager != null) {
            try {
                this.zzctl = audioManager.getMode();
                this.zzcts = audioManager.isMusicActive();
                this.zzctt = audioManager.isSpeakerphoneOn();
                this.zzctx = audioManager.getStreamVolume(3);
                this.zzcub = audioManager.getRingerMode();
                this.zzcuc = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbs.zzem().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzctl = -2;
        this.zzcts = false;
        this.zzctt = false;
        this.zzctx = 0;
        this.zzcub = 0;
        this.zzcuc = 0;
    }

    @TargetApi(value=16)
    private final void zzm(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcto = telephonyManager.getNetworkOperator();
        this.zzctz = telephonyManager.getNetworkType();
        this.zzcua = telephonyManager.getPhoneType();
        this.zzcty = -2;
        this.zzcuf = false;
        this.zzcug = -1;
        zzbs.zzei();
        if (zzahn.zzd(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcty = networkInfo.getType();
                this.zzcug = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcty = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcuf = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzn(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcud = (float)n2 / (float)n3;
            this.zzcue = n == 2 || n == 5;
            return;
        }
        this.zzcud = -1.0;
        this.zzcue = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbhf.zzdb((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzacp.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbhf.zzdb((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbs.zzem().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaco zzny() {
        return new zzaco(this.zzctl, this.zzctm, this.zzctn, this.zzcto, this.zzctp, this.zzctq, this.zzctr, this.zzcts, this.zzctt, this.zzctu, this.zzctv, this.zzctw, this.zzctx, this.zzcty, this.zzctz, this.zzcua, this.zzcub, this.zzcuc, this.zzaxx, this.zzcnm, this.zzcnn, this.zzcud, this.zzcue, this.zzcuf, this.zzcug, this.zzcuh, this.zzcuj, this.zzcui);
    }
}

