/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzagg;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahp;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzftr;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzzv;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
public final class zzahn {
    public static final Handler zzdaw = new zzagg(Looper.getMainLooper());
    private final Object mLock = new Object();
    private boolean zzdax = true;
    private String zzczb;
    private boolean zzday = false;
    private boolean zzdaz = false;
    private Pattern zzdba;
    private Pattern zzdbb;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzahn zzahn2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzahn2.zzp(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzag(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzagf.zzcu((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzagf.zzcu((String)String.format(string2, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzagf.zzcu((String)String.format(string2, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzagf.zzcu((String)String.format(string2, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzagf.zzcu((String)String.format(string2, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzagf.zzcu((String)String.format(string2, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzagf.zzcu((String)String.format(string2, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzagf.zzcu((String)String.format(string2, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public static boolean zzd(Context context, String string2, String string3) {
        return zzbhf.zzdb((Context)context).checkPermission(string3, string2) == 0;
    }

    public static void zza(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new zzajh(context, string2, string3).zznd();
        }
    }

    public static void zze(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        zzahn.zza(context, string2, arrayList);
    }

    public final void zza(Context context, List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzftr.zzff((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzagf.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzoe.zzh(context)) {
            zzagf.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        zzoe zzoe2 = new zzoe();
        zzaho zzaho2 = new zzaho(this, list, zzoe2, context);
        zzoe2.zza(zzaho2);
        zzoe2.zzd((Activity)context);
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzah(Context context) {
        if (this.zzday) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzahs(this, null), intentFilter);
        this.zzday = true;
        return true;
    }

    public final boolean zzai(Context context) {
        if (this.zzdaz) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzahr(this, null), intentFilter);
        this.zzdaz = true;
        return true;
    }

    private static String zzqa() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzp(Context context, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzczb != null) {
                return this.zzczb;
            }
            if (string2 == null) {
                return zzahn.zzqa();
            }
            try {
                this.zzczb = zzbs.zzek().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzczb)) {
                zzkb.zzia();
                if (!zzajr.zzqz()) {
                    this.zzczb = null;
                    zzdaw.post((Runnable)new zzahp(this, context));
                    while (this.zzczb == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzczb = zzahn.zzqa();
                            String string3 = String.valueOf(this.zzczb);
                            zzagf.zzcu((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzczb = zzahn.zzaj(context);
                }
            }
            String string4 = String.valueOf(this.zzczb);
            this.zzczb = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (zzbhf.zzdb((Context)context).zzamu()) {
                    this.zzczb = String.valueOf(this.zzczb).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzbs.zzem().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzczb = String.valueOf(this.zzczb).concat(")");
            return this.zzczb;
        }
    }

    protected static String zzaj(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzahn.zzqa();
        }
    }

    public static boolean zza(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String zzcd(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public final JSONObject zzq(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zzc(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzagf.zzb((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    private final JSONObject zzc(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzq(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzahn zzahn2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzahn2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzc((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzq(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static Map<String, String> zzf(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : zzbs.zzek().zzg(uri)) {
            hashMap.put(string2, uri.getQueryParameter(string2));
        }
        return hashMap;
    }

    public static String zzqb() {
        return UUID.randomUUID().toString();
    }

    public static int zzce(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzagf.zzcu((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzqc() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzqd() {
        return new int[]{0, 0};
    }

    public static int[] zzf(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzahn.zzqd();
    }

    public final int[] zzg(Activity activity) {
        int[] nArray = zzahn.zzf(activity);
        int[] nArray2 = new int[2];
        zzkb.zzia();
        nArray2[0] = zzajr.zzd((Context)activity, (int)nArray[0]);
        zzkb.zzia();
        nArray2[1] = zzajr.zzd((Context)activity, (int)nArray[1]);
        return nArray2;
    }

    public final int[] zzh(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzahn.zzqd();
        }
        int[] nArray3 = nArray;
        int[] nArray4 = new int[2];
        zzkb.zzia();
        nArray4[0] = zzajr.zzd((Context)activity, (int)nArray3[0]);
        zzkb.zzia();
        nArray4[1] = zzajr.zzd((Context)activity, (int)nArray3[1]);
        return nArray4;
    }

    public static boolean zzcf(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public static void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzak(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzmt zzal(Context context) {
        return new zzmt(context);
    }

    public static Bitmap zzr(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    private static String zzam(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String zza(Context context, View view, zzjn zzjn2) {
        zzmx zzmx2 = zznh.zzbkm;
        if (!((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", zzjn2.width);
            jSONObject2.put("height", zzjn2.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)zzahn.zzam(context));
            if (!zzjn2.zzbel) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzagf.zzc((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public static String zza(Context context, zzcv zzcv2, String string2, View view, Activity activity) {
        if (zzcv2 == null) {
            return string2;
        }
        try {
            Uri uri = Uri.parse((String)string2);
            if (zzcv2.zzc(uri)) {
                uri = zzcv2.zza(uri, context, view, activity);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static boolean zzan(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        if (bl) {
            zzbs.zzei();
            bundle.putString("device", zzahn.zzqc());
            bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zznh.zziw()));
        }
        zzkb.zzia();
        zzajr.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)bl, (zzaju)new zzahq(this, context, string2));
    }

    public final void zzb(Context context, String string2, String string3, Bundle bundle, boolean bl) {
        zzmx zzmx2 = zznh.zzbmt;
        if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            this.zza(context, string2, string3, bundle, bl);
        }
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzdaw.post(runnable);
    }

    public static void zzb(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzahh.zza(runnable);
    }

    public static Bitmap zzs(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzahn.zzu(view);
        if (bitmap == null) {
            bitmap = zzahn.zzt(view);
        }
        return bitmap;
    }

    private static Bitmap zzt(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzagf.zzcu((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzagf.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzu(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzagf.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static Bitmap zzao(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            zzmx zzmx2 = zznh.zzbod;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    bitmap = zzahn.zzu(window.getDecorView().getRootView());
                }
            } else {
                bitmap = zzahn.zzt(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzagf.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static float zzdn() {
        return zzbs.zzff().zzdn();
    }

    public static boolean zzdo() {
        return zzbs.zzff().zzdo();
    }

    public static AudioManager zzap(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public static float zzaq(Context context) {
        AudioManager audioManager = zzahn.zzap(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        if (n == 0) {
            return 0.0f;
        }
        return (float)n2 / (float)n;
    }

    public static int zzar(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzahn.zzas(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzas(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean zza(View var1_1, PowerManager var2_2, KeyguardManager var3_3) {
        if (zzbs.zzei().zzdax || !((var5_4 = var3_3) == null ? false : var5_4.inKeyguardRestrictedInputMode())) ** GOTO lbl-1000
        var5_4 = zznh.zzbmq;
        if (((Boolean)zzkb.zzif().zzd((zzmx)var5_4)).booleanValue() && zzahn.zzv(var1_1)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = var4_5 = false;
        }
        if (var1_1.getVisibility() == 0 && var1_1.isShown() && ((var5_4 = var2_2) == null || var5_4.isScreenOn() != false) && var4_5) {
            var5_4 = zznh.zzbmo;
            if (!((Boolean)zzkb.zzif().zzd((zzmx)var5_4)).booleanValue() || var1_1.getLocalVisibleRect(new Rect()) || var1_1.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzv(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzat(Context context) {
        if (context == null || !zzq.zzami()) {
            return false;
        }
        KeyguardManager keyguardManager = zzahn.zzas(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzw(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzau(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzagf.zzb((String)"Error loading class.", (Throwable)throwable);
            zzbs.zzem().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    public static Bundle zzqe() {
        Bundle bundle = new Bundle();
        try {
            Object object;
            zzmx zzmx2 = zznh.zzbit;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                object = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)object);
                bundle.putParcelable("debug_memory_info", (Parcelable)object);
            }
            zzmx2 = zznh.zzbiu;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                object = Runtime.getRuntime();
                bundle.putLong("runtime_free_memory", ((Runtime)object).freeMemory());
                bundle.putLong("runtime_max_memory", ((Runtime)object).maxMemory());
                bundle.putLong("runtime_total_memory", ((Runtime)object).totalMemory());
            }
            bundle.putInt("web_view_count", zzbs.zzem().zzpv());
        }
        catch (Exception exception) {
            zzagf.zzc((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    public static Uri zzb(String string2, String string3, String string4) throws UnsupportedOperationException {
        int n = string2.indexOf("&adurl");
        if (n == -1) {
            n = string2.indexOf("?adurl");
        }
        if (n != -1) {
            return Uri.parse((String)(string2.substring(0, n + 1) + string3 + "=" + string4 + "&" + string2.substring(n + 1)));
        }
        return Uri.parse((String)string2).buildUpon().appendQueryParameter(string3, string4).build();
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzmx zzmx2 = zznh.zzbqr;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                zzahn.zzb(context, intent);
            }
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzagf.zzbx((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzagf.zzb((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (zzq.zzamk()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzf(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzq(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(zzn.zza((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzagf.zzbx((String)"Error reading from internal storage.");
            return "";
        }
    }

    @TargetApi(value=24)
    public static boolean zza(Activity activity, Configuration configuration) {
        zzkb.zzia();
        int n = zzajr.zzc((Context)activity, (int)configuration.screenHeightDp);
        int n2 = zzajr.zzc((Context)activity, (int)configuration.screenWidthDp);
        DisplayMetrics displayMetrics = zzahn.zza((WindowManager)activity.getApplicationContext().getSystemService("window"));
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        int n5 = 0;
        int n6 = activity.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n6 > 0) {
            n5 = activity.getResources().getDimensionPixelSize(n6);
        }
        zzmx zzmx2 = zznh.zzbrb;
        int n7 = (int)Math.round((double)activity.getResources().getDisplayMetrics().density + 0.5) * (Integer)zzkb.zzif().zzd(zzmx2);
        return zzahn.zzb(n3, n + n5, n7) && zzahn.zzb(n4, n2, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcg(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzahn zzahn2 = this;
            synchronized (zzahn2) {
                block10: {
                    zzmx zzmx2;
                    block9: {
                        if (this.zzdba == null) break block9;
                        zzmx2 = zznh.zzbks;
                        if (((String)zzkb.zzif().zzd(zzmx2)).equals(this.zzdba.pattern())) break block10;
                    }
                    zzmx2 = zznh.zzbks;
                    this.zzdba = Pattern.compile((String)zzkb.zzif().zzd(zzmx2));
                }
                return this.zzdba.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzch(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            zzahn zzahn2 = this;
            synchronized (zzahn2) {
                block10: {
                    zzmx zzmx2;
                    block9: {
                        if (this.zzdbb == null) break block9;
                        zzmx2 = zznh.zzbkt;
                        if (((String)zzkb.zzif().zzd(zzmx2)).equals(this.zzdbb.pattern())) break block10;
                    }
                    zzmx2 = zznh.zzbkt;
                    this.zzdbb = Pattern.compile((String)zzkb.zzif().zzd(zzmx2));
                }
                return this.zzdbb.matcher(string2).matches();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    private static boolean zzb(int n, int n2, int n3) {
        return Math.abs(n - n2) <= n3;
    }

    public static Bundle zza(zzhk zzhk2) {
        String string2;
        String string3;
        if (zzhk2 == null) {
            return null;
        }
        zzmx zzmx2 = zznh.zzbju;
        if (!((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            zzmx2 = zznh.zzbjw;
            if (!((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                return null;
            }
        }
        if (zzbs.zzem().zzoy() && zzbs.zzem().zzoz()) {
            return null;
        }
        if (zzhk2.zzgx()) {
            zzhk2.wakeup();
        }
        zzhe zzhe2 = zzhk2.zzgv();
        String string4 = null;
        if (zzhe2 != null) {
            string3 = zzhe2.zzgk();
            string4 = zzhe2.zzgl();
            string2 = zzhe2.zzgm();
            if (string3 != null) {
                zzbs.zzem().zzca(string3);
            }
            if (string2 != null) {
                zzbs.zzem().zzcb(string2);
            }
        } else {
            string3 = zzbs.zzem().zzpe();
            string2 = zzbs.zzem().zzpf();
        }
        Bundle bundle = new Bundle(1);
        if (string2 != null) {
            zzmx2 = zznh.zzbjw;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && !zzbs.zzem().zzoz()) {
                bundle.putString("v_fp_vertical", string2);
            }
        }
        if (string3 != null) {
            zzmx2 = zznh.zzbju;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && !zzbs.zzem().zzoy()) {
                bundle.putString("fingerprint", string3);
                if (!string3.equals(string4)) {
                    bundle.putString("v_fp", string4);
                }
            }
        }
        if (!bundle.isEmpty()) {
            return bundle;
        }
        return null;
    }

    public static int zzav(Context context) {
        return DynamiteModule.zzac((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zzaw(Context context) {
        return DynamiteModule.zzab((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static void zzb(zzjj zzjj2, boolean bl) {
        Bundle bundle;
        Bundle bundle2 = zzjj2.zzbdp != null ? zzjj2.zzbdp : new Bundle();
        if (bundle2.getBundle(AdMobAdapter.class.getName()) != null) {
            bundle = bundle2.getBundle(AdMobAdapter.class.getName());
        } else {
            bundle = new Bundle();
            bundle2.putBundle(AdMobAdapter.class.getName(), bundle);
        }
        bundle.putBoolean("render_test_label", true);
    }

    public static boolean zzp(zzjj zzjj2) {
        Bundle bundle = zzjj2.zzbdp != null ? zzjj2.zzbdp : new Bundle();
        Bundle bundle2 = bundle.getBundle(AdMobAdapter.class.getName()) != null ? bundle.getBundle(AdMobAdapter.class.getName()) : new Bundle();
        return bundle2.getBoolean("render_test_label", false);
    }

    public static String zzci(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        return string2.split(";")[0].trim();
    }

    public static String zzcj(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        String[] stringArray = string2.split(";");
        if (stringArray.length == 1) {
            return "";
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (!stringArray[i].trim().startsWith("charset") || (stringArray2 = stringArray[i].trim().split("=")).length <= 1) continue;
            return stringArray2[1].trim();
        }
        return "";
    }

    static /* synthetic */ boolean zza(zzahn zzahn2, boolean bl) {
        zzahn2.zzdax = bl;
        return zzahn2.zzdax;
    }

    static /* synthetic */ Object zza(zzahn zzahn2) {
        return zzahn2.mLock;
    }

    static /* synthetic */ String zza(zzahn zzahn2, String string2) {
        zzahn2.zzczb = string2;
        return zzahn2.zzczb;
    }
}

