/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzair;
import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzzv;
import java.util.concurrent.TimeUnit;

@zzzv
public final class zzamq {
    private final Context mContext;
    private final String zzcrt;
    private final zzakd zzarf;
    @Nullable
    private final zzns zzdje;
    @Nullable
    private final zznu zzdgt;
    private final zzair zzdjf = new zzaiu().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzqr();
    private final long[] zzdjg;
    private final String[] zzdjh;
    private boolean zzdji = false;
    private boolean zzdjj = false;
    private boolean zzdjk = false;
    private boolean zzdjl = false;
    private boolean zzdgx;
    private zzamb zzdjm;
    private boolean zzdjn;
    private boolean zzdjo;
    private long zzdjp = -1L;

    public zzamq(Context context, zzakd zzakd2, String string2, @Nullable zznu zznu2, @Nullable zzns zzns2) {
        this.mContext = context;
        this.zzarf = zzakd2;
        this.zzcrt = string2;
        this.zzdgt = zznu2;
        this.zzdje = zzns2;
        zzmx zzmx2 = zznh.zzbil;
        String string3 = (String)zzkb.zzif().zzd(zzmx2);
        if (string3 == null) {
            this.zzdjh = new String[0];
            this.zzdjg = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzdjh = new String[stringArray.length];
        this.zzdjg = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzdjg[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzagf.zzc((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzdjg[i] = -1L;
            }
        }
    }

    public final void zza(zzamb zzamb2) {
        zznn.zza(this.zzdgt, this.zzdje, "vpc2");
        this.zzdji = true;
        if (this.zzdgt != null) {
            this.zzdgt.zzf("vpn", zzamb2.zzri());
        }
        this.zzdjm = zzamb2;
    }

    public final void zzro() {
        if (!this.zzdji || this.zzdjj) {
            return;
        }
        zznn.zza(this.zzdgt, this.zzdje, "vfr2");
        this.zzdjj = true;
    }

    public final void onStop() {
        zzmx zzmx2 = zznh.zzbik;
        if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && !this.zzdjn) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzcrt);
            bundle.putString("player", this.zzdjm.zzri());
            for (zzait object : this.zzdjf.getBuckets()) {
                String string2 = String.valueOf("fps_c_");
                String string3 = String.valueOf(object.name);
                bundle.putString(string3.length() != 0 ? string2.concat(string3) : new String(string2), Integer.toString(object.count));
                String string4 = String.valueOf("fps_p_");
                String string5 = String.valueOf(object.name);
                bundle.putString(string5.length() != 0 ? string4.concat(string5) : new String(string4), Double.toString(object.zzdcf));
            }
            for (int i = 0; i < this.zzdjg.length; ++i) {
                String string6 = this.zzdjh[i];
                if (string6 == null) continue;
                String string7 = "fh_";
                String string8 = String.valueOf((Object)this.zzdjg[i]);
                bundle.putString(new StringBuilder(String.valueOf(string7).length() + String.valueOf(string8).length()).append(string7).append(string8).toString(), string6);
            }
            zzbs.zzei().zza(this.mContext, this.zzarf.zzcv, "gmob-apps", bundle, true);
            this.zzdjn = true;
        }
    }

    public final void zzb(zzamb zzamb2) {
        zzamq zzamq2 = this;
        if (zzamq2.zzdjk && !zzamq2.zzdjl) {
            zznn.zza(zzamq2.zzdgt, zzamq2.zzdje, "vff2");
            zzamq2.zzdjl = true;
        }
        long l = zzbs.zzeo().nanoTime();
        if (zzamq2.zzdgx && zzamq2.zzdjo && zzamq2.zzdjp != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - zzamq2.zzdjp);
            zzamq2.zzdjf.zza(d);
        }
        zzamq2.zzdjo = zzamq2.zzdgx;
        zzamq2.zzdjp = l;
        zzamb zzamb3 = zzamb2;
        zzamq2 = this;
        zzmx zzmx2 = zznh.zzbim;
        long l2 = (Long)zzkb.zzif().zzd(zzmx2);
        long l3 = zzamb3.getCurrentPosition();
        for (int i = 0; i < zzamq2.zzdjh.length; ++i) {
            long l4;
            if (zzamq2.zzdjh[i] != null || l2 <= Math.abs(l3 - (l4 = zzamq2.zzdjg[i]))) continue;
            String[] stringArray = zzamq2.zzdjh;
            Bitmap bitmap = zzamb3.getBitmap(8, 8);
            long l5 = 0L;
            long l6 = 63L;
            for (int j = 0; j < 8; ++j) {
                int n = 0;
                while (n < 8) {
                    int n2 = bitmap.getPixel(n, j);
                    long l7 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2) > 128 ? 1L : 0L;
                    l5 |= l7 << (int)l6;
                    ++n;
                    --l6;
                }
            }
            stringArray[i] = String.format("%016X", l5);
            return;
        }
    }

    public final void zzsn() {
        this.zzdgx = true;
        if (this.zzdjj && !this.zzdjk) {
            zznn.zza(this.zzdgt, this.zzdje, "vfp2");
            this.zzdjk = true;
        }
    }

    public final void zzso() {
        this.zzdgx = false;
    }
}

