/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzajp;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzv;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzzv
public final class zzamv
implements zzt<zzamp> {
    private boolean zzdjv;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzkb.zzia();
                n2 = zzajr.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzagf.zzcu((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzamd zzamd2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzagf.zzcu((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Object object2;
        Object object3;
        Map map2 = map;
        zzamp zzamp2 = (zzamp)object;
        zzamv zzamv2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzagf.zzcu((String)"Action missing from video GMSG.");
            return;
        }
        if (zzagf.zzae((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzagf.zzbx((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzagf.zzcu((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzamp2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzagf.zzcu((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzagf.zzcu((String)"No MIME types specified for decoder properties inspection.");
                zzamd.zza(zzamp2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzagf.zzcu((String)"Video decoder properties available on API versions >= 16.");
                zzamd.zza(zzamp2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzajp.zzco(string3.trim()));
            }
            zzamd.zza(zzamp2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzamp2.zzsf();
        if (object3 == null) {
            zzagf.zzcu((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzamp2.getContext();
            int n2 = zzamv.zza(context, map2, "x", 0);
            int n3 = zzamv.zza(context, map2, "y", 0);
            int n4 = zzamv.zza(context, map2, "w", -1);
            int n5 = zzamv.zza(context, map2, "h", -1);
            zzmx zzmx2 = zznh.zzbov;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
                n4 = Math.min(n4, zzamp2.zzsm() - n2);
                n5 = Math.min(n5, zzamp2.zzsl() - n3);
            }
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzamg)object3).zzsa() == null) {
                zzamo zzamo2 = new zzamo((String)map2.get("flags"));
                ((zzamg)object3).zza(n2, n3, n4, n5, n, bl3, zzamo2);
                zzamd zzamd2 = ((zzamg)object3).zzsa();
                if (zzamd2 != null) {
                    zzamv.zza(zzamd2, map2);
                }
                return;
            }
            ((zzamg)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzamd zzamd3 = ((zzamg)object3).zzsa();
        if (zzamd3 == null) {
            zzamd.zza(zzamp2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzamp2.getContext();
            int n = zzamv.zza(context, map2, "x", 0);
            int n6 = zzamv.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzamd3.zzf(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = (String)map2.get("time");
            if (string4 == null) {
                zzagf.zzcu((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzamd3.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzagf.zzcu((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzamd3.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzamd3.zzrt();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzamv.zza(zzamd3, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzamd3.zzru();
                return;
            }
            zzamd3.zzrv();
            return;
        }
        if ("pause".equals(string2)) {
            zzamd3.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzamd3.play();
            return;
        }
        if ("show".equals(string2)) {
            zzamd3.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzamd3.zzcv((String)map2.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzamp2.getContext();
            int n = zzamv.zza(context, map2, "dx", 0);
            int n7 = zzamv.zza(context, map2, "dy", 0);
            zzamd3.zza(n, n7);
            if (!zzamv2.zzdjv) {
                zzamp2.zzna();
                zzamv2.zzdjv = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = (String)map2.get("volume");
            if (string6 == null) {
                zzagf.zzcu((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzamd3.zzb(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzagf.zzcu((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzamd3.zzrw();
            return;
        }
        String string8 = String.valueOf(string2);
        zzagf.zzcu((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

