/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcp;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzfjs;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdm {
    private static final String TAG = zzdm.class.getSimpleName();
    protected Context zzair;
    private ExecutorService zzais;
    private DexClassLoader zzait;
    private zzcx zzaiu;
    private byte[] zzaiv;
    private volatile AdvertisingIdClient zzaiw = null;
    private volatile boolean zzahr = false;
    private Future zzaix = null;
    private boolean zzaiy;
    private volatile zzaz zzaiz = null;
    private Future zzaja = null;
    private zzcp zzajb;
    private boolean zzajc = false;
    private boolean zzajd = false;
    private Map<Pair<String, String>, zzer> zzaje;
    private boolean zzajf = false;
    private boolean zzajg = true;
    private boolean zzajh = false;

    public static zzdm zza(Context context, String string2, String string3, boolean bl) {
        zzdm zzdm2 = new zzdm(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdm zzdm3 = zzdm2;
            zzdm2.zzais = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            zzdm zzdm4 = zzdm3;
            zzdm3.zzahr = bl3;
            if (bl3) {
                zzdm4.zzaix = zzdm4.zzais.submit(new zzdn(zzdm4));
            }
            zzdm zzdm5 = zzdm3;
            zzdm5.zzais.execute(new zzdp(zzdm5));
            try {
                object = zzf.zzafy();
                zzdm5.zzajc = zzf.zzcf((Context)zzdm5.zzair) > 0;
                zzdm5.zzajd = object.isGooglePlayServicesAvailable(zzdm5.zzair) == 0;
            }
            catch (Throwable throwable) {}
            zzdm3.zza(0, true);
            if (zzdr.zzau()) {
                zzdm4 = zznh.zzbnv;
                if (((Boolean)zzkb.zzif().zzd((zzmx)zzdm4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdm5 = zzdm3;
            zzdm3.zzaiu = new zzcx(null);
            try {
                zzdm5.zzaiv = zzdm5.zzaiu.zzl((String)object);
            }
            catch (zzcy zzcy2) {
                throw new zzdj(zzcy2);
            }
            object = string4;
            zzdm5 = zzdm3;
            try {
                String string6;
                File file = zzdm5.zzair.getCacheDir();
                if (file == null && (file = zzdm5.zzair.getDir("dex", 0)) == null) {
                    throw new zzdj();
                }
                String string7 = string6 = "1505450608132";
                File file2 = file;
                Object object2 = object;
                zzdm zzdm6 = zzdm5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdm6.zzaiu.zzb(zzdm6.zzaiv, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdm5.zzb(file, string6);
                try {
                    zzdm5.zzait = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdm5.zzair.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdm.zzb(file4);
                    zzdm5.zza(file, string6);
                    zzdm.zzm(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdm.zzb(file4);
                zzdm5.zza(file, string6);
                zzdm.zzm(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzdj(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzdj(iOException);
            }
            catch (zzcy zzcy3) {
                throw new zzdj(zzcy3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzdj(nullPointerException);
            }
            zzdm4 = zzdm3;
            zzmx zzmx2 = zznh.zzbnn;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && !zzdm4.zzajh) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdm4.zzair.registerReceiver((BroadcastReceiver)new zza(zzdm4, null), intentFilter);
                zzdm4.zzajh = true;
            }
            zzdm3.zzajb = new zzcp(zzdm3);
            zzdm3.zzajf = true;
        }
        catch (zzdj zzdj2) {}
        return zzdm2;
    }

    public final Context getContext() {
        return this.zzair;
    }

    public final boolean isInitialized() {
        return this.zzajf;
    }

    public final ExecutorService zzag() {
        return this.zzais;
    }

    public final DexClassLoader zzah() {
        return this.zzait;
    }

    public final zzcx zzai() {
        return this.zzaiu;
    }

    public final byte[] zzaj() {
        return this.zzaiv;
    }

    public final boolean zzak() {
        return this.zzajc;
    }

    public final zzcp zzal() {
        return this.zzajb;
    }

    public final boolean zzam() {
        return this.zzajd;
    }

    public final boolean zzan() {
        return this.zzajg;
    }

    public final zzaz zzao() {
        return this.zzaiz;
    }

    public final Future zzap() {
        return this.zzaja;
    }

    private zzdm(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzaiy = context2 != null;
        this.zzair = this.zzaiy ? context2 : context;
        this.zzaje = new HashMap<Pair<String, String>, zzer>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            return;
        }
        zzbd zzbd2 = new zzbd();
        new zzbd().zzgn = Build.VERSION.SDK.getBytes();
        zzbd2.zzgm = string2.getBytes();
        byte[] byArray2 = this.zzaiu.zzc(this.zzaiv, byArray).getBytes();
        zzbd2.data = byArray2;
        zzbd2.zzgl = zzbw.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzfjs.zzc((zzfjs)zzbd2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdm.zzb(file2);
        return;
        catch (zzcy | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdm.zzb(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdm.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbd zzbd2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdm.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdm.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbd2 = (zzbd)zzfjs.zza((zzfjs)new zzbd(), (byte[])byArray2);
                if (string2.equals(new String(zzbd2.zzgm)) && Arrays.equals(zzbd2.zzgl, zzbw.zzb(zzbd2.data)) && Arrays.equals(zzbd2.zzgn, Build.VERSION.SDK.getBytes())) break block30;
                zzdm.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzaiu.zzb(this.zzaiv, new String(zzbd2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcy | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzaje.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzaje.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzer(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzer zzer2 = this.zzaje.get(new Pair((Object)string2, (Object)string3));
        if (zzer2 == null) {
            return null;
        }
        return zzer2.zzbd();
    }

    private final void zzaq() {
        try {
            if (this.zzaiw == null && this.zzaiy) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzair);
                advertisingIdClient.start();
                this.zzaiw = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaiw = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzajd) {
            return;
        }
        Future<?> future = this.zzais.submit(new zzdo(this, n, bl));
        if (n == 0) {
            this.zzaja = future;
        }
    }

    @VisibleForTesting
    final zzaz zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzar();
    }

    private static boolean zza(int n, zzaz zzaz2) {
        if (n < 4) {
            if (zzaz2 == null) {
                return true;
            }
            zzmx zzmx2 = zznh.zzbny;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && (zzaz2.zzcw == null || zzaz2.zzcw.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzmx2 = zznh.zzbnz;
            if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue() && (zzaz2.zzfi == null || zzaz2.zzfi.zzgg == null || zzaz2.zzfi.zzgg == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzaz zzar() {
        zzaz zzaz2 = null;
        try {
            PackageInfo packageInfo = this.zzair.getPackageManager().getPackageInfo(this.zzair.getPackageName(), 0);
            zzaz2 = zzcbm.zzm((Context)this.zzair, (String)this.zzair.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzaz2;
    }

    public final AdvertisingIdClient zzas() {
        if (!this.zzahr) {
            return null;
        }
        if (this.zzaiw != null) {
            return this.zzaiw;
        }
        if (this.zzaix != null) {
            try {
                this.zzaix.get(2000L, TimeUnit.MILLISECONDS);
                this.zzaix = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzaix.cancel(true);
            }
        }
        return this.zzaiw;
    }

    public final int zzac() {
        int n = Integer.MIN_VALUE;
        if (this.zzajb != null) {
            n = zzcp.zzac();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdm zzdm2) {
        zzdm2.zzaq();
    }

    static /* synthetic */ zzaz zza(zzdm zzdm2, zzaz zzaz2) {
        zzdm2.zzaiz = zzaz2;
        return zzdm2.zzaiz;
    }

    static /* synthetic */ boolean zzb(int n, zzaz zzaz2) {
        return zzdm.zza(n, zzaz2);
    }

    final class zza
    extends BroadcastReceiver {
        private /* synthetic */ zzdm zzaji;

        private zza(zzdm zzdm2) {
            this.zzaji = zzdm2;
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                this.zzaji.zzajg = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                this.zzaji.zzajg = false;
            }
        }

        /* synthetic */ zza(zzdm zzdm2, zzdn zzdn2) {
            this(zzdm2);
        }
    }
}

