/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzdvl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public final class zzdr {
    private static final char[] zzaju = "0123456789abcdef".toCharArray();

    public static String zzn(String string2) {
        if (string2 != null && string2.matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            UUID uUID = UUID.fromString(string2);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
            string2 = zzbu.zza(byArray, true);
        }
        return string2;
    }

    public static String zza(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        zzdvl.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Long zzat() {
        return Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles")).getTime().getTime();
    }

    public static boolean zzo(String string2) {
        return string2 == null || string2.isEmpty();
    }

    public static boolean zzau() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean zza(DisplayMetrics displayMetrics) {
        return displayMetrics != null && displayMetrics.density != 0.0f;
    }

    public static long zza(double d, int n, DisplayMetrics displayMetrics) {
        return Math.round(d * (double)n / (double)displayMetrics.density);
    }

    public static Activity zzc(View view) {
        View view2 = view.getRootView();
        Context context = (view2 != null ? view2 : view).getContext();
        for (int i = 0; context instanceof ContextWrapper && i < 10; ++i) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

