/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzdv;
import java.lang.ref.WeakReference;

public final class zzdt
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zzajw = new Handler(Looper.getMainLooper());
    private final Context zzajx;
    private Application zzaii;
    private final PowerManager zzajy;
    private final KeyguardManager zzajz;
    private final zzdm zzagr;
    private BroadcastReceiver zzaka;
    private WeakReference<ViewTreeObserver> zzakb;
    private WeakReference<View> zzakc;
    private zzda zzakd;
    private boolean zzake = false;
    private int zzakf = -1;
    private long zzakg = -3L;

    public zzdt(zzdm zzdm2, View view) {
        this.zzagr = zzdm2;
        this.zzajx = zzdm2.zzair;
        this.zzajy = (PowerManager)this.zzajx.getSystemService("power");
        this.zzajz = (KeyguardManager)this.zzajx.getSystemService("keyguard");
        if (this.zzajx instanceof Application) {
            this.zzaii = (Application)this.zzajx;
            this.zzakd = new zzda((Application)this.zzajx, this);
        }
        this.zzd(view);
    }

    final void zzd(View view) {
        View view2 = this.zzakc != null ? (View)this.zzakc.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzf(view2);
        }
        this.zzakc = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zze(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzakg = -2L;
            return;
        }
        this.zzakg = -3L;
    }

    private final void zzav() {
        zzajw.post((Runnable)new zzdu(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzakf = -1;
        this.zze(view);
        this.zzax();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzakf = -1;
        this.zzax();
        this.zzav();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzakc == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzakc.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzakf = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzax();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzax();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzax();
        this.zzav();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzax();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzax();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzax();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzax();
    }

    public final void onGlobalLayout() {
        this.zzax();
    }

    public final void onScrollChanged() {
        this.zzax();
    }

    public final long zzaw() {
        if (this.zzakg == -2L && this.zzakc.get() == null) {
            this.zzakg = -3L;
        }
        return this.zzakg;
    }

    private final void zzax() {
        boolean bl;
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        if (this.zzakc == null) {
            return;
        }
        View view2 = (View)this.zzakc.get();
        if (view2 == null) {
            this.zzakg = -3L;
            this.zzake = false;
            return;
        }
        boolean bl2 = view2.getGlobalVisibleRect(new Rect());
        boolean bl3 = view2.getLocalVisibleRect(new Rect());
        boolean bl4 = this.zzagr.zzan() || this.zzajz.inKeyguardRestrictedInputMode() && (activity = zzdr.zzc(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0;
        int n = view2.getWindowVisibility();
        int n2 = this.zzakf != -1 ? this.zzakf : n;
        boolean bl5 = bl = view2.getVisibility() == 0 && view2.isShown() && this.zzajy.isScreenOn() && bl4 && bl3 && bl2 && n2 == 0;
        if (this.zzake != bl) {
            this.zzakg = bl ? SystemClock.elapsedRealtime() : -2L;
            this.zzake = bl;
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzakb = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzdt zzdt2 = this;
        if (zzdt2.zzaka == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzdt2.zzaka = new zzdv(zzdt2);
            zzdt2.zzajx.registerReceiver(zzdt2.zzaka, intentFilter);
        }
        if (this.zzaii != null) {
            try {
                this.zzaii.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzakd);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzakb != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzakb.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzakb = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzdt zzdt2 = this;
        if (zzdt2.zzaka != null) {
            try {
                zzdt2.zzajx.unregisterReceiver(zzdt2.zzaka);
            }
            catch (Exception exception) {}
            zzdt2.zzaka = null;
        }
        if (this.zzaii != null) {
            try {
                this.zzaii.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzakd);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzdt zzdt2) {
        zzdt2.zzax();
    }
}

