/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafo;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzfu;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzzv;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzv
public final class zzft
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzafo> zzavt;
    private WeakReference<ViewTreeObserver> zzavu;
    private final zzhd zzavv;
    protected final zzfr zzavw;
    private final Context mApplicationContext;
    private final WindowManager zzavx;
    private final PowerManager zzavy;
    private final KeyguardManager zzavz;
    private final DisplayMetrics zzawa;
    @Nullable
    private zzga zzawb;
    private boolean zzawc;
    private boolean zzarz = false;
    private boolean zzawd = false;
    private boolean zzawe;
    private boolean zzawf;
    private boolean zzawg;
    @Nullable
    private BroadcastReceiver zzawh;
    private final HashSet<Object> zzawi = new HashSet();
    private zzaji zzavd;
    private final HashSet<zzgo> zzawj = new HashSet();
    private final Rect zzawk = new Rect();
    private final zzfw zzawl;
    private float zzawm;

    public zzft(Context context, zzjn zzjn2, zzafo zzafo2, zzakd zzakd2, zzhd zzhd2) {
        this.zzavt = new WeakReference<zzafo>(zzafo2);
        this.zzavv = zzhd2;
        this.zzavu = new WeakReference<Object>(null);
        this.zzawe = true;
        this.zzawg = false;
        this.zzavd = new zzaji(200L);
        this.zzavw = new zzfr(UUID.randomUUID().toString(), zzakd2, zzjn2.zzbek, zzafo2.zzcxj, zzafo2.zzfv(), zzjn2.zzben);
        this.zzavx = (WindowManager)context.getSystemService("window");
        this.zzavy = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzavz = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzawl = new zzfw(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzawl);
        this.zzawa = context.getResources().getDisplayMetrics();
        Display display = this.zzavx.getDefaultDisplay();
        this.zzawk.right = display.getWidth();
        this.zzawk.bottom = display.getHeight();
        this.zzfx();
    }

    public final void zzfx() {
        zzbs.zzei();
        this.zzawm = zzahn.zzaq(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzawe) {
                this.zzawf = true;
                try {
                    JSONObject jSONObject = this.zzgc();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzagf.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzagf.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzavw.zzfu());
                zzagf.zzbx((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzl(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgo> iterator = this.zzawj.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzgg()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzawe) {
                return;
            }
            View view = this.zzavv.zzgd();
            boolean bl3 = view != null && zzbs.zzei().zza(view, this.zzavy, this.zzavz);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzavv.zzge()) {
                this.zzfy();
                return;
            }
            if (n == 1 && !this.zzavd.tryAcquire() && bl == this.zzawg) {
                return;
            }
            if (!bl && !this.zzawg && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzawg = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzagf.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzft zzft2 = this;
            View view2 = zzft2.zzavv.zzgf().zzgd();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzft2.zzavu.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzft2.zzgb();
                    if (!zzft2.zzawc || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzft2.zzawc = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzft2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzft2);
                    }
                    zzft2.zzavu = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzfz();
            return;
        }
    }

    private final void zzfz() {
        if (this.zzawb != null) {
            this.zzawb.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzga() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzawe;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zze(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzavw.zzfu());
    }

    final void zzf(Map<String, String> map) {
        this.zzl(3);
    }

    final void zza(zzgo zzgo2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzavw.zzfu());
        zzagf.zzbx((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgo2);
    }

    final void zzg(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzawi.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzgb() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzavu.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzgc() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzavw.zzfs()).put("activeViewJSON", (Object)this.zzavw.zzft()).put("timestamp", zzbs.zzeo().elapsedRealtime()).put("adFormat", (Object)this.zzavw.zzfr()).put("hashCode", (Object)this.zzavw.zzfu()).put("isMraid", this.zzavw.zzfv()).put("isStopped", this.zzawd).put("isPaused", this.zzarz).put("isNative", this.zzavw.zzfw()).put("isScreenOn", this.isScreenOn());
        zzbs.zzei();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzahn.zzdo());
        zzbs.zzei();
        jSONObject3.put("appVolume", (double)zzahn.zzdn()).put("deviceVolume", (double)this.zzawm);
        return jSONObject;
    }

    private static JSONObject zzb(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzft.zzb(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzft zzft2 = this;
            ArrayList<zzgo> arrayList = new ArrayList<zzgo>(zzft2.zzawj);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgo zzgo2 = arrayList.get(i);
                zzgo2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzagf.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgo zzgo2) {
        if (this.zzawj.isEmpty()) {
            zzft zzft2 = this;
            Object object = zzft2.mLock;
            synchronized (object) {
                if (zzft2.zzawh != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzft2.zzawh = new zzfu(zzft2);
                    zzbs.zzfg().zza(zzft2.mApplicationContext, zzft2.zzawh, intentFilter);
                }
            }
            this.zzl(3);
        }
        this.zzawj.add(zzgo2);
        try {
            JSONObject jSONObject = zzft.zzb(this.zza(this.zzavv.zzgd(), null));
            zzgo2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzagf.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgo zzgo2) {
        this.zzawj.remove(zzgo2);
        zzgo2.zzgh();
        if (this.zzawj.isEmpty()) {
            zzft zzft2 = this;
            Object object = zzft2.mLock;
            synchronized (object) {
                zzft2.zzgb();
                zzft zzft3 = zzft2;
                Object object2 = zzft3.mLock;
                synchronized (object2) {
                    if (zzft3.zzawh != null) {
                        try {
                            zzbs.zzfg().zza(zzft3.mApplicationContext, zzft3.zzawh);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzagf.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbs.zzem().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzft3.zzawh = null;
                    }
                }
                zzft2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzft2.zzawl);
                zzft2.zzawe = false;
                zzft2.zzfz();
                zzft3 = zzft2;
                ArrayList<zzgo> arrayList = new ArrayList<zzgo>(zzft3.zzawj);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgo zzgo3 = arrayList.get(i);
                    zzgo zzgo4 = zzgo3;
                    zzft3.zzb(zzgo4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzft zzft2 = this;
            return zzft2.zzgc().put("isAttachedToWindow", false).put("isScreenOn", zzft2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbs.zzek().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzagf.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzgc();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzft.zza(this.zzawk.top, this.zzawa)).put("bottom", zzft.zza(this.zzawk.bottom, this.zzawa)).put("left", zzft.zza(this.zzawk.left, this.zzawa)).put("right", zzft.zza(this.zzawk.right, this.zzawa))).put("adBox", (Object)new JSONObject().put("top", zzft.zza(rect.top, this.zzawa)).put("bottom", zzft.zza(rect.bottom, this.zzawa)).put("left", zzft.zza(rect.left, this.zzawa)).put("right", zzft.zza(rect.right, this.zzawa))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzft.zza(rect2.top, this.zzawa)).put("bottom", zzft.zza(rect2.bottom, this.zzawa)).put("left", zzft.zza(rect2.left, this.zzawa)).put("right", zzft.zza(rect2.right, this.zzawa))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzft.zza(rect3.top, this.zzawa)).put("bottom", zzft.zza(rect3.bottom, this.zzawa)).put("left", zzft.zza(rect3.left, this.zzawa)).put("right", zzft.zza(rect3.right, this.zzawa))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzft.zza(rect4.top, this.zzawa)).put("bottom", zzft.zza(rect4.bottom, this.zzawa)).put("left", zzft.zza(rect4.left, this.zzawa)).put("right", zzft.zza(rect4.right, this.zzawa))).put("screenDensity", (double)this.zzawa.density);
        if (bl == null) {
            bl = zzbs.zzei().zza(view, this.zzavy, this.zzavz);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzavy.isInteractive();
        }
        return this.zzavy.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzl(1);
    }

    public final void onGlobalLayout() {
        this.zzl(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzga zzga2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzawb = zzga2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzawd = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarz = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarz = false;
            this.zzl(3);
            return;
        }
    }
}

