/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzacp;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzth;
import com.google.android.gms.internal.zzti;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.internal.zztm;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzzv
public final class zztg {
    private final Map<zzth, zzti> zzbzq = new HashMap<zzth, zzti>();
    private final LinkedList<zzth> zzbzr = new LinkedList();
    @Nullable
    private zzsd zzbzs;

    final void zza(zzsd zzsd2) {
        if (this.zzbzs == null) {
            this.zzbzs = zzsd2.zzku();
            zztg zztg2 = this;
            if (zztg2.zzbzs != null) {
                SharedPreferences sharedPreferences = zztg2.zzbzs.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zztg zztg3 = zztg2;
                while (zztg3.zzbzr.size() > 0) {
                    zzth zzth2 = zztg3.zzbzr.remove();
                    zzti zzti2 = zztg3.zzbzq.get(zzth2);
                    zztg.zza("Flushing interstitial queue for %s.", zzth2);
                    while (zzti2.size() > 0) {
                        zzti2.zzm(null).zzbzx.zzdk();
                    }
                    zztg3.zzbzq.remove(zzth2);
                }
                try {
                    zzth zzth2;
                    HashMap<String, zzth> hashMap = new HashMap<String, zzth>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zztm zztm2 = zztm.zzba((String)stringArray.getValue());
                        zzth2 = new zzth(zztm2.zzarx, zztm2.zzapq, zztm2.zzbzv);
                        if (zztg2.zzbzq.containsKey(zzth2)) continue;
                        zzti zzti2 = new zzti(zztm2.zzarx, zztm2.zzapq, zztm2.zzbzv);
                        zztg2.zzbzq.put(zzth2, zzti2);
                        hashMap.put(zzth2.toString(), zzth2);
                        zztg.zza("Restored interstitial queue for %s.", zzth2);
                    }
                    for (String string2 : zztg.zzax(sharedPreferences.getString("PoolKeys", ""))) {
                        zzth2 = (zzth)hashMap.get(string2);
                        if (!zztg2.zzbzq.containsKey(zzth2)) continue;
                        zztg2.zzbzr.add(zzth2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbs.zzem().zza(exception, "InterstitialAdPool.restore");
                    zzagf.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zztg2.zzbzq.clear();
                    zztg2.zzbzr.clear();
                }
            }
        }
    }

    @Nullable
    final zztj zza(zzjj zzjj2, String string2) {
        Object object;
        Object object2;
        zzmx zzmx2;
        String string3;
        if (zztg.zzay(string2)) {
            return null;
        }
        Context context = this.zzbzs.getApplicationContext();
        int n = new zzacp((Context)context).zzny().zzcty;
        zzjj zzjj3 = zztg.zzk(zzjj2);
        zzth zzth2 = new zzth(zzjj3, string3 = zztg.zzaz(string2), n);
        zzti zzti2 = this.zzbzq.get(zzth2);
        if (zzti2 == null) {
            zztg.zza("Interstitial pool created at %s.", zzth2);
            zzti2 = new zzti(zzjj3, string3, n);
            this.zzbzq.put(zzth2, zzti2);
        }
        this.zzbzr.remove(zzth2);
        this.zzbzr.add(zzth2);
        zzti2.zzla();
        while (true) {
            zzmx2 = zznh.zzbly;
            if (this.zzbzr.size() <= (Integer)zzkb.zzif().zzd(zzmx2)) break;
            object2 = this.zzbzr.remove();
            object = this.zzbzq.get(object2);
            zztg.zza("Evicting interstitial queue for %s.", (zzth)object2);
            while (((zzti)object).size() > 0) {
                zztj zztj2 = ((zzti)object).zzm(null);
                if (zztj2.zzcab) {
                    zztk.zzlc().zzle();
                }
                zztj2.zzbzx.zzdk();
            }
            this.zzbzq.remove(object2);
        }
        while (zzti2.size() > 0) {
            object2 = zzti2.zzm(zzjj3);
            if (((zztj)object2).zzcab) {
                zzmx2 = zznh.zzbma;
                if (zzbs.zzeo().currentTimeMillis() - ((zztj)object2).zzcaa > 1000L * (long)((Integer)zzkb.zzif().zzd(zzmx2)).intValue()) {
                    zztg.zza("Expired interstitial at %s.", zzth2);
                    zztk.zzlc().zzld();
                    continue;
                }
            }
            object = ((zztj)object2).zzbzy != null ? " (inline) " : " ";
            zztg.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zzth2);
            return object2;
        }
        return null;
    }

    final void zzb(zzjj zzjj2, String string2) {
        String string3;
        if (this.zzbzs == null) {
            return;
        }
        Context context = this.zzbzs.getApplicationContext();
        int n = new zzacp((Context)context).zzny().zzcty;
        zzjj zzjj3 = zztg.zzk(zzjj2);
        zzth zzth2 = new zzth(zzjj3, string3 = zztg.zzaz(string2), n);
        zzti zzti2 = this.zzbzq.get(zzth2);
        if (zzti2 == null) {
            zztg.zza("Interstitial pool created at %s.", zzth2);
            zzti2 = new zzti(zzjj3, string3, n);
            this.zzbzq.put(zzth2, zzti2);
        }
        zzti2.zza(this.zzbzs, zzjj2);
        zzti2.zzla();
        zztg.zza("Inline entry added to the queue at %s.", zzth2);
    }

    final void zzkv() {
        zztg zztg2;
        if (this.zzbzs == null) {
            return;
        }
        for (Map.Entry<zzth, zzti> entry : this.zzbzq.entrySet()) {
            int n;
            zzth zzth2 = entry.getKey();
            zzti zzti2 = entry.getValue();
            if (zzagf.zzae((int)2)) {
                n = zzti2.size();
                int n2 = zzti2.zzky();
                if (n2 < n) {
                    zzagf.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzth2));
                }
            }
            n = 0 + zzti2.zzkz();
            while (true) {
                zztg2 = zznh.zzblz;
                if (zzti2.size() >= (Integer)zzkb.zzif().zzd((zzmx)zztg2)) break;
                zztg.zza("Pooling and loading one new interstitial for %s.", zzth2);
                if (!zzti2.zzb(this.zzbzs)) continue;
                ++n;
            }
            zztk.zzlc().zzu(n);
        }
        zztg2 = this;
        if (zztg2.zzbzs != null) {
            SharedPreferences.Editor editor = zztg2.zzbzs.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zzth, zzti> entry : zztg2.zzbzq.entrySet()) {
                zzth zzth3 = entry.getKey();
                zzti zzti3 = entry.getValue();
                if (!zzti3.zzlb()) continue;
                String string2 = new zztm(zzti3).zzll();
                String string3 = zzth3.toString();
                editor.putString(string3, string2);
                zztg.zza("Saved interstitial queue for %s.", zzth3);
            }
            editor.putString("PoolKeys", zztg2.zzkw());
            editor.apply();
        }
    }

    private final String zzkw() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbzr.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzth)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzax(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzay(String string2) {
        try {
            zzmx zzmx2 = zznh.zzbmb;
            return Pattern.matches((String)zzkb.zzif().zzd(zzmx2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbs.zzem().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzi(zzjj zzjj2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzjj2.extras.keySet());
        Bundle bundle = zzjj2.zzbdp.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzjj zzj(zzjj zzjj2) {
        zzjj zzjj3 = zztg.zzl(zzjj2);
        String string2 = "_skipMediation";
        zzjj zzjj4 = zzjj3;
        Bundle bundle = zzjj3.zzbdp.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzjj4.extras.putBoolean(string2, true);
        return zzjj3;
    }

    private static zzjj zzk(zzjj zzjj2) {
        zzjj zzjj3 = zztg.zzl(zzjj2);
        zzmx zzmx2 = zznh.zzblx;
        for (String string2 : ((String)zzkb.zzif().zzd(zzmx2)).split(",")) {
            zztg.zzc(zzjj3.zzbdp, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zztg.zzc(zzjj3.extras, string4);
        }
        return zzjj3;
    }

    private static String zzaz(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzjj zzl(zzjj zzjj2) {
        Parcel parcel = Parcel.obtain();
        zzjj2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzjj zzjj3 = (zzjj)zzjj.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzmx zzmx2 = zznh.zzblm;
        if (((Boolean)zzkb.zzif().zzd(zzmx2)).booleanValue()) {
            zzjj.zzh((zzjj)zzjj3);
        }
        return zzjj3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zzth zzth2) {
        if (zzagf.zzae((int)2)) {
            zzagf.v(String.format(string2, zzth2));
        }
    }
}

