/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzwp;
import com.google.android.gms.internal.zzwq;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzzv;
import java.util.Map;

@zzzv
public final class zzwo
extends zzxb {
    private final Map<String, String> zzbsr;
    private final Context mContext;
    private String zzcge;
    private long zzcgf;
    private long zzcgg;
    private String zzcgh;
    private String zzcgi;

    public zzwo(zzanh zzanh2, Map<String, String> map) {
        super(zzanh2, "createCalendarEvent");
        this.zzbsr = map;
        this.mContext = zzanh2.zzsi();
        zzwo zzwo2 = this;
        zzwo2.zzcge = zzwo2.zzbk("description");
        zzwo2.zzcgh = zzwo2.zzbk("summary");
        zzwo2.zzcgf = zzwo2.zzbl("start_ticks");
        zzwo2.zzcgg = zzwo2.zzbl("end_ticks");
        zzwo2.zzcgi = zzwo2.zzbk("location");
    }

    private final String zzbk(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbsr.get(string2))) {
            return "";
        }
        return this.zzbsr.get(string2);
    }

    private final long zzbl(String string2) {
        String string3 = this.zzbsr.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbm("Activity context is not available.");
            return;
        }
        zzbs.zzei();
        if (!zzahn.zzal(this.mContext).zziu()) {
            this.zzbm("This feature is not available on the device.");
            return;
        }
        zzbs.zzei();
        AlertDialog.Builder builder = zzahn.zzak(this.mContext);
        Resources resources = zzbs.zzem().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwp(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwq(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzcge);
        intent.putExtra("eventLocation", this.zzcgi);
        intent.putExtra("description", this.zzcgh);
        if (this.zzcgf > -1L) {
            intent.putExtra("beginTime", this.zzcgf);
        }
        if (this.zzcgg > -1L) {
            intent.putExtra("endTime", this.zzcgg);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzwo zzwo2) {
        return zzwo2.mContext;
    }
}

