/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzzv;
import java.util.Map;

@zzzv
public final class zzwu
extends zzxb {
    private final Map<String, String> zzbsr;
    private final Context mContext;

    public zzwu(zzanh zzanh2, Map<String, String> map) {
        super(zzanh2, "storePicture");
        this.zzbsr = map;
        this.mContext = zzanh2.zzsi();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbm("Activity context is not available");
            return;
        }
        zzbs.zzei();
        if (!zzahn.zzal(this.mContext).zzit()) {
            this.zzbm("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbsr.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbm("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbm(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbs.zzei();
        if (!zzahn.zzcf(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbm(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbs.zzem().getResources();
        zzbs.zzei();
        AlertDialog.Builder builder = zzahn.zzak(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwv(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzww(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzwu zzwu2) {
        return zzwu2.mContext;
    }
}

