/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaea;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzpf;
import java.util.Locale;

public final class zzaeb {
    private int zza;
    private boolean zzb;
    private boolean zzc;
    private int zzd;
    private int zze;
    private int zzf;
    private String zzg;
    private int zzh;
    private int zzi;
    private int zzj;
    private boolean zzk;
    private int zzl;
    private double zzm;
    private boolean zzn;
    private String zzo;
    private String zzp;
    private boolean zzq;
    private boolean zzr;
    private String zzs;
    private boolean zzt;
    private boolean zzu;
    private String zzv;
    private String zzw;
    private float zzx;
    private int zzy;
    private int zzz;
    private String zzaa;
    private boolean zzab;

    public zzaeb(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zza(context);
        this.zzb(context);
        this.zzc(context);
        Locale locale = Locale.getDefault();
        this.zzq = zzaeb.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzr = zzaeb.zza(packageManager, "http://www.google.com") != null;
        this.zzs = locale.getCountry();
        zzlc.zza();
        this.zzt = zzako.zza();
        this.zzu = com.google.android.gms.common.util.zzj.zzc((Context)context);
        this.zzv = locale.getLanguage();
        this.zzw = zzaeb.zzb(context, packageManager);
        this.zzaa = zzaeb.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzx = displayMetrics.density;
        this.zzy = displayMetrics.widthPixels;
        this.zzz = displayMetrics.heightPixels;
    }

    public zzaeb(Context context, zzaea zzaea2) {
        context.getPackageManager();
        this.zza(context);
        this.zzb(context);
        this.zzc(context);
        Context context2 = context;
        zzaeb zzaeb2 = this;
        this.zzo = Build.FINGERPRINT;
        zzaeb2.zzp = Build.DEVICE;
        zzaeb2.zzab = com.google.android.gms.common.util.zzs.zza() && zzpf.zza(context2);
        this.zzq = zzaea2.zzb;
        this.zzr = zzaea2.zzc;
        this.zzs = zzaea2.zze;
        this.zzt = zzaea2.zzf;
        this.zzu = zzaea2.zzg;
        this.zzv = zzaea2.zzj;
        this.zzw = zzaea2.zzk;
        this.zzaa = zzaea2.zzl;
        this.zzx = zzaea2.zzs;
        this.zzy = zzaea2.zzt;
        this.zzz = zzaea2.zzu;
    }

    private final void zza(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zza = audioManager.getMode();
                this.zzb = audioManager.isMusicActive();
                this.zzc = audioManager.isSpeakerphoneOn();
                this.zzd = audioManager.getStreamVolume(3);
                this.zze = audioManager.getRingerMode();
                this.zzf = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbt.zzi().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zza = -2;
        this.zzb = false;
        this.zzc = false;
        this.zzd = 0;
        this.zze = 0;
        this.zzf = 0;
    }

    @TargetApi(value=16)
    private final void zzb(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzg = telephonyManager.getNetworkOperator();
        this.zzi = telephonyManager.getNetworkType();
        this.zzj = telephonyManager.getPhoneType();
        this.zzh = -2;
        this.zzk = false;
        this.zzl = -1;
        zzbt.zze();
        if (zzaij.zza(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzh = networkInfo.getType();
                this.zzl = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzh = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzk = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzc(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzm = (float)n2 / (float)n3;
            this.zzn = n == 2 || n == 5;
            return;
        }
        this.zzm = -1.0;
        this.zzn = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbih.zza((Context)context).zzb("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzaeb.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbih.zza((Context)context).zzb(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbt.zzi().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaea zza() {
        return new zzaea(this.zza, this.zzq, this.zzr, this.zzg, this.zzs, this.zzt, this.zzu, this.zzb, this.zzc, this.zzv, this.zzw, this.zzaa, this.zzd, this.zzh, this.zzi, this.zzj, this.zze, this.zzf, this.zzx, this.zzy, this.zzz, this.zzm, this.zzn, this.zzk, this.zzl, this.zzo, this.zzab, this.zzp);
    }
}

