/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzabh
@Hide
public final class zzaoe
extends zzany {
    private static final Set<String> zzb = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzc = new DecimalFormat("#,###");
    private File zzd;
    private boolean zze;

    public zzaoe(zzann zzann2) {
        super(zzann2);
        File file = this.zza.getCacheDir();
        if (file == null) {
            zzahw.zze((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzd = new File(file, "admobVideoStreams");
        if (!this.zzd.isDirectory() && !this.zzd.mkdirs()) {
            String string2 = String.valueOf(this.zzd.getAbsolutePath());
            zzahw.zze((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzd = null;
            return;
        }
        if (!this.zzd.setReadable(true, false) || !this.zzd.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzd.getAbsolutePath());
            zzahw.zze((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzd = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zza(String string2) {
        int n;
        int n2;
        Object object;
        Object object2;
        block35: {
            int n3;
            if (this.zzd == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzaoe)object2).zzd == null) {
                    n4 = 0;
                } else {
                    int n5 = 0;
                    object = ((zzaoe)object2).zzd.listFiles();
                    n2 = ((File[])object).length;
                    for (n = 0; n < n2; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n5;
                    }
                    n4 = n5;
                }
                object2 = zzoi.zzj;
                if (n4 <= (Integer)zzlc.zzf().zza((zzny)object2)) break block35;
                object2 = this;
                if (((zzaoe)object2).zzd == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzaoe)object2).zzd.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = super.zza(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzahw.zze((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        object2 = string2;
        zzlc.zza();
        String string3 = zzako.zza((String)object2);
        File file = new File(this.zzd, string3);
        File file4 = this.zza(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzahw.zzb((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzd.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzb;
        synchronized (object3) {
            if (zzb.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzahw.zze((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzb.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            zzbt.zzq();
            object2 = zzoi.zzo;
            HttpURLConnection httpURLConnection = zzame.zza(string2, (Integer)zzlc.zzf().zza((zzny)object2));
            if (httpURLConnection instanceof HttpURLConnection && (n8 = httpURLConnection.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string11 = String.valueOf(Integer.toString(n8));
                string10 = string11.length() != 0 ? "HTTP request failed. Code: ".concat(string11) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection.getContentLength();
            if (n8 < 0) {
                String string12 = String.valueOf(string2);
                zzahw.zze((String)(string12.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string12) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzb.remove(string7);
                return false;
            }
            String string13 = zzc.format(n8);
            object2 = zzoi.zzk;
            int n9 = (Integer)zzlc.zzf().zza((zzny)object2);
            if (n8 > n9) {
                zzahw.zze((String)new StringBuilder(33 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Content length ").append(string13).append(" exceeds limit at ").append(string2).toString());
                String string14 = String.valueOf(string13);
                String string15 = string14.length() != 0 ? "File too big for full file cache. Size: ".concat(string14) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string15);
                zzb.remove(string7);
                return false;
            }
            zzahw.zzb((String)new StringBuilder(20 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Caching ").append(string13).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zze zze2 = zzbt.zzl();
            int n10 = 0;
            long l = zze2.zza();
            object2 = zzoi.zzn;
            long l3 = (Long)zzlc.zzf().zza((zzny)object2);
            zzake zzake2 = new zzake(l3);
            object2 = zzoi.zzm;
            long l4 = (Long)zzlc.zzf().zza((zzny)object2);
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n10 += n7) > n9) {
                    string9 = "sizeExceeded";
                    String string16 = String.valueOf(Integer.toString(n10));
                    string10 = string16.length() != 0 ? "File too big for full file cache. Size: ".concat(string16) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (zze2.zza() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string17 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string17).length()).append("Timeout exceeded. Limit: ").append(string17).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zze) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzake2.zza()) continue;
                n = n8;
                n2 = n10;
                object = file.getAbsolutePath();
                String string18 = string2;
                object2 = this;
                zzako.zza.post((Runnable)new zzanz((zzany)object2, string18, (String)object, n2, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzahw.zza((int)3)) {
                String string19 = zzc.format(n10);
                zzahw.zzb((String)new StringBuilder(22 + String.valueOf(string19).length() + String.valueOf(string2).length()).append("Preloaded ").append(string19).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n10);
            zzb.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzbt.zzi().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zze) {
                zzahw.zzd((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzahw.zzc((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string20 = String.valueOf(file.getAbsolutePath());
                zzahw.zze((String)(string20.length() != 0 ? "Could not delete partial cache file at ".concat(string20) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzb.remove(string7);
            return false;
        }
    }

    @Override
    public final void zza() {
        this.zze = true;
    }

    private final File zza(File file) {
        return new File(this.zzd, String.valueOf(file.getName()).concat(".done"));
    }
}

