/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbm;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzaos;
import com.google.android.gms.internal.zzaot;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaox;
import com.google.android.gms.internal.zzapp;
import com.google.android.gms.internal.zzapu;
import com.google.android.gms.internal.zzapz;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzyn;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
final class zzaor
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzaof {
    private final zzapz zza;
    @Nullable
    private final zzcv zzb;
    private final zzala zzc;
    private final zzbm zzd;
    private final zzv zze;
    private final DisplayMetrics zzf;
    private final float zzg;
    private zzaog zzh;
    private zzd zzi;
    private zzaqa zzj;
    private String zzk;
    private boolean zzl;
    private boolean zzm;
    private boolean zzn;
    private boolean zzo;
    private Boolean zzp;
    private int zzq;
    private boolean zzr = true;
    private boolean zzs = false;
    private String zzt = "";
    private zzaou zzu;
    private boolean zzv;
    private boolean zzw;
    private zzpt zzx;
    private int zzy;
    private int zzz;
    private zzot zzaa;
    private zzot zzab;
    private zzot zzac;
    private zzou zzad;
    private WeakReference<View.OnClickListener> zzae;
    private zzd zzaf;
    private boolean zzag;
    private zzakn zzah;
    private int zzai = -1;
    private int zzaj = -1;
    private int zzak = -1;
    private int zzal = -1;
    private Map<String, zzany> zzam;
    private final WindowManager zzan;
    private final zziu zzao;

    static zzaor zza(Context context, zzaqa zzaqa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzala zzala2, zzov zzov2, zzbm zzbm2, zzv zzv2, zziu zziu2) {
        zzapz zzapz2 = new zzapz(context);
        return new zzaor(zzapz2, zzaqa2, string2, bl, bl2, zzcv2, zzala2, zzov2, zzbm2, zzv2, zziu2);
    }

    private zzaor(zzapz zzapz2, zzaqa zzaqa2, String string2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzala zzala2, zzov zzov2, zzbm zzbm2, zzv zzv2, zziu zziu2) {
        super((Context)zzapz2);
        this.zza = zzapz2;
        this.zzj = zzaqa2;
        this.zzk = string2;
        this.zzn = bl;
        this.zzq = -1;
        this.zzb = zzcv2;
        this.zzc = zzala2;
        this.zzd = zzbm2;
        this.zze = zzv2;
        this.zzan = (WindowManager)this.getContext().getSystemService("window");
        zzbt.zze();
        this.zzf = zzaij.zza(this.zzan);
        this.zzg = this.zzf.density;
        this.zzao = zziu2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzahw.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzbt.zze().zza((Context)zzapz2, zzala2.zza, webSettings);
        zzbt.zzg().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzar();
        if (com.google.android.gms.common.util.zzs.zzc()) {
            this.addJavascriptInterface(zzaox.zza(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzah = new zzakn(this.zza.zza(), (View)this, this, null);
        zzov zzov3 = zzov2;
        zzaor zzaor2 = this;
        zzaor2.zzaw();
        zzaor2.zzad = new zzou(new zzov(true, "make_wv", zzaor2.zzk));
        zzaor2.zzad.zza().zza(zzov3);
        zzaor2.zzab = zzoo.zza(zzaor2.zzad.zza());
        zzaor2.zzad.zza("native:view_create", zzaor2.zzab);
        zzaor2.zzac = null;
        zzaor2.zzaa = null;
        zzbt.zzg().zzb((Context)zzapz2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzaog) {
            this.zzh = (zzaog)webViewClient;
        }
    }

    @Override
    public final WebView zzl() {
        return this;
    }

    @Override
    public final View zzm() {
        return this;
    }

    @Override
    public final zzv zze() {
        return this.zze;
    }

    private final boolean zzal() {
        int n;
        int n2;
        if (!this.zzh.zzb() && !this.zzh.zzc()) {
            return false;
        }
        zzlc.zza();
        int n3 = zzako.zzb((DisplayMetrics)this.zzf, (int)this.zzf.widthPixels);
        zzlc.zza();
        int n4 = zzako.zzb((DisplayMetrics)this.zzf, (int)this.zzf.heightPixels);
        Activity activity = this.zza.zza();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbt.zze();
            int[] nArray = zzaij.zza(activity);
            zzlc.zza();
            n2 = zzako.zzb((DisplayMetrics)this.zzf, (int)nArray[0]);
            zzlc.zza();
            n = zzako.zzb((DisplayMetrics)this.zzf, (int)nArray[1]);
        }
        if (this.zzaj == n3 && this.zzai == n4 && this.zzak == n2 && this.zzal == n) {
            return false;
        }
        boolean bl = this.zzaj != n3 || this.zzai != n4;
        this.zzaj = n3;
        this.zzai = n4;
        this.zzak = n2;
        this.zzal = n;
        new zzyn(this).zza(n3, n4, n2, n, this.zzf.density, this.zzan.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbt.zze().zza(map);
        }
        catch (JSONException jSONException) {
            zzahw.zze((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.zzaa()) {
            zzahw.zze((String)"The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    private final synchronized void zzb(String string2) {
        if (!this.zzaa()) {
            this.loadUrl(string2);
            return;
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.zzaa()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                zzbt.zzi().zza(throwable, "AdWebViewImpl.loadUrl");
                zzahw.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                return;
            }
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    private final synchronized void zzc(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            zzbt.zzi().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
            zzahw.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.zzaa()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.zzaa()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zza(String string2, String string3, @Nullable String string4) {
        if (!this.zzaa()) {
            zzny zzny2 = zzoi.zzbw;
            String string5 = (Boolean)zzlc.zzf().zza(zzny2) != false ? zzapp.zza(string3, zzapp.zza()) : string3;
            super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
            return;
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    @TargetApi(value=19)
    private final synchronized void zza(String string2, ValueCallback<String> valueCallback) {
        if (!this.zzaa()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        zzahw.zze((String)"The webview is destroyed. Ignoring action.");
    }

    private final void zzd(String string2) {
        if (com.google.android.gms.common.util.zzs.zze()) {
            if (this.zzan() == null) {
                this.zzam();
            }
            if (this.zzan().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
                return;
            }
            String string3 = String.valueOf(string2);
            this.zzb(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            return;
        }
        String string4 = String.valueOf(string2);
        this.zzb(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
    }

    private final synchronized void zzam() {
        this.zzp = zzbt.zzi().zzc();
        if (this.zzp == null) {
            try {
                String string2 = "(function(){})()";
                this.evaluateJavascript(string2, null);
                this.zza((Boolean)true);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.zza((Boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        zzaor zzaor2 = this;
        synchronized (zzaor2) {
            this.zzp = bl;
        }
        zzbt.zzi().zza(bl);
    }

    private final synchronized Boolean zzan() {
        return this.zzp;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzaor zzaor2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzaor2.zzd(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzahw.zzb((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzd(stringBuilder.toString());
    }

    @Override
    public final void zzn() {
        this.zzaq();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzc.zza);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zza(int n) {
        if (n == 0) {
            zzaor zzaor2 = this;
            zzoo.zza(zzaor2.zzad.zza(), zzaor2.zzab, "aebb2");
        }
        this.zzaq();
        if (this.zzad.zza() != null) {
            this.zzad.zza().zza("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzc.zza);
        this.zza("onhide", hashMap);
    }

    private final void zzaq() {
        zzoo.zza(this.zzad.zza(), this.zzab, "aeh2");
    }

    @Override
    public final void zzo() {
        if (this.zzaa == null) {
            zzoo.zza(this.zzad.zza(), this.zzab, "aes2");
            this.zzaa = zzoo.zza(this.zzad.zza());
            this.zzad.zza("native:view_show", this.zzaa);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzc.zza);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzp() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzbt.zzac().zzb()));
        hashMap.put("app_volume", String.valueOf(zzbt.zzac().zza()));
        hashMap.put("device_volume", String.valueOf(zzaja.zza(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final synchronized zzd zzr() {
        return this.zzi;
    }

    @Override
    public final synchronized zzd zzs() {
        return this.zzaf;
    }

    @Override
    public final synchronized zzaqa zzt() {
        return this.zzj;
    }

    @Override
    public final synchronized String zzu() {
        return this.zzk;
    }

    @Override
    public final synchronized boolean zzw() {
        return this.zzl;
    }

    @Override
    public final zzcv zzx() {
        return this.zzb;
    }

    @Override
    public final zzala zzi() {
        return this.zzc;
    }

    @Override
    public final synchronized boolean zzy() {
        return this.zzn;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbt.zze();
            zzaij.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzahw.zzb((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzh.zzc()) {
            zzaor zzaor2 = this;
            synchronized (zzaor2) {
                if (this.zzx != null) {
                    this.zzx.zza(motionEvent);
                }
            }
        } else if (this.zzb != null) {
            this.zzb.zza(motionEvent);
        }
        if (this.zzaa()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzny zzny2 = zzoi.zzbu;
        if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        boolean bl;
        if (this.zzaa()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzn || this.zzj.zze()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzj.zzf()) {
            float f = 0.0f;
            zzaou zzaou2 = this.zzb();
            if (zzaou2 != null) {
                f = zzaou2.zzg();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n3 = View.MeasureSpec.getSize((int)n);
            int n4 = View.MeasureSpec.getSize((int)n2);
            int n5 = (int)((float)n4 * f);
            int n6 = (int)((float)n3 / f);
            if (n4 == 0 && n6 != 0) {
                n4 = n6;
                n5 = (int)((float)n4 * f);
            } else if (n3 == 0 && n5 != 0) {
                n3 = n5;
                n6 = (int)((float)n3 / f);
            }
            int n7 = Math.min(n5, n3);
            int n8 = Math.min(n6, n4);
            this.setMeasuredDimension(n7, n8);
            return;
        }
        if (this.zzj.zzc()) {
            int n9;
            Object object = zzoi.zzfc;
            if (((Boolean)zzlc.zzf().zza(object)).booleanValue() || !com.google.android.gms.common.util.zzs.zzc()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzaos((zzaor)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            this.zzd(string2);
            float f = this.zzf.density;
            int n10 = View.MeasureSpec.getSize((int)n);
            switch (this.zzz) {
                case -1: {
                    n9 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n9 = (int)((float)this.zzz * f);
                }
            }
            this.setMeasuredDimension(n10, n9);
            return;
        }
        if (this.zzj.zzd()) {
            this.setMeasuredDimension(this.zzf.widthPixels, this.zzf.heightPixels);
            return;
        }
        int n11 = View.MeasureSpec.getMode((int)n);
        int n12 = View.MeasureSpec.getSize((int)n);
        int n13 = View.MeasureSpec.getMode((int)n2);
        int n14 = View.MeasureSpec.getSize((int)n2);
        int n15 = Integer.MAX_VALUE;
        if (n11 == Integer.MIN_VALUE || n11 == 0x40000000) {
            n15 = n12;
        }
        int n16 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n16 = n14;
        }
        boolean bl2 = this.zzj.zzb > n15 || this.zzj.zza > n16;
        zzny zzny2 = zzoi.zzgt;
        if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            boolean bl3;
            boolean bl4 = bl3 = !((float)this.zzj.zzb / this.zzg > (float)n15 / this.zzg) && !((float)this.zzj.zza / this.zzg > (float)n16 / this.zzg);
            bl = bl2 ? bl3 : bl2;
        } else {
            bl = bl2;
        }
        if (bl) {
            float cfr_ignored_0 = this.zzf.density;
            int n17 = (int)((float)this.zzj.zzb / this.zzg);
            int n18 = (int)((float)this.zzj.zza / this.zzg);
            int n19 = (int)((float)n12 / this.zzg);
            int n20 = (int)((float)n14 / this.zzg);
            zzahw.zze((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n17).append("x").append(n18).append(" dp, but only has ").append(n19).append("x").append(n20).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzj.zzb, this.zzj.zza);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzal();
        zzd zzd2 = this.zzr();
        if (zzd2 != null && bl) {
            zzd2.zzo();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzi = zzd2;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzaf = zzd2;
    }

    @Override
    public final synchronized void zza(zzaqa zzaqa2) {
        this.zzj = zzaqa2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzb(boolean bl) {
        boolean bl2 = bl != this.zzn;
        this.zzn = bl;
        this.zzar();
        if (bl2) {
            new zzyn(this).zzc(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzaf() {
        this.zzah.zza();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.zzaa()) {
            this.zzah.zzc();
        }
        boolean bl = this.zzv;
        if (this.zzh != null && this.zzh.zzc()) {
            bl = true;
            if (!this.zzw) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzh.zzd();
                if (onGlobalLayoutListener != null) {
                    zzbt.zzz();
                    zzaor zzaor2 = this;
                    if (zzaor2 == null) {
                        throw null;
                    }
                    zzaml.zza((View)zzaor2, onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzh.zze()) != null) {
                    zzbt.zzz();
                    zzaor zzaor3 = this;
                    if (zzaor3 == null) {
                        throw null;
                    }
                    zzaml.zza((View)zzaor3, onScrollChangedListener);
                }
                this.zzw = true;
            }
            this.zzal();
        }
        this.zzf(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzaor zzaor2 = this;
        synchronized (zzaor2) {
            if (!this.zzaa()) {
                this.zzah.zzd();
            }
            super.onDetachedFromWindow();
            if (this.zzw && this.zzh != null && this.zzh.zzc() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzh.zzd();
                if (onGlobalLayoutListener != null) {
                    zzbt.zzg().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzh.zze()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzw = false;
            }
        }
        this.zzf(false);
    }

    @Override
    public final void zza(Context context) {
        this.zza.setBaseContext(context);
        this.zzah.zza(this.zza.zza());
    }

    @Override
    public final synchronized void zzc(boolean bl) {
        if (this.zzi != null) {
            this.zzi.zza(this.zzh.zzb(), bl);
            return;
        }
        this.zzl = bl;
    }

    @Override
    public final synchronized int zzz() {
        return this.zzq;
    }

    @Override
    public final synchronized void zzb(int n) {
        this.zzq = n;
        if (this.zzi != null) {
            this.zzi.zza(this.zzq);
        }
    }

    @Override
    public final Activity zzd() {
        return this.zza.zza();
    }

    @Override
    public final Context zzq() {
        return this.zza.zzb();
    }

    private final synchronized void zzar() {
        if (this.zzn || this.zzj.zzd()) {
            zzahw.zzb((String)"Enabling hardware acceleration on an overlay.");
            this.zzat();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzahw.zzb((String)"Disabling hardware acceleration on an AdView.");
            this.zzas();
            return;
        }
        zzahw.zzb((String)"Enabling hardware acceleration on an AdView.");
        this.zzat();
    }

    private final synchronized void zzas() {
        if (!this.zzo) {
            zzbt.zzg().zzc((View)this);
        }
        this.zzo = true;
    }

    private final synchronized void zzat() {
        if (this.zzo) {
            zzbt.zzg().zzb((View)this);
        }
        this.zzo = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzaw();
        this.zzah.zzb();
        if (this.zzi != null) {
            this.zzi.zza();
            this.zzi.zzk();
            this.zzi = null;
        }
        this.zzh.zzk();
        if (this.zzm) {
            return;
        }
        zzbt.zzy();
        zzanx.zza(this);
        this.zzav();
        this.zzm = true;
        zzahw.zza("Initiating WebView self destruct sequence in 3...");
        zzahw.zza("Loading blank page in WebView, 2...");
        this.zzc("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzaor zzaor2 = this;
            synchronized (zzaor2) {
                if (!this.zzm) {
                    this.zzh.zzk();
                    zzbt.zzy();
                    zzanx.zza(this);
                    this.zzav();
                    this.zzau();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzab() {
        zzahw.zza("Destroying WebView!");
        this.zzau();
        zzaij.zza.post((Runnable)new zzaot(this));
    }

    private final synchronized void zzau() {
        if (!this.zzag) {
            this.zzag = true;
            zzbt.zzi().zzj();
        }
    }

    @Override
    public final synchronized boolean zzaa() {
        return this.zzm;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.zzaa()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzh != null && this.zzh.zzl() != null) {
            this.zzh.zzl().zza();
        }
    }

    @Override
    public final void zzag() {
        if (this.zzac == null) {
            this.zzac = zzoo.zza(this.zzad.zza());
            this.zzad.zza("native:view_load", this.zzac);
        }
    }

    @Override
    public final void onPause() {
        if (this.zzaa()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.zzaa()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzak() {
        zzahw.zza("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        if (this.zzaa()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzd(boolean bl) {
        this.zzr = bl;
    }

    @Override
    public final synchronized boolean zzac() {
        return this.zzr;
    }

    @Override
    public final synchronized boolean zzad() {
        return this.zzs;
    }

    @Override
    public final synchronized void zzao() {
        this.zzs = true;
        if (this.zzd != null) {
            this.zzd.zzao();
        }
    }

    @Override
    public final synchronized void zzap() {
        this.zzs = false;
        if (this.zzd != null) {
            this.zzd.zzap();
        }
    }

    private final synchronized void zzav() {
        this.zzam = null;
    }

    @Override
    public final synchronized void zza(String string2) {
        this.zzt = string2 == null ? "" : string2;
    }

    @Override
    public final synchronized String zzg() {
        return this.zzt;
    }

    @Override
    public final zzane zza() {
        return null;
    }

    @Override
    public final zzot zzc() {
        return this.zzab;
    }

    @Override
    public final zzou zzh() {
        return this.zzad;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzae = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener zzah() {
        return (View.OnClickListener)this.zzae.get();
    }

    @Override
    public final synchronized void zza(zzpt zzpt2) {
        this.zzx = zzpt2;
    }

    @Override
    public final synchronized zzpt zzai() {
        return this.zzx;
    }

    @Override
    public final synchronized zzaou zzb() {
        return this.zzu;
    }

    @Override
    public final synchronized void zza(zzaou zzaou2) {
        if (this.zzu != null) {
            zzahw.zzc((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzu = zzaou2;
    }

    @Override
    public final synchronized boolean zzae() {
        return this.zzy > 0;
    }

    @Override
    public final synchronized void zze(boolean bl) {
        this.zzy += bl ? 1 : -1;
        if (this.zzy <= 0 && this.zzi != null) {
            this.zzi.zzq();
        }
    }

    private final void zzaw() {
        if (this.zzad == null) {
            return;
        }
        zzov zzov2 = this.zzad.zza();
        if (zzov2 != null && zzbt.zzi().zzb() != null) {
            zzbt.zzi().zzb().zza(zzov2);
        }
    }

    @Override
    public final void zzaj() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zza(boolean bl) {
        this.zzh.zza(bl);
    }

    @Override
    public final void zzf() {
        zzd zzd2 = this.zzr();
        if (zzd2 != null) {
            zzd2.zzp();
        }
    }

    @Override
    public final int zzj() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzk() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzh.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzh.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzh.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzh.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgu zzgu2) {
        zzaor zzaor2 = this;
        synchronized (zzaor2) {
            this.zzv = zzgu2.zza;
        }
        this.zzf(zzgu2.zza);
    }

    private final void zzf(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzt<? super zzaof> zzt2) {
        if (this.zzh != null) {
            this.zzh.zza(string2, zzt2);
        }
    }

    @Override
    public final void zzb(String string2, zzt<? super zzaof> zzt2) {
        if (this.zzh != null) {
            this.zzh.zzb(string2, zzt2);
        }
    }

    @Override
    public final /* synthetic */ zzapu zzv() {
        return this.zzh;
    }

    static /* synthetic */ int zza(zzaor zzaor2) {
        return zzaor2.zzz;
    }

    static /* synthetic */ int zza(zzaor zzaor2, int n) {
        zzaor2.zzz = n;
        return zzaor2.zzz;
    }

    static /* synthetic */ void zzb(zzaor zzaor2) {
        super.destroy();
    }
}

