/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdsz;
import com.google.android.gms.internal.zzdtf;
import com.google.android.gms.internal.zzdtg;
import com.google.android.gms.internal.zzdtl;
import com.google.android.gms.internal.zzdtm;
import com.google.android.gms.internal.zzdwg;
import com.google.android.gms.internal.zzdwj;
import com.google.android.gms.internal.zzdwl;
import com.google.android.gms.internal.zzdwp;
import com.google.android.gms.internal.zzdxb;
import com.google.android.gms.internal.zzfgs;
import com.google.android.gms.internal.zzfjc;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdtn {
    private static final Logger zza = Logger.getLogger(zzdtn.class.getName());
    private static final ConcurrentMap<String, zzdtf> zzb = new ConcurrentHashMap<String, zzdtf>();
    private static final ConcurrentMap<String, Boolean> zzc = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzdsz> zzd = new ConcurrentHashMap<String, zzdsz>();

    public static synchronized <P> void zza(String string2, zzdsz<P> zzdsz2) throws GeneralSecurityException {
        if (zzd.containsKey(string2.toLowerCase())) {
            zzdsz zzdsz3 = (zzdsz)zzd.get(string2.toLowerCase());
            if (!zzdsz2.getClass().equals(zzdsz3.getClass())) {
                String string3 = String.valueOf(string2);
                zza.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzd.put(string2.toLowerCase(), zzdsz2);
    }

    public static <P> zzdsz<P> zza(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzdsz zzdsz2 = (zzdsz)zzd.get(string2.toLowerCase());
        if (zzdsz2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.init().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.init().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.init().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzdsz2;
    }

    public static <P> void zza(String string2, zzdtf<P> zzdtf2) throws GeneralSecurityException {
        zzdtn.zza(string2, zzdtf2, true);
    }

    public static synchronized <P> void zza(String string2, zzdtf<P> zzdtf2, boolean bl) throws GeneralSecurityException {
        if (zzdtf2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (zzb.containsKey(string2)) {
            zzdtf<P> zzdtf3 = zzdtn.zzb(string2);
            boolean bl2 = (Boolean)zzc.get(string2);
            if (!zzdtf2.getClass().equals(zzdtf3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                zza.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzdtf3.getClass().getName(), zzdtf2.getClass().getName()));
            }
        }
        zzb.put(string2, zzdtf2);
        zzc.put(string2, bl);
    }

    private static <P> zzdtf<P> zzb(String string2) throws GeneralSecurityException {
        zzdtf zzdtf2 = (zzdtf)zzb.get(string2);
        if (zzdtf2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        return zzdtf2;
    }

    public static <P> zzdwg zza(zzdwl zzdwl2) throws GeneralSecurityException {
        zzdtf<P> zzdtf2 = zzdtn.zzb(zzdwl2.zzb());
        if (((Boolean)zzc.get(zzdwl2.zzb())).booleanValue()) {
            return zzdtf2.zzc(zzdwl2.zzc());
        }
        String string2 = String.valueOf(zzdwl2.zzb());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzfjc zzb(zzdwl zzdwl2) throws GeneralSecurityException {
        zzdtf<P> zzdtf2 = zzdtn.zzb(zzdwl2.zzb());
        if (((Boolean)zzc.get(zzdwl2.zzb())).booleanValue()) {
            return zzdtf2.zzb(zzdwl2.zzc());
        }
        String string2 = String.valueOf(zzdwl2.zzb());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzfjc zza(String string2, zzfjc zzfjc2) throws GeneralSecurityException {
        zzdtf<P> zzdtf2 = zzdtn.zzb(string2);
        if (((Boolean)zzc.get(string2)).booleanValue()) {
            return zzdtf2.zzb(zzfjc2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zzb(String string2, zzfjc zzfjc2) throws GeneralSecurityException {
        return zzdtn.zzb(string2).zza(zzfjc2);
    }

    private static <P> P zza(String string2, zzfgs zzfgs2) throws GeneralSecurityException {
        return zzdtn.zzb(string2).zza(zzfgs2);
    }

    public static <P> P zza(String string2, byte[] byArray) throws GeneralSecurityException {
        return zzdtn.zza(string2, zzfgs.zza((byte[])byArray));
    }

    public static <P> zzdtl<P> zza(zzdtg zzdtg2, zzdtf<P> zzdtf2) throws GeneralSecurityException {
        zzdwp zzdwp2 = zzdtg2.zza();
        if (zzdwp2.zzd() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
        int n = zzdwp2.zzb();
        boolean bl = false;
        boolean bl2 = true;
        Iterator<zzdwp.zzb> iterator = zzdwp2.zzc().iterator();
        while (iterator.hasNext()) {
            zzdwp.zzb zzb2;
            zzdwp.zzb zzb3 = zzb2 = iterator.next();
            if (!zzb2.zzb()) {
                throw new GeneralSecurityException(String.format("key %d has no key data", zzb3.zze()));
            }
            if (zzb3.zzf() == zzdxb.zza) {
                throw new GeneralSecurityException(String.format("key %d has unknown prefix", zzb3.zze()));
            }
            if (zzb3.zzd() == zzdwj.zza) {
                throw new GeneralSecurityException(String.format("key %d has unknown status", zzb3.zze()));
            }
            if (zzb2.zzd() == zzdwj.zzb && zzb2.zze() == n) {
                if (bl) {
                    throw new GeneralSecurityException("keyset contains multiple primary keys");
                }
                bl = true;
            }
            if (zzb2.zzc().zzd() == zzdwg.zzb.zzd) continue;
            bl2 = false;
        }
        if (!bl && !bl2) {
            throw new GeneralSecurityException("keyset doesn't contain a valid primary key");
        }
        zzdtl zzdtl2 = new zzdtl();
        for (zzdwp.zzb zzb4 : zzdtg2.zza().zzc()) {
            if (zzb4.zzd() != zzdwj.zzb) continue;
            P p = zzdtn.zza(zzb4.zzc().zzb(), zzb4.zzc().zzc());
            zzdtm zzdtm2 = zzdtl2.zza(p, zzb4);
            if (zzb4.zze() != zzdtg2.zza().zzb()) continue;
            zzdtl2.zza(zzdtm2);
        }
        return zzdtl2;
    }
}

