/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdw;
import java.lang.ref.WeakReference;

public final class zzdu
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zza = new Handler(Looper.getMainLooper());
    private final Context zzb;
    private Application zzc;
    private final PowerManager zzd;
    private final KeyguardManager zze;
    private final zzdm zzf;
    private BroadcastReceiver zzg;
    private WeakReference<ViewTreeObserver> zzh;
    private WeakReference<View> zzi;
    private zzda zzj;
    private boolean zzk = false;
    private int zzl = -1;
    private long zzm = -3L;

    public zzdu(zzdm zzdm2, View view) {
        this.zzf = zzdm2;
        this.zzb = zzdm2.zza;
        this.zzd = (PowerManager)this.zzb.getSystemService("power");
        this.zze = (KeyguardManager)this.zzb.getSystemService("keyguard");
        if (this.zzb instanceof Application) {
            this.zzc = (Application)this.zzb;
            this.zzj = new zzda((Application)this.zzb, this);
        }
        this.zza(view);
    }

    final void zza(View view) {
        View view2 = this.zzi != null ? (View)this.zzi.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzc(view2);
        }
        this.zzi = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zzb(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzm = -2L;
            return;
        }
        this.zzm = -3L;
    }

    private final void zzb() {
        zza.post((Runnable)new zzdv(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzl = -1;
        this.zzb(view);
        this.zzc();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzl = -1;
        this.zzc();
        this.zzb();
        this.zzc(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzi == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzi.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzl = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzc();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzc();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzc();
        this.zzb();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzc();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzc();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzc();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzc();
    }

    public final void onGlobalLayout() {
        this.zzc();
    }

    public final void onScrollChanged() {
        this.zzc();
    }

    public final long zza() {
        if (this.zzm == -2L && this.zzi.get() == null) {
            this.zzm = -3L;
        }
        return this.zzm;
    }

    private final void zzc() {
        boolean bl;
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        if (this.zzi == null) {
            return;
        }
        View view2 = (View)this.zzi.get();
        if (view2 == null) {
            this.zzm = -3L;
            this.zzk = false;
            return;
        }
        boolean bl2 = view2.getGlobalVisibleRect(new Rect());
        boolean bl3 = view2.getLocalVisibleRect(new Rect());
        boolean bl4 = this.zzf.zzj() || this.zze.inKeyguardRestrictedInputMode() && (activity = zzds.zza(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0;
        int n = view2.getWindowVisibility();
        int n2 = this.zzl != -1 ? this.zzl : n;
        boolean bl5 = bl = view2.getVisibility() == 0 && view2.isShown() && this.zzd.isScreenOn() && bl4 && bl3 && bl2 && n2 == 0;
        if (this.zzk != bl) {
            this.zzm = bl ? SystemClock.elapsedRealtime() : -2L;
            this.zzk = bl;
        }
    }

    private final void zzb(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzh = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzdu zzdu2 = this;
        if (zzdu2.zzg == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzdu2.zzg = new zzdw(zzdu2);
            zzdu2.zzb.registerReceiver(zzdu2.zzg, intentFilter);
        }
        if (this.zzc != null) {
            try {
                this.zzc.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzc(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzh != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzh.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzh = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzdu zzdu2 = this;
        if (zzdu2.zzg != null) {
            try {
                zzdu2.zzb.unregisterReceiver(zzdu2.zzg);
            }
            catch (Exception exception) {}
            zzdu2.zzg = null;
        }
        if (this.zzc != null) {
            try {
                this.zzc.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzdu zzdu2) {
        zzdu2.zzc();
    }
}

