/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdxi;
import com.google.android.gms.internal.zzdyh;
import com.google.android.gms.internal.zzdyi;
import com.google.android.gms.internal.zzdyl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzdym
implements zzdyi {
    static final int[] zza = zzdym.zza(ByteBuffer.wrap(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107}));
    final zzdyh zzb;
    private final int zzc;

    abstract ByteBuffer zzb(byte[] var1, int var2);

    abstract int zza();

    zzdym(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzb = zzdyh.zza(byArray);
        this.zzc = n;
    }

    @Override
    public final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        int n = byArray.length;
        this.zza();
        if (n > 0x7FFFFFF3) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.zza() + byArray.length);
        this.zza(byteBuffer, byArray);
        return byteBuffer.array();
    }

    final void zza(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byteBuffer.remaining() - this.zza() < byArray.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] byArray2 = zzdyl.zza(this.zza());
        byteBuffer.put(byArray2);
        this.zza(byArray2, byteBuffer, ByteBuffer.wrap(byArray));
    }

    private final void zza(byte[] byArray, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws GeneralSecurityException {
        int n = byteBuffer2.remaining();
        int n2 = n / 64 + 1;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer3 = this.zzb(byArray, i + this.zzc);
            if (i == n2 - 1) {
                zzdxi.zza(byteBuffer, byteBuffer2, byteBuffer3, n % 64);
                continue;
            }
            zzdxi.zza(byteBuffer, byteBuffer2, byteBuffer3, 64);
        }
    }

    static int zza(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    static int[] zza(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }
}

