/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzfy;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzko;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzfv
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object zzb = new Object();
    private final WeakReference<zzahd> zzc;
    private WeakReference<ViewTreeObserver> zzd;
    private final zzhf zze;
    protected final zzft zza;
    private final Context zzf;
    private final WindowManager zzg;
    private final PowerManager zzh;
    private final KeyguardManager zzi;
    private final DisplayMetrics zzj;
    @Nullable
    private zzgc zzk;
    private boolean zzl;
    private boolean zzm = false;
    private boolean zzn = false;
    private boolean zzo;
    private boolean zzp;
    private boolean zzq;
    @Nullable
    private BroadcastReceiver zzr;
    private final HashSet<zzfs> zzs = new HashSet();
    private zzake zzt;
    private final HashSet<zzgq> zzu = new HashSet();
    private final Rect zzv = new Rect();
    private final zzfy zzw;
    private float zzx;

    public zzfv(Context context, zzko zzko2, zzahd zzahd2, zzala zzala2, zzhf zzhf2) {
        this.zzc = new WeakReference<zzahd>(zzahd2);
        this.zze = zzhf2;
        this.zzd = new WeakReference<Object>(null);
        this.zzo = true;
        this.zzq = false;
        this.zzt = new zzake(200L);
        this.zza = new zzft(UUID.randomUUID().toString(), zzala2, zzko2.zza, zzahd2.zzj, zzahd2.zza(), zzko2.zzh);
        this.zzg = (WindowManager)context.getSystemService("window");
        this.zzh = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzi = (KeyguardManager)context.getSystemService("keyguard");
        this.zzf = context;
        this.zzw = new zzfy(this, new Handler());
        this.zzf.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzw);
        this.zzj = context.getResources().getDisplayMetrics();
        Display display = this.zzg.getDefaultDisplay();
        this.zzv.right = display.getWidth();
        this.zzv.bottom = display.getHeight();
        this.zza();
    }

    public final void zza() {
        this.zzx = zzaja.zza(this.zzf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb() {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zzo) {
                this.zzp = true;
                try {
                    JSONObject jSONObject = this.zzi();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzahw.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzahw.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zza.zzd());
                zzahw.zzb((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(int n) {
        Object object = this.zzb;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgq> iterator = this.zzu.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zza()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzo) {
                return;
            }
            View view = this.zze.zza();
            boolean bl3 = view != null && zzbt.zze().zza(view, this.zzh, this.zzi);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zze.zzb()) {
                this.zzb();
                return;
            }
            if (n == 1 && !this.zzt.zza() && bl == this.zzq) {
                return;
            }
            if (!bl && !this.zzq && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzq = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzahw.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfv zzfv2 = this;
            View view2 = zzfv2.zze.zzc().zza();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfv2.zzd.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfv2.zzh();
                    if (!zzfv2.zzl || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfv2.zzl = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfv2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfv2);
                    }
                    zzfv2.zzd = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzg();
            return;
        }
    }

    private final void zzg() {
        if (this.zzk != null) {
            this.zzk.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzc() {
        Object object = this.zzb;
        synchronized (object) {
            return this.zzo;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zza(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zza.zzd());
    }

    final void zzb(Map<String, String> map) {
        this.zza(3);
    }

    final void zza(zzgq zzgq2, Map<String, String> map) {
        String string2 = String.valueOf(this.zza.zzd());
        zzahw.zzb((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgq2);
    }

    final void zzc(Map<String, String> map) {
        boolean bl;
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl2 = bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        zzfv zzfv2 = this;
        Iterator<zzfs> iterator = zzfv2.zzs.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzfv2, bl2);
        }
    }

    private final void zzh() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzd.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzi() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zza.zzb()).put("activeViewJSON", (Object)this.zza.zzc()).put("timestamp", zzbt.zzl().zzb()).put("adFormat", (Object)this.zza.zza()).put("hashCode", (Object)this.zza.zzd()).put("isMraid", this.zza.zze()).put("isStopped", this.zzn).put("isPaused", this.zzm).put("isNative", this.zza.zzf()).put("isScreenOn", this.zzj()).put("appMuted", zzbt.zzac().zzb()).put("appVolume", (double)zzbt.zzac().zza()).put("deviceVolume", (double)this.zzx);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfv.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfv zzfv2 = this;
            ArrayList<zzgq> arrayList = new ArrayList<zzgq>(zzfv2.zzu);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgq zzgq2 = arrayList.get(i);
                zzgq2.zza(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzahw.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgq zzgq2) {
        if (this.zzu.isEmpty()) {
            zzfv zzfv2 = this;
            Object object = zzfv2.zzb;
            synchronized (object) {
                if (zzfv2.zzr != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfv2.zzr = new zzfw(zzfv2);
                    zzbt.zzad().zza(zzfv2.zzf, zzfv2.zzr, intentFilter);
                }
            }
            this.zza(3);
        }
        this.zzu.add(zzgq2);
        try {
            JSONObject jSONObject = zzfv.zza(this.zza(this.zze.zza(), null));
            zzgq2.zza(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzahw.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgq zzgq2) {
        this.zzu.remove(zzgq2);
        zzgq2.zzb();
        if (this.zzu.isEmpty()) {
            zzfv zzfv2 = this;
            Object object = zzfv2.zzb;
            synchronized (object) {
                zzfv2.zzh();
                zzfv zzfv3 = zzfv2;
                Object object2 = zzfv3.zzb;
                synchronized (object2) {
                    if (zzfv3.zzr != null) {
                        try {
                            zzbt.zzad().zza(zzfv3.zzf, zzfv3.zzr);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzahw.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbt.zzi().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfv3.zzr = null;
                    }
                }
                zzfv2.zzf.getContentResolver().unregisterContentObserver((ContentObserver)zzfv2.zzw);
                zzfv2.zzo = false;
                zzfv2.zzg();
                zzfv3 = zzfv2;
                ArrayList<zzgq> arrayList = new ArrayList<zzgq>(zzfv3.zzu);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgq zzgq3 = arrayList.get(i);
                    zzgq zzgq4 = zzgq3;
                    zzfv3.zzb(zzgq4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfv zzfv2 = this;
            return zzfv2.zzi().put("isAttachedToWindow", false).put("isScreenOn", zzfv2.zzj()).put("isVisible", false);
        }
        boolean bl2 = zzbt.zzg().zza(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzi();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfv.zza(this.zzv.top, this.zzj)).put("bottom", zzfv.zza(this.zzv.bottom, this.zzj)).put("left", zzfv.zza(this.zzv.left, this.zzj)).put("right", zzfv.zza(this.zzv.right, this.zzj))).put("adBox", (Object)new JSONObject().put("top", zzfv.zza(rect.top, this.zzj)).put("bottom", zzfv.zza(rect.bottom, this.zzj)).put("left", zzfv.zza(rect.left, this.zzj)).put("right", zzfv.zza(rect.right, this.zzj))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfv.zza(rect2.top, this.zzj)).put("bottom", zzfv.zza(rect2.bottom, this.zzj)).put("left", zzfv.zza(rect2.left, this.zzj)).put("right", zzfv.zza(rect2.right, this.zzj))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfv.zza(rect3.top, this.zzj)).put("bottom", zzfv.zza(rect3.bottom, this.zzj)).put("left", zzfv.zza(rect3.left, this.zzj)).put("right", zzfv.zza(rect3.right, this.zzj))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfv.zza(rect4.top, this.zzj)).put("bottom", zzfv.zza(rect4.bottom, this.zzj)).put("left", zzfv.zza(rect4.left, this.zzj)).put("right", zzfv.zza(rect4.right, this.zzj))).put("screenDensity", (double)this.zzj.density);
        if (bl == null) {
            bl = zzbt.zze().zza(view, this.zzh, this.zzi);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean zzj() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzh.isInteractive();
        }
        return this.zzh.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zza(1);
    }

    public final void onGlobalLayout() {
        this.zza(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgc zzgc2) {
        Object object = this.zzb;
        synchronized (object) {
            this.zzk = zzgc2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        Object object = this.zzb;
        synchronized (object) {
            this.zzn = true;
            this.zza(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zze() {
        Object object = this.zzb;
        synchronized (object) {
            this.zzm = true;
            this.zza(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf() {
        Object object = this.zzb;
        synchronized (object) {
            this.zzm = false;
            this.zza(3);
            return;
        }
    }
}

