/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzgr
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zza;
    private final Context zzb;
    private Application zzc;
    private final WindowManager zzd;
    private final PowerManager zze;
    private final KeyguardManager zzf;
    @Nullable
    private BroadcastReceiver zzg;
    private WeakReference<ViewTreeObserver> zzh;
    private WeakReference<View> zzi;
    private zzgw zzj;
    private zzake zzk = new zzake(zza);
    private boolean zzl = false;
    private int zzm = -1;
    private final HashSet<zzgv> zzn = new HashSet();
    private final DisplayMetrics zzo;
    private final Rect zzp;

    public zzgr(Context context, View view) {
        this.zzb = context.getApplicationContext();
        this.zzd = (WindowManager)context.getSystemService("window");
        this.zze = (PowerManager)this.zzb.getSystemService("power");
        this.zzf = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzb instanceof Application) {
            this.zzc = (Application)this.zzb;
            this.zzj = new zzgw((Application)this.zzb, this);
        }
        this.zzo = context.getResources().getDisplayMetrics();
        this.zzp = new Rect();
        this.zzp.right = this.zzd.getDefaultDisplay().getWidth();
        this.zzp.bottom = this.zzd.getDefaultDisplay().getHeight();
        View view2 = view;
        zzgr zzgr2 = this;
        View view3 = zzgr2.zzi != null ? (View)zzgr2.zzi.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgr2);
            zzgr2.zzb(view3);
        }
        zzgr2.zzi = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbt.zzg().zza(view2)) {
                zzgr2.zza(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgr2);
        }
    }

    public final void zza(zzgv zzgv2) {
        this.zzn.add(zzgv2);
        this.zza(3);
    }

    public final void zzb(zzgv zzgv2) {
        this.zzn.remove(zzgv2);
    }

    private final void zzb() {
        zzbt.zze();
        zzaij.zza.post((Runnable)new zzgs(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzm = -1;
        this.zza(view);
        this.zza(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzm = -1;
        this.zza(3);
        this.zzb();
        this.zzb(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzi == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzi.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzm = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zza(3);
        this.zzb();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zza(3);
        this.zzb();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zza(3);
        this.zzb();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zza(3);
        this.zzb();
    }

    public final void onActivityStopped(Activity activity) {
        this.zza(3);
        this.zzb();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zza(3);
        this.zzb();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zza(3);
        this.zzb();
    }

    public final void onGlobalLayout() {
        this.zza(2);
        this.zzb();
    }

    public final void onScrollChanged() {
        this.zza(1);
    }

    public final void zza() {
        this.zza(4);
    }

    private final void zza(int n) {
        boolean bl;
        if (this.zzn.size() == 0) {
            return;
        }
        if (this.zzi == null) {
            return;
        }
        View view = (View)this.zzi.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzm != -1 ? this.zzm : n2;
        boolean bl6 = bl = !bl3 && zzbt.zze().zza(view, this.zze, this.zzf) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzk.zza() && bl == this.zzl) {
            return;
        }
        if (!bl && !this.zzl && n == 1) {
            return;
        }
        zzgu zzgu2 = new zzgu(zzbt.zzl().zzb(), this.zze.isScreenOn(), view != null ? zzbt.zzg().zza(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(this.zzp), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzo.density, bl);
        Iterator<zzgv> iterator = this.zzn.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgu2);
        }
        this.zzl = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzb(rect.left), this.zzb(rect.top), this.zzb(rect.right), this.zzb(rect.bottom));
    }

    private final int zzb(int n) {
        float f = this.zzo.density;
        return (int)((float)n / f);
    }

    private final void zza(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzh = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzgr zzgr2 = this;
        if (zzgr2.zzg == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzgr2.zzg = new zzgt(zzgr2);
            zzbt.zzad().zza(zzgr2.zzb, zzgr2.zzg, intentFilter);
        }
        if (this.zzc != null) {
            try {
                this.zzc.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
                return;
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzb(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzh != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzh.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzh = null;
            }
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzgr zzgr2 = this;
        if (zzgr2.zzg != null) {
            try {
                zzbt.zzad().zza(zzgr2.zzb, zzgr2.zzg);
            }
            catch (IllegalStateException illegalStateException) {
                zzahw.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbt.zzi().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzgr2.zzg = null;
        }
        if (this.zzc != null) {
            try {
                this.zzc.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
                return;
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzgr zzgr2, int n) {
        zzgr2.zza(3);
    }

    static {
        zzny zzny2 = zzoi.zzdf;
        zza = (Long)zzlc.zzf().zza(zzny2);
    }
}

