/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaeb;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzuu;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzabh
@Hide
public final class zzuo {
    private final Map<zzup, zzuq> zza = new HashMap<zzup, zzuq>();
    private final LinkedList<zzup> zzb = new LinkedList();
    @Nullable
    private zztk zzc;

    final void zza(zztk zztk2) {
        if (this.zzc == null) {
            this.zzc = zztk2.zzb();
            zzuo zzuo2 = this;
            if (zzuo2.zzc != null) {
                SharedPreferences sharedPreferences = zzuo2.zzc.zza().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zzuo zzuo3 = zzuo2;
                while (zzuo3.zzb.size() > 0) {
                    zzup zzup2 = zzuo3.zzb.remove();
                    zzuq zzuq2 = zzuo3.zza.get(zzup2);
                    zzuo.zza("Flushing interstitial queue for %s.", zzup2);
                    while (zzuq2.zzd() > 0) {
                        zzuq2.zza(null).zza.zzav();
                    }
                    zzuo3.zza.remove(zzup2);
                }
                try {
                    zzup zzup2;
                    HashMap<String, zzup> hashMap = new HashMap<String, zzup>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzuu zzuu2 = zzuu.zza((String)stringArray.getValue());
                        zzup2 = new zzup(zzuu2.zza, zzuu2.zzb, zzuu2.zzc);
                        if (zzuo2.zza.containsKey(zzup2)) continue;
                        zzuq zzuq2 = new zzuq(zzuu2.zza, zzuu2.zzb, zzuu2.zzc);
                        zzuo2.zza.put(zzup2, zzuq2);
                        hashMap.put(zzup2.toString(), zzup2);
                        zzuo.zza("Restored interstitial queue for %s.", zzup2);
                    }
                    for (String string2 : zzuo.zza(sharedPreferences.getString("PoolKeys", ""))) {
                        zzup2 = (zzup)hashMap.get(string2);
                        if (!zzuo2.zza.containsKey(zzup2)) continue;
                        zzuo2.zzb.add(zzup2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbt.zzi().zza(exception, "InterstitialAdPool.restore");
                    zzahw.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zzuo2.zza.clear();
                    zzuo2.zzb.clear();
                }
            }
        }
    }

    @Nullable
    final zzur zza(zzkk zzkk2, String string2) {
        Object object;
        Object object2;
        zzny zzny2;
        String string3;
        if (zzuo.zzb(string2)) {
            return null;
        }
        Context context = this.zzc.zza();
        int n = new zzaeb((Context)context).zza().zzn;
        zzkk zzkk3 = zzuo.zzc(zzkk2);
        zzup zzup2 = new zzup(zzkk3, string3 = zzuo.zzc(string2), n);
        zzuq zzuq2 = this.zza.get(zzup2);
        if (zzuq2 == null) {
            zzuo.zza("Interstitial pool created at %s.", zzup2);
            zzuq2 = new zzuq(zzkk3, string3, n);
            this.zza.put(zzup2, zzuq2);
        }
        this.zzb.remove(zzup2);
        this.zzb.add(zzup2);
        zzuq2.zzg();
        while (true) {
            zzny2 = zzoi.zzcp;
            if (this.zzb.size() <= (Integer)zzlc.zzf().zza(zzny2)) break;
            object2 = this.zzb.remove();
            object = this.zza.get(object2);
            zzuo.zza("Evicting interstitial queue for %s.", (zzup)object2);
            while (((zzuq)object).zzd() > 0) {
                zzur zzur2 = ((zzuq)object).zza((zzkk)null);
                if (zzur2.zze) {
                    zzus.zza().zzc();
                }
                zzur2.zza.zzav();
            }
            this.zza.remove(object2);
        }
        while (zzuq2.zzd() > 0) {
            object2 = zzuq2.zza(zzkk3);
            if (((zzur)object2).zze) {
                zzny2 = zzoi.zzcr;
                if (zzbt.zzl().zza() - ((zzur)object2).zzd > 1000L * (long)((Integer)zzlc.zzf().zza(zzny2)).intValue()) {
                    zzuo.zza("Expired interstitial at %s.", zzup2);
                    zzus.zza().zzb();
                    continue;
                }
            }
            object = ((zzur)object2).zzb != null ? " (inline) " : " ";
            zzuo.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zzup2);
            return object2;
        }
        return null;
    }

    final void zzb(zzkk zzkk2, String string2) {
        String string3;
        if (this.zzc == null) {
            return;
        }
        Context context = this.zzc.zza();
        int n = new zzaeb((Context)context).zza().zzn;
        zzkk zzkk3 = zzuo.zzc(zzkk2);
        zzup zzup2 = new zzup(zzkk3, string3 = zzuo.zzc(string2), n);
        zzuq zzuq2 = this.zza.get(zzup2);
        if (zzuq2 == null) {
            zzuo.zza("Interstitial pool created at %s.", zzup2);
            zzuq2 = new zzuq(zzkk3, string3, n);
            this.zza.put(zzup2, zzuq2);
        }
        zzuq2.zza(this.zzc, zzkk2);
        zzuq2.zzg();
        zzuo.zza("Inline entry added to the queue at %s.", zzup2);
    }

    final void zza() {
        zzuo zzuo2;
        if (this.zzc == null) {
            return;
        }
        for (Map.Entry<zzup, zzuq> entry : this.zza.entrySet()) {
            int n;
            zzup zzup2 = entry.getKey();
            zzuq zzuq2 = entry.getValue();
            if (zzahw.zza((int)2)) {
                n = zzuq2.zzd();
                int n2 = zzuq2.zze();
                if (n2 < n) {
                    zzahw.zza(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzup2));
                }
            }
            n = 0 + zzuq2.zzf();
            while (true) {
                zzuo2 = zzoi.zzcq;
                if (zzuq2.zzd() >= (Integer)zzlc.zzf().zza((zzny)zzuo2)) break;
                zzuo.zza("Pooling and loading one new interstitial for %s.", zzup2);
                if (!zzuq2.zza(this.zzc)) continue;
                ++n;
            }
            zzus.zza().zza(n);
        }
        zzuo2 = this;
        if (zzuo2.zzc != null) {
            SharedPreferences.Editor editor = zzuo2.zzc.zza().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zzup, zzuq> entry : zzuo2.zza.entrySet()) {
                zzup zzup3 = entry.getKey();
                zzuq zzuq3 = entry.getValue();
                if (!zzuq3.zzh()) continue;
                String string2 = new zzuu(zzuq3).zza();
                String string3 = zzup3.toString();
                editor.putString(string3, string2);
                zzuo.zza("Saved interstitial queue for %s.", zzup3);
            }
            editor.putString("PoolKeys", zzuo2.zzb());
            editor.apply();
        }
    }

    private final String zzb() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzb.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzup)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zza(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzb(String string2) {
        try {
            zzny zzny2 = zzoi.zzcs;
            return Pattern.matches((String)zzlc.zzf().zza(zzny2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbt.zzi().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zza(zzkk zzkk2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzkk2.zzc.keySet());
        Bundle bundle = zzkk2.zzm.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzkk zzb(zzkk zzkk2) {
        zzkk zzkk3 = zzuo.zzd(zzkk2);
        String string2 = "_skipMediation";
        zzkk zzkk4 = zzkk3;
        Bundle bundle = zzkk3.zzm.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzkk4.zzc.putBoolean(string2, true);
        return zzkk3;
    }

    private static zzkk zzc(zzkk zzkk2) {
        zzkk zzkk3 = zzuo.zzd(zzkk2);
        zzny zzny2 = zzoi.zzco;
        for (String string2 : ((String)zzlc.zzf().zza(zzny2)).split(",")) {
            zzuo.zza(zzkk3.zzm, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zzuo.zza(zzkk3.zzc, string4);
        }
        return zzkk3;
    }

    private static String zzc(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzkk zzd(zzkk zzkk2) {
        Parcel parcel = Parcel.obtain();
        zzkk2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzkk zzkk3 = (zzkk)zzkk.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzny zzny2 = zzoi.zzcg;
        if (((Boolean)zzlc.zzf().zza(zzny2)).booleanValue()) {
            zzkk3 = zzkk3.zza();
        }
        return zzkk3;
    }

    private static void zza(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zzup zzup2) {
        if (zzahw.zza((int)2)) {
            zzahw.zza(String.format(string2, zzup2));
        }
    }
}

