/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.security.NetworkSecurityPolicy;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahz;
import com.google.android.gms.internal.zzaia;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzalt;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzahy {
    private final Object mLock = new Object();
    private zzalt<?> zzdet;
    private CopyOnWriteArraySet<zzaic> zzdeu = new CopyOnWriteArraySet();
    private SharedPreferences zzbkx;
    SharedPreferences.Editor zzdev;
    private boolean zzdew = false;
    private boolean zzcxd = true;
    private String zzdex;
    private String zzdey;
    private boolean zzcxm = false;
    private String zzddm = "";
    private long zzdez = 0L;
    private long zzdfa = 0L;
    private long zzdfb = 0L;
    private int zzdef = -1;
    private int zzdfc = 0;
    private Set<String> zzdfd = Collections.emptySet();
    private JSONObject zzdfe = new JSONObject();
    private boolean zzcxe = true;
    private boolean zzcxf = true;

    @TargetApi(value=23)
    private static boolean zzql() {
        return Build.VERSION.SDK_INT >= 23 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
    }

    public final void initialize(Context context) {
        Context context2 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        this.zzdet = (zzalt)new zzahz(this, context2).zzns();
    }

    private final void zzqm() {
        if (this.zzdet == null) {
            return;
        }
        if (this.zzdet.isDone()) {
            return;
        }
        try {
            this.zzdet.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzahw.zzc((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzahw.zzb((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzqn() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.mLock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzcxd);
            bundle.putBoolean("content_url_opted_out", this.zzcxe);
            bundle.putBoolean("content_vertical_opted_out", this.zzcxf);
            bundle.putBoolean("auto_collect_location", this.zzcxm);
            bundle.putInt("version_code", this.zzdfc);
            bundle.putStringArray("never_pool_slots", this.zzdfd.toArray(new String[this.zzdfd.size()]));
            bundle.putString("app_settings_json", this.zzddm);
            bundle.putLong("app_settings_last_update_ms", this.zzdez);
            bundle.putLong("app_last_background_time_ms", this.zzdfa);
            bundle.putInt("request_in_session_count", this.zzdef);
            bundle.putLong("first_ad_req_time_ms", this.zzdfb);
            bundle.putString("native_advanced_settings", this.zzdfe.toString());
            if (this.zzdex != null) {
                bundle.putString("content_url_hashes", this.zzdex);
            }
            if (this.zzdey != null) {
                bundle.putString("content_vertical_hashes", this.zzdey);
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzaic zzaic2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdet != null && this.zzdet.isDone()) {
                zzaic2.zzb(this.zzqn());
            }
            this.zzdeu.add(zzaic2);
            return;
        }
    }

    private final void zzc(Bundle bundle) {
        new zzaia(this, bundle).zzns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzaa(boolean bl) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcxd == bl) {
                return;
            }
            this.zzcxd = bl;
            if (this.zzdev != null) {
                this.zzdev.putBoolean("use_https", bl);
                this.zzdev.apply();
            }
            if (!this.zzdew) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("use_https", bl);
                this.zzc(bundle);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqo() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcxd || this.zzdew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzab(boolean bl) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcxe == bl) {
                return;
            }
            this.zzcxe = bl;
            if (this.zzdev != null) {
                this.zzdev.putBoolean("content_url_opted_out", bl);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzcxe);
            bundle.putBoolean("content_vertical_opted_out", this.zzcxf);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqp() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcxe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcb(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdex)) {
                return;
            }
            this.zzdex = string2;
            if (this.zzdev != null) {
                this.zzdev.putString("content_url_hashes", string2);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzqq() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzac(boolean bl) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcxf == bl) {
                return;
            }
            this.zzcxf = bl;
            if (this.zzdev != null) {
                this.zzdev.putBoolean("content_vertical_opted_out", bl);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzcxe);
            bundle.putBoolean("content_vertical_opted_out", this.zzcxf);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqr() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcxf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcc(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdey)) {
                return;
            }
            this.zzdey = string2;
            if (this.zzdev != null) {
                this.zzdev.putString("content_vertical_hashes", string2);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzqs() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzad(boolean bl) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcxm == bl) {
                return;
            }
            this.zzcxm = bl;
            if (this.zzdev != null) {
                this.zzdev.putBoolean("auto_collect_location", bl);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzqt() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcxm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzac(int n) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdfc == n) {
                return;
            }
            this.zzdfc = n;
            if (this.zzdev != null) {
                this.zzdev.putInt("version_code", n);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzqu() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcd(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdfd.contains(string2)) {
                return;
            }
            this.zzdfd.add(string2);
            if (this.zzdev != null) {
                this.zzdev.putStringSet("never_pool_slots", this.zzdfd);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzdfd.toArray(new String[this.zzdfd.size()]));
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzce(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzdfd.contains(string2)) {
                return;
            }
            this.zzdfd.remove(string2);
            if (this.zzdev != null) {
                this.zzdev.putStringSet("never_pool_slots", this.zzdfd);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putStringArray("never_pool_slots", this.zzdfd.toArray(new String[this.zzdfd.size()]));
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcf(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfd.contains(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcg(String string2) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            long l;
            this.zzdez = l = zzbt.zzes().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzddm)) {
                return;
            }
            this.zzddm = string2;
            if (this.zzdev != null) {
                this.zzdev.putString("app_settings_json", string2);
                this.zzdev.putLong("app_settings_last_update_ms", l);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzahh zzqv() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return new zzahh(this.zzddm, this.zzdez);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzj(long l) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdfa == l) {
                return;
            }
            this.zzdfa = l;
            if (this.zzdev != null) {
                this.zzdev.putLong("app_last_background_time_ms", l);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzqw() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzad(int n) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdef == n) {
                return;
            }
            this.zzdef = n;
            if (this.zzdev != null) {
                this.zzdev.putInt("request_in_session_count", n);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzqx() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(long l) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdfb == l) {
                return;
            }
            this.zzdfb = l;
            if (this.zzdev != null) {
                this.zzdev.putLong("first_ad_req_time_ms", l);
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzqy() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, String string3, boolean bl) {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzdfe.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false) == bl) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzbt.zzes().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzdfe.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzahw.zzc((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzdev != null) {
                this.zzdev.putString("native_advanced_settings", this.zzdfe.toString());
                this.zzdev.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzdfe.toString());
            this.zzc((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONObject zzqz() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzra() {
        this.zzqm();
        Object object = this.mLock;
        synchronized (object) {
            this.zzdfe = new JSONObject();
            if (this.zzdev != null) {
                this.zzdev.remove("native_advanced_settings");
                this.zzdev.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzc(bundle);
            return;
        }
    }

    static /* synthetic */ Object zza(zzahy zzahy2) {
        return zzahy2.mLock;
    }

    static /* synthetic */ SharedPreferences zza(zzahy zzahy2, SharedPreferences sharedPreferences) {
        zzahy2.zzbkx = sharedPreferences;
        return zzahy2.zzbkx;
    }

    static /* synthetic */ boolean zza(zzahy zzahy2, boolean bl) {
        zzahy2.zzdew = bl;
        return zzahy2.zzdew;
    }

    static /* synthetic */ boolean zzb(zzahy zzahy2) {
        return zzahy.zzql();
    }

    static /* synthetic */ boolean zzb(zzahy zzahy2, boolean bl) {
        zzahy2.zzcxd = bl;
        return zzahy2.zzcxd;
    }

    static /* synthetic */ boolean zzc(zzahy zzahy2) {
        return zzahy2.zzcxd;
    }

    static /* synthetic */ SharedPreferences zzd(zzahy zzahy2) {
        return zzahy2.zzbkx;
    }

    static /* synthetic */ boolean zzc(zzahy zzahy2, boolean bl) {
        zzahy2.zzcxe = bl;
        return zzahy2.zzcxe;
    }

    static /* synthetic */ boolean zze(zzahy zzahy2) {
        return zzahy2.zzcxe;
    }

    static /* synthetic */ String zza(zzahy zzahy2, String string2) {
        zzahy2.zzdex = string2;
        return zzahy2.zzdex;
    }

    static /* synthetic */ String zzf(zzahy zzahy2) {
        return zzahy2.zzdex;
    }

    static /* synthetic */ boolean zzd(zzahy zzahy2, boolean bl) {
        zzahy2.zzcxm = bl;
        return zzahy2.zzcxm;
    }

    static /* synthetic */ boolean zzg(zzahy zzahy2) {
        return zzahy2.zzcxm;
    }

    static /* synthetic */ boolean zze(zzahy zzahy2, boolean bl) {
        zzahy2.zzcxf = bl;
        return zzahy2.zzcxf;
    }

    static /* synthetic */ boolean zzh(zzahy zzahy2) {
        return zzahy2.zzcxf;
    }

    static /* synthetic */ String zzb(zzahy zzahy2, String string2) {
        zzahy2.zzdey = string2;
        return zzahy2.zzdey;
    }

    static /* synthetic */ String zzi(zzahy zzahy2) {
        return zzahy2.zzdey;
    }

    static /* synthetic */ int zza(zzahy zzahy2, int n) {
        zzahy2.zzdfc = n;
        return zzahy2.zzdfc;
    }

    static /* synthetic */ int zzj(zzahy zzahy2) {
        return zzahy2.zzdfc;
    }

    static /* synthetic */ String zzc(zzahy zzahy2, String string2) {
        zzahy2.zzddm = string2;
        return zzahy2.zzddm;
    }

    static /* synthetic */ String zzk(zzahy zzahy2) {
        return zzahy2.zzddm;
    }

    static /* synthetic */ long zza(zzahy zzahy2, long l) {
        zzahy2.zzdez = l;
        return zzahy2.zzdez;
    }

    static /* synthetic */ long zzl(zzahy zzahy2) {
        return zzahy2.zzdez;
    }

    static /* synthetic */ long zzb(zzahy zzahy2, long l) {
        zzahy2.zzdfa = l;
        return zzahy2.zzdfa;
    }

    static /* synthetic */ long zzm(zzahy zzahy2) {
        return zzahy2.zzdfa;
    }

    static /* synthetic */ int zzb(zzahy zzahy2, int n) {
        zzahy2.zzdef = n;
        return zzahy2.zzdef;
    }

    static /* synthetic */ int zzn(zzahy zzahy2) {
        return zzahy2.zzdef;
    }

    static /* synthetic */ long zzc(zzahy zzahy2, long l) {
        zzahy2.zzdfb = l;
        return zzahy2.zzdfb;
    }

    static /* synthetic */ long zzo(zzahy zzahy2) {
        return zzahy2.zzdfb;
    }

    static /* synthetic */ Set zza(zzahy zzahy2, Set set) {
        zzahy2.zzdfd = set;
        return zzahy2.zzdfd;
    }

    static /* synthetic */ Set zzp(zzahy zzahy2) {
        return zzahy2.zzdfd;
    }

    static /* synthetic */ JSONObject zza(zzahy zzahy2, JSONObject jSONObject) {
        zzahy2.zzdfe = jSONObject;
        return zzahy2.zzdfe;
    }

    static /* synthetic */ Bundle zzq(zzahy zzahy2) {
        return zzahy2.zzqn();
    }

    static /* synthetic */ void zza(zzahy zzahy2, Bundle bundle) {
        zzahy2.zzc(bundle);
    }

    static /* synthetic */ CopyOnWriteArraySet zzr(zzahy zzahy2) {
        return zzahy2.zzdeu;
    }
}

