/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Range;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzabh
@Hide
public final class zzakm {
    private static Map<String, List<Map<String, Object>>> zzdia = new HashMap<String, List<Map<String, Object>>>();
    private static List<MediaCodecInfo> zzdib;
    private static final Object zzdic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static List<Map<String, Object>> zzct(String string2) {
        Object object = zzdic;
        synchronized (object) {
            if (zzdia.containsKey(string2)) {
                return zzdia.get(string2);
            }
            try {
                Object object2 = zzdic;
                synchronized (object2) {
                    if (zzdib != null) {
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        zzdib = Arrays.asList(new MediaCodecList(0).getCodecInfos());
                    } else if (Build.VERSION.SDK_INT >= 16) {
                        int n = MediaCodecList.getCodecCount();
                        zzdib = new ArrayList<MediaCodecInfo>(n);
                        for (int i = 0; i < n; ++i) {
                            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                            zzdib.add(mediaCodecInfo);
                        }
                    } else {
                        zzdib = Collections.emptyList();
                    }
                }
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (MediaCodecInfo mediaCodecInfo : zzdib) {
                    if (mediaCodecInfo.isEncoder() || !Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string2)) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("codecName", mediaCodecInfo.getName());
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string2);
                    ArrayList<Integer[]> arrayList2 = new ArrayList<Integer[]>();
                    for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecCapabilities.profileLevels) {
                        arrayList2.add(new Integer[]{codecProfileLevel.profile, codecProfileLevel.level});
                    }
                    hashMap.put("profileLevels", arrayList2);
                    if (Build.VERSION.SDK_INT >= 21) {
                        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                        hashMap.put("bitRatesBps", zzakm.zza((Range<Integer>)videoCapabilities.getBitrateRange()));
                        hashMap.put("widthAlignment", videoCapabilities.getWidthAlignment());
                        hashMap.put("heightAlignment", videoCapabilities.getHeightAlignment());
                        hashMap.put("frameRates", zzakm.zza((Range<Integer>)videoCapabilities.getSupportedFrameRates()));
                        hashMap.put("widths", zzakm.zza((Range<Integer>)videoCapabilities.getSupportedWidths()));
                        hashMap.put("heights", zzakm.zza((Range<Integer>)videoCapabilities.getSupportedHeights()));
                    }
                    if (Build.VERSION.SDK_INT >= 23) {
                        hashMap.put("instancesLimit", codecCapabilities.getMaxSupportedInstances());
                    }
                    arrayList.add(hashMap);
                }
                zzdia.put(string2, arrayList);
                return arrayList;
            }
            catch (LinkageError | RuntimeException throwable) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("error", throwable.getClass().getSimpleName());
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                arrayList.add(hashMap);
                zzdia.put(string2, arrayList);
                return arrayList;
            }
        }
    }

    @TargetApi(value=21)
    private static Integer[] zza(Range<Integer> range) {
        return new Integer[]{(Integer)range.getLower(), (Integer)range.getUpper()};
    }

    static {
        zzdic = new Object();
    }
}

