/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.internal.zzand;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzov;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzabh
@Hide
public final class zzanb
extends FrameLayout
implements zzamy {
    private final zzann zzdlg;
    private final FrameLayout zzdlh;
    private final zzov zzdli;
    private final zzanp zzdlj;
    private final long zzdlk;
    @Nullable
    private zzamz zzdll;
    private boolean zzdlm;
    private boolean zzdln;
    private boolean zzdlo;
    private boolean zzdlp;
    private long zzdlq;
    private long zzdlr;
    private String zzdls;
    private Bitmap zzdlt;
    private ImageView zzdlu;
    private boolean zzdlv;

    public static void zza(zzann zzann2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzann2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzann zzann2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzann2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzann zzann2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzann2.zza("onVideoEvent", hashMap);
    }

    public zzanb(Context context, zzann zzann2, int n, boolean bl, zzov zzov2, zzanm zzanm2) {
        super(context);
        zzny zzny2;
        this.zzdlg = zzann2;
        this.zzdli = zzov2;
        this.zzdlh = new FrameLayout(context);
        this.addView((View)this.zzdlh, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzv((Object)zzann2.zzbo());
        this.zzdll = zzann2.zzbo().zzaol.zza(context, zzann2, n, bl, zzov2, zzanm2);
        if (this.zzdll != null) {
            this.zzdlh.addView((View)this.zzdll, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzny2 = zzoi.zzbmd;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue()) {
                this.zzsx();
            }
        }
        this.zzdlu = new ImageView(context);
        zzny2 = zzoi.zzbmh;
        this.zzdlk = (Long)zzlc.zzio().zzd(zzny2);
        zzny2 = zzoi.zzbmf;
        this.zzdlp = (Boolean)zzlc.zzio().zzd(zzny2);
        if (this.zzdli != null) {
            this.zzdli.zzf("spinner_used", this.zzdlp ? "1" : "0");
        }
        this.zzdlj = new zzanp(this);
        if (this.zzdll != null) {
            this.zzdll.zza(this);
        }
        if (this.zzdll == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzdlh.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzda(String string2) {
        this.zzdls = string2;
    }

    public final void zza(float f, float f2) {
        if (this.zzdll != null) {
            this.zzdll.zza(f, f2);
        }
    }

    public final void zzsu() {
        if (this.zzdll == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzdls)) {
            this.zzdll.setVideoPath(this.zzdls);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzdll == null) {
            return;
        }
        this.zzdll.pause();
    }

    public final void play() {
        if (this.zzdll == null) {
            return;
        }
        this.zzdll.play();
    }

    public final void seekTo(int n) {
        if (this.zzdll == null) {
            return;
        }
        this.zzdll.seekTo(n);
    }

    public final void zzsv() {
        if (this.zzdll == null) {
            return;
        }
        zzamz zzamz2 = this.zzdll;
        zzamz2.zzdlf.setMuted(true);
        zzamz2.zzsn();
    }

    public final void zzsw() {
        if (this.zzdll == null) {
            return;
        }
        zzamz zzamz2 = this.zzdll;
        zzamz2.zzdlf.setMuted(false);
        zzamz2.zzsn();
    }

    public final void zzb(float f) {
        if (this.zzdll == null) {
            return;
        }
        float f2 = f;
        zzamz zzamz2 = this.zzdll;
        zzamz2.zzdlf.zzb(f2);
        zzamz2.zzsn();
    }

    @TargetApi(value=14)
    public final void zzf(MotionEvent motionEvent) {
        if (this.zzdll == null) {
            return;
        }
        this.zzdll.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzsx() {
        if (this.zzdll == null) {
            return;
        }
        Context context = this.zzdll.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzdll.zzsj());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzdlh.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzdlh.bringChildToFront((View)textView);
    }

    @Override
    public final void zzso() {
        this.zzdlj.resume();
        zzaij.zzdfn.post((Runnable)new zzanc(this));
    }

    @Override
    public final void zzsp() {
        if (this.zzdll == null) {
            return;
        }
        if (this.zzdlr == 0L) {
            float f = (float)this.zzdll.getDuration() / 1000.0f;
            int n = this.zzdll.getVideoWidth();
            int n2 = this.zzdll.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzsq() {
        zzanb zzanb2 = this;
        if (zzanb2.zzdlg.zztj() != null && !zzanb2.zzdln) {
            WindowManager.LayoutParams layoutParams = zzanb2.zzdlg.zztj().getWindow().getAttributes();
            boolean bl = zzanb2.zzdlo = (layoutParams.flags & 0x80) != 0;
            if (!zzanb2.zzdlo) {
                zzanb2.zzdlg.zztj().getWindow().addFlags(128);
                zzanb2.zzdln = true;
            }
        }
        this.zzdlm = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzta();
        this.zzdlm = false;
    }

    @Override
    public final void zzsr() {
        this.zza("ended", new String[0]);
        this.zzta();
    }

    @Override
    public final void zzg(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzss() {
        zzanb zzanb2 = this;
        if (zzanb2.zzdlv && zzanb2.zzdlt != null && !zzanb2.zzsz()) {
            zzanb2.zzdlu.setImageBitmap(zzanb2.zzdlt);
            zzanb2.zzdlu.invalidate();
            zzanb2.zzdlh.addView((View)zzanb2.zzdlu, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzanb2.zzdlh.bringChildToFront((View)zzanb2.zzdlu);
        }
        this.zzdlj.pause();
        this.zzdlr = this.zzdlq;
        zzaij.zzdfn.post((Runnable)new zzand(this));
    }

    public final void destroy() {
        this.zzdlj.pause();
        if (this.zzdll != null) {
            this.zzdll.stop();
        }
        this.zzta();
    }

    final void zzsy() {
        if (this.zzdll == null) {
            return;
        }
        long l = this.zzdll.getCurrentPosition();
        if (this.zzdlq != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzdlq = l;
        }
    }

    @Override
    public final void zzst() {
        zzanb zzanb2;
        if (this.zzdlm && (zzanb2 = this).zzsz()) {
            zzanb2.zzdlh.removeView((View)zzanb2.zzdlu);
        }
        zzanb2 = this;
        if (zzanb2.zzdlt != null) {
            long l = zzbt.zzes().elapsedRealtime();
            if (zzanb2.zzdll.getBitmap(zzanb2.zzdlt) != null) {
                zzanb2.zzdlv = true;
            }
            long l2 = zzbt.zzes().elapsedRealtime() - l;
            if (zzahw.zzqk()) {
                zzahw.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzanb2.zzdlk) {
                zzahw.zzcz((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzanb2.zzdlp = false;
                zzanb2.zzdlt = null;
                if (zzanb2.zzdli != null) {
                    zzanb2.zzdli.zzf("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzf(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzanb zzanb2 = this;
        if (zzanb2.zzdlp) {
            zzny zzny2 = zzoi.zzbmg;
            n4 = Math.max(n4 / (Integer)zzlc.zzio().zzd(zzny2), 1);
            zzny2 = zzoi.zzbmg;
            n3 = Math.max(n3 / (Integer)zzlc.zzio().zzd(zzny2), 1);
            if (zzanb2.zzdlt == null || zzanb2.zzdlt.getWidth() != n4 || zzanb2.zzdlt.getHeight() != n3) {
                zzanb2.zzdlt = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzanb2.zzdlv = false;
            }
        }
    }

    private final boolean zzsz() {
        return this.zzdlu.getParent() != null;
    }

    private final void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzdlg.zza("onVideoEvent", hashMap);
    }

    private final void zzta() {
        if (this.zzdlg.zztj() == null) {
            return;
        }
        if (this.zzdln && !this.zzdlo) {
            this.zzdlg.zztj().getWindow().clearFlags(128);
            this.zzdln = false;
        }
    }

    static /* synthetic */ void zza(zzanb zzanb2, String string2, String[] stringArray) {
        zzanb2.zza(string2, stringArray);
    }
}

