/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzank;

@zzabh
final class zzani
implements SensorEventListener {
    private final SensorManager zzdmf;
    private final Object zzdmg;
    private final Display zzdmh;
    private final float[] zzdmi;
    private final float[] zzdmj;
    private float[] zzdmk;
    private Handler zzdml;
    private zzank zzdmm;

    zzani(Context context) {
        this.zzdmf = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzdmh = windowManager.getDefaultDisplay();
        this.zzdmi = new float[9];
        this.zzdmj = new float[9];
        this.zzdmg = new Object();
    }

    final void start() {
        if (this.zzdml != null) {
            return;
        }
        Sensor sensor = this.zzdmf.getDefaultSensor(11);
        if (sensor == null) {
            zzahw.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzdml = new Handler(handlerThread.getLooper());
        if (!this.zzdmf.registerListener((SensorEventListener)this, sensor, 0, this.zzdml)) {
            zzahw.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzdml == null) {
            return;
        }
        this.zzdmf.unregisterListener((SensorEventListener)this);
        this.zzdml.post((Runnable)new zzanj(this));
        this.zzdml = null;
    }

    final void zza(zzank zzank2) {
        this.zzdmm = zzank2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzani zzani2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzani2.zzdmg;
            synchronized (object) {
                if (zzani2.zzdmk == null) {
                    zzani2.zzdmk = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzani2.zzdmi, (float[])fArray);
            switch (zzani2.zzdmh.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzani2.zzdmi, (int)2, (int)129, (float[])zzani2.zzdmj);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzani2.zzdmi, (int)129, (int)130, (float[])zzani2.zzdmj);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzani2.zzdmi, (int)130, (int)1, (float[])zzani2.zzdmj);
                    break;
                }
                default: {
                    System.arraycopy(zzani2.zzdmi, 0, zzani2.zzdmj, 0, 9);
                }
            }
            zzani2.zzg(1, 3);
            zzani2.zzg(2, 6);
            zzani2.zzg(5, 7);
            Object object2 = zzani2.zzdmg;
            synchronized (object2) {
                System.arraycopy(zzani2.zzdmj, 0, zzani2.zzdmk, 0, 9);
            }
            if (zzani2.zzdmm != null) {
                zzani2.zzdmm.zznm();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzdmg;
        synchronized (object) {
            if (this.zzdmk == null) {
                return false;
            }
            System.arraycopy(this.zzdmk, 0, fArray, 0, this.zzdmk.length);
            return true;
        }
    }

    private final void zzg(int n, int n2) {
        float f = this.zzdmj[n];
        this.zzdmj[n] = this.zzdmj[n2];
        this.zzdmj[n2] = f;
    }
}

