/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzajn;
import com.google.android.gms.internal.zzajp;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzov;
import java.util.concurrent.TimeUnit;

@zzabh
public final class zzano {
    private final Context mContext;
    private final String zzcwj;
    private final zzala zzarg;
    @Nullable
    private final zzot zzdnt;
    @Nullable
    private final zzov zzdli;
    private final zzajn zzdnu = new zzajq().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzrs();
    private final long[] zzdnv;
    private final String[] zzdnw;
    private boolean zzdnx = false;
    private boolean zzdny = false;
    private boolean zzdnz = false;
    private boolean zzdoa = false;
    private boolean zzdlm;
    private zzamz zzdob;
    private boolean zzdoc;
    private boolean zzdod;
    private long zzdoe = -1L;

    public zzano(Context context, zzala zzala2, String string2, @Nullable zzov zzov2, @Nullable zzot zzot2) {
        this.mContext = context;
        this.zzarg = zzala2;
        this.zzcwj = string2;
        this.zzdli = zzov2;
        this.zzdnt = zzot2;
        zzny zzny2 = zzoi.zzbmb;
        String string3 = (String)zzlc.zzio().zzd(zzny2);
        if (string3 == null) {
            this.zzdnw = new String[0];
            this.zzdnv = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzdnw = new String[stringArray.length];
        this.zzdnv = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzdnv[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzahw.zzc((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzdnv[i] = -1L;
            }
        }
    }

    public final void zza(zzamz zzamz2) {
        zzoo.zza(this.zzdli, this.zzdnt, "vpc2");
        this.zzdnx = true;
        if (this.zzdli != null) {
            this.zzdli.zzf("vpn", zzamz2.zzsj());
        }
        this.zzdob = zzamz2;
    }

    public final void zzsp() {
        if (!this.zzdnx || this.zzdny) {
            return;
        }
        zzoo.zza(this.zzdli, this.zzdnt, "vfr2");
        this.zzdny = true;
    }

    public final void onStop() {
        zzny zzny2 = zzoi.zzbma;
        if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && !this.zzdoc) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzcwj);
            bundle.putString("player", this.zzdob.zzsj());
            for (zzajp object : this.zzdnu.getBuckets()) {
                String string2 = String.valueOf("fps_c_");
                String string3 = String.valueOf(object.name);
                bundle.putString(string3.length() != 0 ? string2.concat(string3) : new String(string2), Integer.toString(object.count));
                String string4 = String.valueOf("fps_p_");
                String string5 = String.valueOf(object.name);
                bundle.putString(string5.length() != 0 ? string4.concat(string5) : new String(string4), Double.toString(object.zzdgw));
            }
            for (int i = 0; i < this.zzdnv.length; ++i) {
                String string6 = this.zzdnw[i];
                if (string6 == null) continue;
                String string7 = String.valueOf((Object)this.zzdnv[i]);
                bundle.putString(new StringBuilder(3 + String.valueOf(string7).length()).append("fh_").append(string7).toString(), string6);
            }
            zzbt.zzel().zza(this.mContext, this.zzarg.zzcu, "gmob-apps", bundle, true);
            this.zzdoc = true;
        }
    }

    public final void zzb(zzamz zzamz2) {
        zzano zzano2 = this;
        if (zzano2.zzdnz && !zzano2.zzdoa) {
            zzoo.zza(zzano2.zzdli, zzano2.zzdnt, "vff2");
            zzano2.zzdoa = true;
        }
        long l = zzbt.zzes().nanoTime();
        if (zzano2.zzdlm && zzano2.zzdod && zzano2.zzdoe != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - zzano2.zzdoe);
            zzano2.zzdnu.zza(d);
        }
        zzano2.zzdod = zzano2.zzdlm;
        zzano2.zzdoe = l;
        zzamz zzamz3 = zzamz2;
        zzano2 = this;
        zzny zzny2 = zzoi.zzbmc;
        long l2 = (Long)zzlc.zzio().zzd(zzny2);
        long l3 = zzamz3.getCurrentPosition();
        for (int i = 0; i < zzano2.zzdnw.length; ++i) {
            long l4;
            if (zzano2.zzdnw[i] != null || l2 <= Math.abs(l3 - (l4 = zzano2.zzdnv[i]))) continue;
            String[] stringArray = zzano2.zzdnw;
            Bitmap bitmap = zzamz3.getBitmap(8, 8);
            long l5 = 0L;
            long l6 = 63L;
            for (int j = 0; j < 8; ++j) {
                int n = 0;
                while (n < 8) {
                    int n2 = bitmap.getPixel(n, j);
                    long l7 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2) > 128 ? 1L : 0L;
                    l5 |= l7 << (int)l6;
                    ++n;
                    --l6;
                }
            }
            stringArray[i] = String.format("%016X", l5);
            return;
        }
    }

    public final void zzto() {
        this.zzdlm = true;
        if (this.zzdny && !this.zzdnz) {
            zzoo.zza(this.zzdli, this.zzdnt, "vfp2");
            this.zzdnz = true;
        }
    }

    public final void zztp() {
        this.zzdlm = false;
    }
}

