/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdxu;
import com.google.android.gms.internal.zzdxx;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;

public final class zzdxs {
    static void zza(ECPoint eCPoint, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = zzdxs.zza(ellipticCurve);
        BigInteger bigInteger3 = eCPoint.getAffineX();
        BigInteger bigInteger4 = eCPoint.getAffineY();
        if (bigInteger3 == null || bigInteger4 == null) {
            throw new GeneralSecurityException("point is at infinity");
        }
        if (bigInteger3.signum() == -1 || bigInteger3.compareTo(bigInteger2) != -1) {
            throw new GeneralSecurityException("x is out of range");
        }
        if (bigInteger4.signum() == -1 || bigInteger4.compareTo(bigInteger2) != -1) {
            throw new GeneralSecurityException("y is out of range");
        }
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger4).mod(bigInteger2);
        if (!bigInteger5.equals(bigInteger = bigInteger3.multiply(bigInteger3).add(ellipticCurve.getA()).multiply(bigInteger3).add(ellipticCurve.getB()).mod(bigInteger2))) {
            throw new GeneralSecurityException("Point is not on curve");
        }
    }

    private static BigInteger zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        ECField eCField = ellipticCurve.getField();
        if (eCField instanceof ECFieldFp) {
            return ((ECFieldFp)eCField).getP();
        }
        throw new GeneralSecurityException("Only curves over prime order fields are supported");
    }

    public static int zzb(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzdxs.zza(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    private static ECParameterSpec zzb(String string2, String string3, String string4, String string5, String string6) {
        BigInteger bigInteger = new BigInteger(string2);
        BigInteger bigInteger2 = new BigInteger(string3);
        BigInteger bigInteger3 = new BigInteger("3");
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger3);
        BigInteger bigInteger5 = new BigInteger(string4, 16);
        BigInteger bigInteger6 = new BigInteger(string5, 16);
        BigInteger bigInteger7 = new BigInteger(string6, 16);
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, bigInteger4, bigInteger5);
        ECPoint eCPoint = new ECPoint(bigInteger6, bigInteger7);
        return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger2, 1);
    }

    private static BigInteger zza(BigInteger bigInteger, boolean bl, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        block12: {
            BigInteger bigInteger4;
            bigInteger3 = zzdxs.zza(ellipticCurve);
            BigInteger bigInteger5 = ellipticCurve.getA();
            BigInteger bigInteger6 = ellipticCurve.getB();
            BigInteger bigInteger7 = bigInteger3;
            BigInteger bigInteger8 = bigInteger.multiply(bigInteger).add(bigInteger5).multiply(bigInteger).add(bigInteger6).mod(bigInteger3);
            if (bigInteger7.signum() != 1) {
                throw new InvalidAlgorithmParameterException("p must be positive");
            }
            bigInteger8 = bigInteger8.mod(bigInteger7);
            BigInteger bigInteger9 = null;
            if (bigInteger8.equals(BigInteger.ZERO)) {
                bigInteger4 = BigInteger.ZERO;
            } else {
                BigInteger bigInteger10;
                if (bigInteger7.testBit(0) && bigInteger7.testBit(1)) {
                    bigInteger10 = bigInteger7.add(BigInteger.ONE).shiftRight(2);
                    bigInteger9 = bigInteger8.modPow(bigInteger10, bigInteger7);
                } else if (bigInteger7.testBit(0) && !bigInteger7.testBit(1)) {
                    BigInteger bigInteger11;
                    BigInteger bigInteger12;
                    block13: {
                        bigInteger10 = BigInteger.ONE;
                        BigInteger bigInteger13 = bigInteger7.subtract(BigInteger.ONE).shiftRight(1);
                        int n = 0;
                        do {
                            if ((bigInteger12 = bigInteger10.multiply(bigInteger10).subtract(bigInteger8).mod(bigInteger7)).equals(BigInteger.ZERO)) {
                                bigInteger4 = bigInteger10;
                                break block12;
                            }
                            bigInteger11 = bigInteger12.modPow(bigInteger13, bigInteger7);
                            if (bigInteger11.add(BigInteger.ONE).equals(bigInteger7)) break block13;
                            if (!bigInteger11.equals(BigInteger.ONE)) {
                                throw new InvalidAlgorithmParameterException("p is not prime");
                            }
                            bigInteger10 = bigInteger10.add(BigInteger.ONE);
                        } while (++n != 128 || bigInteger7.isProbablePrime(80));
                        throw new InvalidAlgorithmParameterException("p is not prime");
                    }
                    bigInteger11 = bigInteger7.add(BigInteger.ONE).shiftRight(1);
                    BigInteger bigInteger14 = bigInteger10;
                    BigInteger bigInteger15 = BigInteger.ONE;
                    for (int i = bigInteger11.bitLength() - 2; i >= 0; --i) {
                        BigInteger bigInteger16 = bigInteger14.multiply(bigInteger15);
                        bigInteger14 = bigInteger14.multiply(bigInteger14).add(bigInteger15.multiply(bigInteger15).mod(bigInteger7).multiply(bigInteger12)).mod(bigInteger7);
                        bigInteger15 = bigInteger16.add(bigInteger16).mod(bigInteger7);
                        if (!bigInteger11.testBit(i)) continue;
                        bigInteger16 = bigInteger14.multiply(bigInteger10).add(bigInteger15.multiply(bigInteger12)).mod(bigInteger7);
                        bigInteger15 = bigInteger10.multiply(bigInteger15).add(bigInteger14).mod(bigInteger7);
                        bigInteger14 = bigInteger16;
                    }
                    bigInteger9 = bigInteger14;
                }
                if (bigInteger9 != null && bigInteger9.multiply(bigInteger9).mod(bigInteger7).compareTo(bigInteger8) != 0) {
                    throw new GeneralSecurityException("Could not find a modular square root");
                }
                bigInteger4 = bigInteger2 = bigInteger9;
            }
        }
        if (!bigInteger2.testBit(0)) {
            bigInteger2 = bigInteger3.subtract(bigInteger2).mod(bigInteger3);
        }
        return bigInteger2;
    }

    public static ECParameterSpec zza(zzdxu zzdxu2) throws NoSuchAlgorithmException {
        switch (zzdxu2) {
            case zzmkz: {
                return zzdxs.zzb("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5");
            }
            case zzmla: {
                return zzdxs.zzb("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", "aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", "3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f");
            }
            case zzmlb: {
                return zzdxs.zzb("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", "c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", "11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650");
            }
        }
        String string2 = String.valueOf((Object)zzdxu2);
        throw new NoSuchAlgorithmException(new StringBuilder(22 + String.valueOf(string2).length()).append("curve not implemented:").append(string2).toString());
    }

    public static ECPublicKey zza(zzdxu zzdxu2, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzdxs.zza(zzdxu2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        zzdxs.zza(eCPoint, eCParameterSpec.getCurve());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        return (ECPublicKey)zzdxx.zzmlq.zzoy("EC").generatePublic(eCPublicKeySpec);
    }

    public static KeyPair zza(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = zzdxx.zzmlp.zzoy("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] zza(ECPrivateKey eCPrivateKey, ECPoint eCPoint) throws GeneralSecurityException {
        zzdxs.zza(eCPoint, eCPrivateKey.getParams().getCurve());
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        eCParameterSpec.getCurve();
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(eCPublicKeySpec);
        KeyAgreement keyAgreement = zzdxx.zzmlo.zzoy("ECDH");
        keyAgreement.init(eCPrivateKey);
        keyAgreement.doPhase(publicKey, true);
        byte[] byArray = keyAgreement.generateSecret();
        ECPrivateKey eCPrivateKey2 = eCPrivateKey;
        byte[] byArray2 = byArray;
        EllipticCurve ellipticCurve = eCPrivateKey2.getParams().getCurve();
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.signum() == -1 || bigInteger.compareTo(zzdxs.zza(ellipticCurve)) != -1) {
            throw new GeneralSecurityException("shared secret is out of range");
        }
        zzdxs.zza(bigInteger, true, ellipticCurve);
        return byArray;
    }
}

