/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzabh
@Hide
@TargetApi(value=14)
public final class zzgr
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzaxh;
    private final Context mApplicationContext;
    private Application zzaxi;
    private final WindowManager zzavz;
    private final PowerManager zzawa;
    private final KeyguardManager zzawb;
    @Nullable
    private BroadcastReceiver zzawj;
    private WeakReference<ViewTreeObserver> zzaxj;
    private WeakReference<View> zzaxk;
    private zzgw zzaxl;
    private zzake zzavf = new zzake(zzaxh);
    private boolean zzawi = false;
    private int zzaxm = -1;
    private final HashSet<zzgv> zzaxn = new HashSet();
    private final DisplayMetrics zzaxo;
    private final Rect zzawm;

    public zzgr(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzavz = (WindowManager)context.getSystemService("window");
        this.zzawa = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzawb = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzaxi = (Application)this.mApplicationContext;
            this.zzaxl = new zzgw((Application)this.mApplicationContext, this);
        }
        this.zzaxo = context.getResources().getDisplayMetrics();
        this.zzawm = new Rect();
        this.zzawm.right = this.zzavz.getDefaultDisplay().getWidth();
        this.zzawm.bottom = this.zzavz.getDefaultDisplay().getHeight();
        View view2 = view;
        zzgr zzgr2 = this;
        View view3 = zzgr2.zzaxk != null ? (View)zzgr2.zzaxk.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgr2);
            zzgr2.zzf(view3);
        }
        zzgr2.zzaxk = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbt.zzen().isAttachedToWindow(view2)) {
                zzgr2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzgr2);
        }
    }

    public final void zza(zzgv zzgv2) {
        this.zzaxn.add(zzgv2);
        this.zzm(3);
    }

    public final void zzb(zzgv zzgv2) {
        this.zzaxn.remove(zzgv2);
    }

    private final void zzat() {
        zzbt.zzel();
        zzaij.zzdfn.post((Runnable)new zzgs(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzaxm = -1;
        this.zze(view);
        this.zzm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzaxm = -1;
        this.zzm(3);
        this.zzat();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzaxk == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzaxk.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzaxm = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzat();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzat();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzat();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzm(3);
        this.zzat();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzm(3);
        this.zzat();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzm(3);
        this.zzat();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzm(3);
        this.zzat();
    }

    public final void onGlobalLayout() {
        this.zzm(2);
        this.zzat();
    }

    public final void onScrollChanged() {
        this.zzm(1);
    }

    public final void zzgm() {
        this.zzm(4);
    }

    private final void zzm(int n) {
        boolean bl;
        if (this.zzaxn.size() == 0) {
            return;
        }
        if (this.zzaxk == null) {
            return;
        }
        View view = (View)this.zzaxk.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzaxm != -1 ? this.zzaxm : n2;
        boolean bl6 = bl = !bl3 && zzbt.zzel().zza(view, this.zzawa, this.zzawb) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzavf.tryAcquire() && bl == this.zzawi) {
            return;
        }
        if (!bl && !this.zzawi && n == 1) {
            return;
        }
        zzgu zzgu2 = new zzgu(zzbt.zzes().elapsedRealtime(), this.zzawa.isScreenOn(), view != null ? zzbt.zzen().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(this.zzawm), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzaxo.density, bl);
        Iterator<zzgv> iterator = this.zzaxn.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgu2);
        }
        this.zzawi = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzn(rect.left), this.zzn(rect.top), this.zzn(rect.right), this.zzn(rect.bottom));
    }

    private final int zzn(int n) {
        float f = this.zzaxo.density;
        return (int)((float)n / f);
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzaxj = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzgr zzgr2 = this;
        if (zzgr2.zzawj == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzgr2.zzawj = new zzgt(zzgr2);
            zzbt.zzfk().zza(zzgr2.mApplicationContext, zzgr2.zzawj, intentFilter);
        }
        if (this.zzaxi != null) {
            try {
                this.zzaxi.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaxl);
                return;
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzaxj != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzaxj.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzaxj = null;
            }
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzahw.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzgr zzgr2 = this;
        if (zzgr2.zzawj != null) {
            try {
                zzbt.zzfk().zza(zzgr2.mApplicationContext, zzgr2.zzawj);
            }
            catch (IllegalStateException illegalStateException) {
                zzahw.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbt.zzep().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzgr2.zzawj = null;
        }
        if (this.zzaxi != null) {
            try {
                this.zzaxi.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzaxl);
                return;
            }
            catch (Exception exception) {
                zzahw.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzgr zzgr2, int n) {
        zzgr2.zzm(3);
    }

    static {
        zzny zzny2 = zzoi.zzbqm;
        zzaxh = (Long)zzlc.zzio().zzd(zzny2);
    }
}

