/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzvp;
import com.google.android.gms.internal.zzvq;
import com.google.android.gms.internal.zzvs;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import com.google.android.gms.internal.zzvw;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzwf;
import com.google.android.gms.internal.zzwi;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.internal.zzwo;
import com.google.android.gms.internal.zzxc;
import com.google.android.gms.internal.zzxx;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzabh
@Hide
public final class zzvt
implements zzvx {
    private final String zzcip;
    private final zzwf zzanu;
    private final long zzciq;
    private final zzvq zzcir;
    private final zzvp zzcis;
    private zzkk zzarx;
    private final zzko zzasd;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzala zzapq;
    private final boolean zzavr;
    private final zzqh zzapm;
    private final List<String> zzapn;
    private final List<String> zzcit;
    private final List<String> zzciu;
    private final boolean zzciv;
    private final boolean zzciw;
    private zzwi zzcix;
    private int zzciy = -2;
    private zzwo zzciz;

    public zzvt(Context context, String string2, zzwf zzwf2, zzvq zzvq2, zzvp zzvp2, zzkk zzkk2, zzko zzko2, zzala zzala2, boolean bl, boolean bl2, zzqh zzqh2, List<String> list, List<String> list2, List<String> list3, boolean bl3) {
        this.mContext = context;
        this.zzanu = zzwf2;
        this.zzcis = zzvp2;
        this.zzcip = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzmi() : string2;
        this.zzcir = zzvq2;
        this.zzciq = zzvp2.zzchu != -1L ? zzvp2.zzchu : (zzvq2.zzchu != -1L ? zzvq2.zzchu : 10000L);
        this.zzarx = zzkk2;
        this.zzasd = zzko2;
        this.zzapq = zzala2;
        this.zzavr = bl;
        this.zzciv = bl2;
        this.zzapm = zzqh2;
        this.zzapn = list;
        this.zzcit = list2;
        this.zzciu = list3;
        this.zzciw = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzcix != null) {
                    this.zzcix.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzahw.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzciy = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzmi() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzcis.zzchf)) {
                if (this.zzanu.zzbh(this.zzcis.zzchf)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzahw.zzcz((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzv(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzciy = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzwo zzwo2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzciy = 0;
            this.zzciz = zzwo2;
            this.mLock.notify();
            return;
        }
    }

    private static zzwi zza(MediationAdapter mediationAdapter) {
        return new zzxc(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzvw zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzvs zzvs2 = new zzvs();
            zzaij.zzdfn.post((Runnable)new zzvu(this, zzvs2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzciq;
            zzvt zzvt2 = this;
            while (zzvt2.zzciy == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzvt zzvt3 = zzvt2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzahw.zzcy((String)"Timed out waiting for adapter.");
                    zzvt3.zzciy = 3;
                    continue;
                }
                try {
                    zzvt3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzvt3.zzciy = 5;
                }
            }
            long l14 = zzbt.zzes().elapsedRealtime() - l3;
            return new zzvw(this.zzcis, this.zzcix, this.zzcip, zzvs2, this.zzciy, this.zzmj(), l14);
        }
    }

    private final zzwo zzmj() {
        if (this.zzciy != 0 || !this.zzml()) {
            return null;
        }
        try {
            if (this.zzw(4) && this.zzciz != null && this.zzciz.zzmn() != 0) {
                return this.zzciz;
            }
        }
        catch (RemoteException remoteException) {
            zzahw.zzcz((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzmm();
        return new zzvv(n);
    }

    private final zzwi zzmk() {
        String string2 = String.valueOf(this.zzcip);
        zzahw.zzcy((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzavr && !this.zzcis.zzmh()) {
            zzny zzny2 = zzoi.zzbrb;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcip)) {
                return zzvt.zza((MediationAdapter)new AdMobAdapter());
            }
            zzny2 = zzoi.zzbrc;
            if (((Boolean)zzlc.zzio().zzd(zzny2)).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzcip)) {
                return zzvt.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzcip)) {
                return new zzxc((MediationAdapter)new zzxx());
            }
        }
        try {
            return this.zzanu.zzbg(this.zzcip);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzcip);
            zzahw.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzvs zzvs2) {
        String string2 = this.zzbe(this.zzcis.zzchk);
        try {
            if (this.zzapq.zzdja < 4100000) {
                if (this.zzasd.zzbib) {
                    this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, (zzwl)zzvs2);
                    return;
                }
                this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, (zzwl)zzvs2);
                return;
            }
            if (this.zzavr || this.zzcis.zzmh()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzapn);
                if (this.zzcit != null) {
                    for (String string3 : this.zzcit) {
                        String string4 = ":false";
                        if (this.zzciu != null && this.zzciu.contains(string3)) {
                            string4 = ":true";
                        }
                        String string5 = string4;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("custom:").append(string3).append(string5).toString());
                    }
                }
                this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzcis.zzchb, (zzwl)zzvs2, this.zzapm, arrayList);
                return;
            }
            if (this.zzasd.zzbib) {
                this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzcis.zzchb, (zzwl)zzvs2);
                return;
            }
            if (this.zzciv) {
                if (this.zzcis.zzcho != null) {
                    this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzarx, string2, this.zzcis.zzchb, (zzwl)zzvs2, new zzqh(zzvt.zzbf(this.zzcis.zzchs)), this.zzcis.zzchr);
                    return;
                }
                this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, this.zzcis.zzchb, (zzwl)zzvs2);
                return;
            }
            this.zzcix.zza(zzn.zzz((Object)this.mContext), this.zzasd, this.zzarx, string2, this.zzcis.zzchb, (zzwl)zzvs2);
            return;
        }
        catch (RemoteException remoteException) {
            zzahw.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzv(5);
            return;
        }
    }

    private final boolean zzw(int n) {
        Bundle bundle;
        try {
            bundle = this.zzavr ? this.zzcix.zzms() : (this.zzasd.zzbib ? this.zzcix.getInterstitialAdapterInfo() : this.zzcix.zzmr());
        }
        catch (RemoteException remoteException) {
            zzahw.zzcz((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzml() {
        return this.zzcir.zzcif != -1;
    }

    private final String zzbe(String string2) {
        if (string2 == null || !this.zzml() || this.zzw(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzahw.zzcz((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private final int zzmm() {
        JSONObject jSONObject;
        if (this.zzcis.zzchk == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzcis.zzchk);
        }
        catch (JSONException jSONException) {
            zzahw.zzcz((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcip)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzw(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbf(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string4 = string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string4) ? 2 : ("portrait".equals(string4) ? 1 : ("any".equals(string4) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzahw.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzvt zzvt2) {
        return zzvt2.mLock;
    }

    static /* synthetic */ int zzb(zzvt zzvt2) {
        return zzvt2.zzciy;
    }

    static /* synthetic */ zzwi zza(zzvt zzvt2, zzwi zzwi2) {
        zzvt2.zzcix = zzwi2;
        return zzvt2.zzcix;
    }

    static /* synthetic */ zzwi zzc(zzvt zzvt2) {
        return zzvt2.zzmk();
    }

    static /* synthetic */ zzwi zzd(zzvt zzvt2) {
        return zzvt2.zzcix;
    }

    static /* synthetic */ boolean zze(zzvt zzvt2) {
        return zzvt2.zzml();
    }

    static /* synthetic */ boolean zza(zzvt zzvt2, int n) {
        return zzvt2.zzw(1);
    }

    static /* synthetic */ String zzf(zzvt zzvt2) {
        return zzvt2.zzcip;
    }

    static /* synthetic */ void zza(zzvt zzvt2, zzvs zzvs2) {
        zzvt2.zza(zzvs2);
    }
}

