/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzyb;
import com.google.android.gms.internal.zzyc;
import com.google.android.gms.internal.zzyn;
import java.util.Map;

@zzabh
@Hide
public final class zzya
extends zzyn {
    private final Map<String, String> zzbwu;
    private final Context mContext;
    private String zzcks;
    private long zzckt;
    private long zzcku;
    private String zzckv;
    private String zzckw;

    public zzya(zzaof zzaof2, Map<String, String> map) {
        super(zzaof2, "createCalendarEvent");
        this.zzbwu = map;
        this.mContext = zzaof2.zztj();
        zzya zzya2 = this;
        zzya2.zzcks = zzya2.zzbk("description");
        zzya2.zzckv = zzya2.zzbk("summary");
        zzya2.zzckt = zzya2.zzbl("start_ticks");
        zzya2.zzcku = zzya2.zzbl("end_ticks");
        zzya2.zzckw = zzya2.zzbk("location");
    }

    private final String zzbk(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbwu.get(string2))) {
            return "";
        }
        return this.zzbwu.get(string2);
    }

    private final long zzbl(String string2) {
        String string3 = this.zzbwu.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbm("Activity context is not available.");
            return;
        }
        zzbt.zzel();
        if (!zzaij.zzal(this.mContext).zzjd()) {
            this.zzbm("This feature is not available on the device.");
            return;
        }
        zzbt.zzel();
        AlertDialog.Builder builder = zzaij.zzak(this.mContext);
        Resources resources = zzbt.zzep().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzyb(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzyc(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzcks);
        intent.putExtra("eventLocation", this.zzckw);
        intent.putExtra("description", this.zzckv);
        if (this.zzckt > -1L) {
            intent.putExtra("beginTime", this.zzckt);
        }
        if (this.zzcku > -1L) {
            intent.putExtra("endTime", this.zzcku);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzya zzya2) {
        return zzya2.mContext;
    }
}

