/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzyh;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyn;
import java.util.Map;

@zzabh
@Hide
public final class zzyg
extends zzyn {
    private final Map<String, String> zzbwu;
    private final Context mContext;

    public zzyg(zzaof zzaof2, Map<String, String> map) {
        super(zzaof2, "storePicture");
        this.zzbwu = map;
        this.mContext = zzaof2.zztj();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbm("Activity context is not available");
            return;
        }
        zzbt.zzel();
        if (!zzaij.zzal(this.mContext).zzjc()) {
            this.zzbm("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbwu.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbm("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbm(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbt.zzel();
        if (!zzaij.zzck(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbm(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbt.zzep().getResources();
        zzbt.zzel();
        AlertDialog.Builder builder = zzaij.zzak(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzyh(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzyi(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzyg zzyg2) {
        return zzyg2.mContext;
    }
}

