/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.gmsg;

import android.content.Context;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzvd;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@Keep
@KeepName
public class HttpClient
implements zzu<zzvd> {
    private final Context mContext;
    private final zzaop zzys;

    public HttpClient(Context context, zzaop zzaop2) {
        this.mContext = context;
        this.zzys = zzaop2;
    }

    private static zzb zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzalg.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzmc());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzmh()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzalg.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzc zza(zzb zzb2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            httpURLConnection = (HttpURLConnection)zzb2.zzmd().openConnection();
            zzbv.zzek().zza(this.mContext, this.zzys.zzcx, false, httpURLConnection);
            ArrayList<zza> arrayList = zzb2.zzme();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zza zza2 = arrayList.get(i);
                object2 = zza2;
                httpURLConnection.addRequestProperty(((zza)object2).getKey(), ((zza)object2).getValue());
            }
            byte[] byArray = null;
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzmf())) {
                httpURLConnection.setDoOutput(true);
                byArray = zzb2.zzmf().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                object2 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object2).write(byArray);
                ((FilterOutputStream)object2).close();
            }
            object2 = new zzaoe();
            object2.zza(httpURLConnection, byArray);
            ArrayList<zza> arrayList2 = new ArrayList<zza>();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> object3 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : object3.getValue()) {
                        arrayList2.add(new zza(object3.getKey(), string2));
                    }
                }
            }
            String string3 = zzb2.zzmc();
            int n2 = httpURLConnection.getResponseCode();
            zzbv.zzek();
            zzd zzd2 = new zzd(string3, n2, arrayList2, zzalo.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            object2.zza(httpURLConnection, zzd2.getResponseCode());
            object2.zzdl(zzd2.getBody());
            zzc zzc2 = new zzc(this, true, zzd2, null);
            return zzc2;
        }
        catch (Exception exception) {
            zzc zzc2 = new zzc(this, false, null, exception.toString());
            return zzc2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Keep
    @KeepName
    public JSONObject send(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = new JSONObject();
        String string2 = "";
        try {
            string2 = jSONObject2.optString("http_request_id");
            zzb zzb2 = HttpClient.zzc(jSONObject2);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject4 = HttpClient.zza(zzc2.zzmg());
                jSONObject3.put("response", (Object)jSONObject4);
                jSONObject3.put("success", true);
            } else {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Error executing http request.", (Throwable)exception);
            try {
                jSONObject3.put("response", (Object)new JSONObject().put("http_request_id", (Object)string2));
                jSONObject3.put("success", false);
                jSONObject3.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                zzalg.zzb((String)"Error executing http request.", (Throwable)jSONException);
            }
        }
        return jSONObject3;
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Map map2 = map;
        zzvd zzvd2 = (zzvd)object;
        HttpClient httpClient = this;
        zzalm.zzb(new zzv(httpClient, map2, zzvd2));
    }

    @zzaer
    @VisibleForTesting
    final class zzc {
        private final zzd zzbpz;
        private final boolean zzbqa;
        private final String zzbqb;

        public zzc(HttpClient httpClient, boolean bl, zzd zzd2, String string2) {
            this.zzbqa = bl;
            this.zzbpz = zzd2;
            this.zzbqb = string2;
        }

        public final String getReason() {
            return this.zzbqb;
        }

        public final zzd zzmg() {
            return this.zzbpz;
        }

        public final boolean isSuccess() {
            return this.zzbqa;
        }
    }

    @zzaer
    @VisibleForTesting
    static final class zzd {
        private final String zzbpv;
        private final int zzbqc;
        private final List<zza> zzcf;
        private final String zzblc;

        zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbpv = string2;
            this.zzbqc = n;
            this.zzcf = list;
            this.zzblc = string3;
        }

        public final String zzmc() {
            return this.zzbpv;
        }

        public final int getResponseCode() {
            return this.zzbqc;
        }

        public final Iterable<zza> zzmh() {
            return this.zzcf;
        }

        public final String getBody() {
            return this.zzblc;
        }
    }

    @zzaer
    @VisibleForTesting
    static final class zzb {
        private final String zzbpv;
        private final URL zzbpw;
        private final ArrayList<zza> zzbpx;
        private final String zzbpy;

        zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbpv = string2;
            this.zzbpw = uRL;
            this.zzbpx = arrayList;
            this.zzbpy = string3;
        }

        public final String zzmc() {
            return this.zzbpv;
        }

        public final URL zzmd() {
            return this.zzbpw;
        }

        public final ArrayList<zza> zzme() {
            return this.zzbpx;
        }

        public final String zzmf() {
            return this.zzbpy;
        }
    }

    @zzaer
    @VisibleForTesting
    static final class zza {
        private final String mKey;
        private final String mValue;

        public zza(String string2, String string3) {
            this.mKey = string2;
            this.mValue = string3;
        }

        public final String getKey() {
            return this.mKey;
        }

        public final String getValue() {
            return this.mValue;
        }
    }
}

