/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzabr;
import com.google.android.gms.internal.ads.zzabx;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzalw;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzasm;
import com.google.android.gms.internal.ads.zzatn;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.util.Collections;

@zzaer
public class zzd
extends zzabx
implements zzw {
    @VisibleForTesting
    private static final int zzcax = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity mActivity;
    @VisibleForTesting
    AdOverlayInfoParcel zzcay;
    @VisibleForTesting
    zzasg zzbss;
    @VisibleForTesting
    private zzi zzcaz;
    @VisibleForTesting
    private zzo zzcba;
    @VisibleForTesting
    private boolean zzcbb = false;
    @VisibleForTesting
    private FrameLayout zzcbc;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzcbd;
    @VisibleForTesting
    private boolean zzcbe = false;
    @VisibleForTesting
    private boolean zzcbf = false;
    @VisibleForTesting
    private zzh zzcbg;
    @VisibleForTesting
    private boolean zzcbh = false;
    @VisibleForTesting
    int zzcbi = 0;
    private final Object zzcbj = new Object();
    private Runnable zzcbk;
    private boolean zzcbl;
    private boolean zzcbm;
    private boolean zzcbn = false;
    private boolean zzcbo = false;
    private boolean zzcbp = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzcbi = 2;
        this.mActivity.finish();
    }

    public final void zzos() {
        if (this.zzcay != null && this.zzcbb) {
            this.setRequestedOrientation(this.zzcay.orientation);
        }
        if (this.zzcbc != null) {
            this.mActivity.setContentView((View)this.zzcbg);
            this.zzcbm = true;
            this.zzcbc.removeAllViews();
            this.zzcbc = null;
        }
        if (this.zzcbd != null) {
            this.zzcbd.onCustomViewHidden();
            this.zzcbd = null;
        }
        this.zzcbb = false;
    }

    @Override
    public final void zzot() {
        this.zzcbi = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzcbi = 0;
    }

    public final boolean zzou() {
        this.zzcbi = 0;
        if (this.zzbss == null) {
            return true;
        }
        boolean bl = this.zzbss.zzwc();
        if (!bl) {
            this.zzbss.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcbe = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcay = AdOverlayInfoParcel.zzc(this.mActivity.getIntent());
            if (this.zzcay == null) {
                throw new zzg("Could not get info for ad overlay.");
            }
            if (this.zzcay.zzadg.zzczb > 7500000) {
                this.zzcbi = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcbp = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcbf = this.zzcay.zzcch != null ? this.zzcay.zzcch.zzzr : false;
            if (this.zzcbf && this.zzcay.zzcch.zzzw != -1) {
                new zzj(this, null).zzsd();
            }
            if (bundle == null) {
                if (this.zzcay.zzcby != null && this.zzcbp) {
                    this.zzcay.zzcby.zzcb();
                }
                if (this.zzcay.zzccf != 1 && this.zzcay.zzcbx != null) {
                    this.zzcay.zzcbx.onAdClicked();
                }
            }
            this.zzcbg = new zzh((Context)this.mActivity, this.zzcay.zzccg, this.zzcay.zzadg.zzcx);
            this.zzcbg.setId(1000);
            switch (this.zzcay.zzccf) {
                case 1: {
                    this.zzt(false);
                    return;
                }
                case 2: {
                    this.zzcaz = new zzi(this.zzcay.zzcbz);
                    this.zzt(false);
                    return;
                }
                case 3: {
                    this.zzt(true);
                    return;
                }
            }
            throw new zzg("Could not determine ad overlay type.");
        }
        catch (zzg zzg2) {
            zzalg.zzdp((String)zzg2.getMessage());
            this.zzcbi = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zznl zznl2 = zznw.zzbgq;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            if (this.zzbss != null && !this.zzbss.isDestroyed()) {
                zzbv.zzem();
                zzalw.zzj(this.zzbss);
                return;
            }
            zzalg.zzdp((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzcay.zzcby != null) {
            this.zzcay.zzcby.onResume();
        }
        zznl zznl2 = zznw.zzbgq;
        if (!((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
            if (this.zzbss != null && !this.zzbss.isDestroyed()) {
                zzbv.zzem();
                zzalw.zzj(this.zzbss);
                return;
            }
            zzalg.zzdp((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzos();
        if (this.zzcay.zzcby != null) {
            this.zzcay.zzcby.onPause();
        }
        zznl zznl2 = zznw.zzbgq;
        if (!(((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() || this.zzbss == null || this.mActivity.isFinishing() && this.zzcaz != null)) {
            zzbv.zzem();
            zzalw.zzi(this.zzbss);
        }
        this.zzow();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzq(IObjectWrapper iObjectWrapper) {
        zznl zznl2 = zznw.zzbgp;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() && PlatformVersion.isAtLeastN()) {
            Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            zzbv.zzek();
            if (zzalo.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcbe);
    }

    public final void onStop() {
        zznl zznl2 = zznw.zzbgq;
        if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue() && this.zzbss != null && (!this.mActivity.isFinishing() || this.zzcaz == null)) {
            zzbv.zzem();
            zzalw.zzi(this.zzbss);
        }
        this.zzow();
    }

    public final void onDestroy() {
        if (this.zzbss != null) {
            this.zzcbg.removeView(this.zzbss.getView());
        }
        this.zzow();
    }

    private final void zzs(boolean bl) {
        zznl zznl2 = zznw.zzbgs;
        int n = (Integer)zzkd.zzjd().zzd(zznl2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        this.zzcba = new zzo((Context)this.mActivity, zzp2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzcay.zzccc);
        this.zzcbg.addView((View)this.zzcba, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzax() {
        this.zzcbm = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zznl zznl2 = zznw.zzbbx;
        boolean bl4 = (Boolean)zzkd.zzjd().zzd(zznl2) != false && this.zzcay != null && this.zzcay.zzcch != null && this.zzcay.zzcch.zzzy;
        zznl2 = zznw.zzbby;
        boolean bl5 = bl3 = (Boolean)zzkd.zzjd().zzd(zznl2) != false && this.zzcay != null && this.zzcay.zzcch != null && this.zzcay.zzcch.zzzz;
        if (bl && bl2 && bl4 && !bl3) {
            new zzabr(this.zzbss, "useCustomClose").zzcb("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzcba != null) {
            this.zzcba.zzu(bl3 || bl2 && !bl4);
        }
    }

    public final void zzov() {
        this.zzcbg.removeView((View)this.zzcba);
        this.zzs(true);
    }

    public final void setRequestedOrientation(int n) {
        zznl zznl2 = zznw.zzbik;
        if (this.mActivity.getApplicationInfo().targetSdkVersion >= (Integer)zzkd.zzjd().zzd(zznl2)) {
            zznl2 = zznw.zzbil;
            if (this.mActivity.getApplicationInfo().targetSdkVersion <= (Integer)zzkd.zzjd().zzd(zznl2)) {
                zznl2 = zznw.zzbim;
                if (Build.VERSION.SDK_INT >= (Integer)zzkd.zzjd().zzd(zznl2)) {
                    zznl2 = zznw.zzbin;
                    if (Build.VERSION.SDK_INT <= (Integer)zzkd.zzjd().zzd(zznl2)) {
                        return;
                    }
                }
            }
        }
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcbc = new FrameLayout((Context)this.mActivity);
        this.zzcbc.setBackgroundColor(-16777216);
        this.zzcbc.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcbc);
        this.zzcbm = true;
        this.zzcbd = customViewCallback;
        this.zzcbb = true;
    }

    private final void zzt(boolean bl) throws zzg {
        ViewParent viewParent;
        boolean bl2;
        Window window;
        if (!this.zzcbm) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzg("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (PlatformVersion.isAtLeastN()) {
            zznl zznl2 = zznw.zzbgp;
            if (((Boolean)zzkd.zzjd().zzd(zznl2)).booleanValue()) {
                zzbv.zzek();
                bl3 = zzalo.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzcay.zzcch != null && this.zzcay.zzcch.zzzs;
        if ((!this.zzcbf || bl2) && bl3) {
            window.setFlags(1024, 1024);
            if (PlatformVersion.isAtLeastKitKat() && this.zzcay.zzcch != null && this.zzcay.zzcch.zzzx) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        zzatn zzatn2 = this.zzcay.zzcbz != null ? this.zzcay.zzcbz.zzvv() : null;
        boolean bl5 = zzatn2 != null ? zzatn2.zzfy() : false;
        this.zzcbh = false;
        if (bl5) {
            if (this.zzcay.orientation == zzbv.zzem().zzta()) {
                this.zzcbh = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcay.orientation == zzbv.zzem().zztb()) {
                this.zzcbh = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcbh;
        zzalg.zzco((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcay.orientation);
        if (zzbv.zzem().zza(window)) {
            zzalg.zzco((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcbf) {
            this.zzcbg.setBackgroundColor(-16777216);
        } else {
            this.zzcbg.setBackgroundColor(zzcax);
        }
        this.mActivity.setContentView((View)this.zzcbg);
        this.zzcbm = true;
        if (bl) {
            try {
                zzbv.zzel();
                this.zzbss = zzasm.zza((Context)this.mActivity, this.zzcay.zzcbz != null ? this.zzcay.zzcbz.zzvt() : null, this.zzcay.zzcbz != null ? this.zzcay.zzcbz.zzvu() : null, true, bl5, null, this.zzcay.zzadg, null, null, this.zzcay.zzcbz != null ? this.zzcay.zzcbz.zzbi() : null, zzhv.zzhm());
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzg("Could not obtain webview for the overlay.");
            }
            this.zzbss.zzvv().zza(null, this.zzcay.zzcci, null, this.zzcay.zzcca, this.zzcay.zzcce, true, null, this.zzcay.zzcbz != null ? this.zzcay.zzcbz.zzvv().zzwk() : null, null, null);
            this.zzbss.zzvv().zza(new zze(this));
            if (this.zzcay.url != null) {
                this.zzbss.loadUrl(this.zzcay.url);
            } else if (this.zzcay.zzccd != null) {
                this.zzbss.loadDataWithBaseURL(this.zzcay.zzccb, this.zzcay.zzccd, "text/html", "UTF-8", null);
            } else {
                throw new zzg("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcay.zzcbz != null) {
                this.zzcay.zzcbz.zzb(this);
            }
        } else {
            this.zzbss = this.zzcay.zzcbz;
            this.zzbss.zzbn((Context)this.mActivity);
        }
        this.zzbss.zza(this);
        if (this.zzcay.zzcbz != null) {
            zzd.zzb(this.zzcay.zzcbz.zzvz(), (View)this.zzcbg);
        }
        if ((viewParent = this.zzbss.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbss.getView());
        }
        if (this.zzcbf) {
            this.zzbss.zzwi();
        }
        this.zzcbg.addView(this.zzbss.getView(), -1, -1);
        if (!bl && !this.zzcbh) {
            this.zzoz();
        }
        this.zzs(bl5);
        if (this.zzbss.zzvx()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzow() {
        if (!this.mActivity.isFinishing() || this.zzcbn) {
            return;
        }
        this.zzcbn = true;
        if (this.zzbss != null) {
            int n = this.zzcbi;
            this.zzbss.zzap(n);
            Object object = this.zzcbj;
            synchronized (object) {
                if (!this.zzcbl && this.zzbss.zzwe()) {
                    this.zzcbk = new zzf(this);
                    zznl zznl2 = zznw.zzbbw;
                    zzalo.zzcvi.postDelayed(this.zzcbk, ((Long)zzkd.zzjd().zzd(zznl2)).longValue());
                    return;
                }
            }
        }
        this.zzox();
    }

    @VisibleForTesting
    final void zzox() {
        if (this.zzcbo) {
            return;
        }
        this.zzcbo = true;
        if (this.zzbss != null) {
            this.zzcbg.removeView(this.zzbss.getView());
            if (this.zzcaz != null) {
                this.zzbss.zzbn(this.zzcaz.zzrx);
                this.zzbss.zzaj(false);
                this.zzcaz.parent.addView(this.zzbss.getView(), this.zzcaz.index, this.zzcaz.zzcbt);
                this.zzcaz = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbss.zzbn(this.mActivity.getApplicationContext());
            }
            this.zzbss = null;
        }
        if (this.zzcay != null && this.zzcay.zzcby != null) {
            this.zzcay.zzcby.zzca();
        }
        if (this.zzcay != null && this.zzcay.zzcbz != null) {
            zzd.zzb(this.zzcay.zzcbz.zzvz(), this.zzcay.zzcbz.getView());
        }
    }

    private static void zzb(@Nullable IObjectWrapper iObjectWrapper, @Nullable View view) {
        if (iObjectWrapper != null && view != null) {
            zzbv.zzfb().zza(iObjectWrapper, view);
        }
    }

    public final void zzoy() {
        if (this.zzcbh) {
            this.zzcbh = false;
            this.zzoz();
        }
    }

    private final void zzoz() {
        this.zzbss.zzoz();
    }

    public final void zzpa() {
        this.zzcbg.zzcbs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzpb() {
        Object object = this.zzcbj;
        synchronized (object) {
            this.zzcbl = true;
            if (this.zzcbk != null) {
                zzalo.zzcvi.removeCallbacks(this.zzcbk);
                zzalo.zzcvi.post(this.zzcbk);
            }
            return;
        }
    }
}

