/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzagg;
import com.google.android.gms.internal.ads.zzagh;
import com.google.android.gms.internal.ads.zzalg;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzaer
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LargeParcelTeleporterCreator")
public final class zzagf
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzagf> CREATOR = new zzagh();
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zzcjo;
    private Parcelable zzcjp;
    private boolean zzcjq;

    @SafeParcelable.Constructor
    public zzagf(@SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcjo = parcelFileDescriptor;
        this.zzcjp = null;
        this.zzcjq = true;
    }

    public zzagf(SafeParcelable safeParcelable) {
        this.zzcjo = null;
        this.zzcjp = safeParcelable;
        this.zzcjq = false;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcjq) {
            byte[] byArray;
            if (this.zzcjo == null) {
                zzalg.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcjo));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzalg.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcjp = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcjq = false;
        }
        return (T)((SafeParcelable)this.zzcjp);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzpp();
        Parcel parcel2 = parcel;
        zzagf zzagf2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzagf2.zzcjo, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzpp() {
        if (this.zzcjo == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzcjp.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzcjo = this.zze(byArray);
        }
        return this.zzcjo;
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzagg zzagg2 = new zzagg(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzagg2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzalg.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbv.zzeo().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            IOUtils.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

