/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.gmsg.HttpClient;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.ads.internal.gmsg.zzz;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaet;
import com.google.android.gms.internal.ads.zzafp;
import com.google.android.gms.internal.ads.zzafq;
import com.google.android.gms.internal.ads.zzaft;
import com.google.android.gms.internal.ads.zzagl;
import com.google.android.gms.internal.ads.zzagm;
import com.google.android.gms.internal.ads.zzagp;
import com.google.android.gms.internal.ads.zzagq;
import com.google.android.gms.internal.ads.zzagr;
import com.google.android.gms.internal.ads.zzags;
import com.google.android.gms.internal.ads.zzagv;
import com.google.android.gms.internal.ads.zzahc;
import com.google.android.gms.internal.ads.zzahg;
import com.google.android.gms.internal.ads.zzakn;
import com.google.android.gms.internal.ads.zzalc;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzalo;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzia;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzvr;
import com.google.android.gms.internal.ads.zzwc;
import com.google.android.gms.internal.ads.zzwp;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
public final class zzagk
extends zzalc {
    @VisibleForTesting
    private static final long zzcjx = TimeUnit.SECONDS.toMillis(10L);
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    @VisibleForTesting
    private static boolean zzcjy = false;
    private static zzwc zzcjz = null;
    private static HttpClient zzcka = null;
    private static zzz zzckb = null;
    private static zzu<Object> zzckc = null;
    private final zzaet zzcfv;
    private final zzafq zzcfw;
    private final Object zzccs = new Object();
    private final Context mContext;
    private zzwp zzckd;
    private zzia zzcfy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzagk(Context context, zzafq zzafq2, zzaet zzaet2, zzia zzia2) {
        super(true);
        this.zzcfv = zzaet2;
        this.mContext = context;
        this.zzcfw = zzafq2;
        this.zzcfy = zzia2;
        Object object = sLock;
        synchronized (object) {
            if (!zzcjy) {
                zzckb = new zzz();
                zzcka = new HttpClient(context.getApplicationContext(), zzafq2.zzadg);
                zzckc = new zzags();
                zznl zznl2 = zznw.zzayc;
                zzcjz = new zzwc(this.mContext.getApplicationContext(), this.zzcfw.zzadg, (String)zzkd.zzjd().zzd(zznl2), new zzagr(), new zzagq());
                zzcjy = true;
            }
            return;
        }
    }

    protected static void zzb(zzvr zzvr2) {
        zzvr2.zza("/loadAd", zzckb);
        zzvr2.zza("/fetchHttpRequest", zzcka);
        zzvr2.zza("/invalidRequest", zzckc);
    }

    protected static void zzc(zzvr zzvr2) {
        zzvr2.zzb("/loadAd", zzckb);
        zzvr2.zzb("/fetchHttpRequest", zzcka);
        zzvr2.zzb("/invalidRequest", zzckc);
    }

    @Override
    public final void zzdn() {
        zzalg.zzco((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzbv.zzfj().zzy(this.mContext);
        zzafp zzafp2 = new zzafp(this.zzcfw, -1L, zzbv.zzfj().zzw(this.mContext), zzbv.zzfj().zzx(this.mContext), string2, zzbv.zzfj().zzz(this.mContext));
        zzaft zzaft2 = this.zzc(zzafp2);
        if (!(zzaft2.errorCode != -2 && zzaft2.errorCode != 3 || TextUtils.isEmpty((CharSequence)string2))) {
            zzbv.zzfj().zzh(this.mContext, string2);
        }
        long l = zzbv.zzer().elapsedRealtime();
        zzakn zzakn2 = new zzakn(zzafp2, zzaft2, null, null, zzaft2.errorCode, l, zzaft2.zzcin, null, this.zzcfy);
        zzaoa.zztc.post((Runnable)new zzagl(this, zzakn2));
    }

    private final zzaft zzc(zzafp zzafp2) {
        JSONObject jSONObject;
        zzbv.zzek();
        String string2 = zzalo.zzsw();
        JSONObject jSONObject2 = this.zza(zzafp2, string2);
        if (jSONObject2 == null) {
            return new zzaft(0);
        }
        long l = zzbv.zzer().elapsedRealtime();
        Future<JSONObject> future = zzckb.zzav(string2);
        zzaoa.zztc.post((Runnable)new zzagm(this, jSONObject2, string2));
        long l2 = zzcjx - (zzbv.zzer().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzaft(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzaft(2);
        }
        catch (ExecutionException executionException) {
            return new zzaft(0);
        }
        if (jSONObject == null) {
            return new zzaft(-1);
        }
        zzaft zzaft2 = zzahc.zza(this.mContext, zzafp2, jSONObject.toString());
        if (zzaft2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzaft2.zzcih)) {
            return new zzaft(3);
        }
        return zzaft2;
    }

    private final JSONObject zza(zzafp zzafp2, String string2) {
        Bundle bundle = zzafp2.zzcgm.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzahg zzahg2 = null;
        try {
            zzahg2 = zzbv.zzev().zzs(this.mContext).get();
        }
        catch (Exception exception) {
            zzalg.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        Object object = zzafp2;
        zzagv zzagv2 = new zzagv();
        new zzagv().zzckm = object;
        object = zzahg2;
        v0.zzckn = object;
        JSONObject jSONObject = zzahc.zza(this.mContext, zzagv2);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzalg.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzbv.zzek().zzn(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzccs;
        synchronized (object) {
            zzaoa.zztc.post((Runnable)new zzagp(this));
            return;
        }
    }

    static /* synthetic */ zzz zzpq() {
        return zzckb;
    }

    static /* synthetic */ zzaet zza(zzagk zzagk2) {
        return zzagk2.zzcfv;
    }

    static /* synthetic */ zzwp zzb(zzagk zzagk2) {
        return zzagk2.zzckd;
    }

    static /* synthetic */ zzwp zza(zzagk zzagk2, zzwp zzwp2) {
        zzagk2.zzckd = zzwp2;
        return zzagk2.zzckd;
    }

    static /* synthetic */ zzwc zzpr() {
        return zzcjz;
    }
}

